/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.ecrm.sdk.enumeration.PushECRMStatusEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastFormulaEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastProductEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastSummaryEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastFormulaRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastProductRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastSummaryRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedPredictionTypeEnum;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastSummaryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.UpExpectAuditAmountMonitorDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.AuditDetailedForecastVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastSummaryVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.UpExpectAuditAmountMonitorVo;
import com.biz.crm.tpm.business.warning.config.sdk.service.TpmWarningMonitoringSdkService;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningMonitoringVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="detailedForecastService")
public class DetailedForecastServiceImpl
implements DetailedForecastService {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastServiceImpl.class);
    @Autowired
    private DetailedForecastRepository detailedForecastRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private DetailedForecastFormulaRepository detailedForecastFormulaRepository;
    @Autowired(required=false)
    private DetailedForecastProductRepository detailedForecastProductRepository;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private DetailedForecastSummaryRepository detailedForecastSummaryRepository;
    @Autowired(required=false)
    private EcrmService ecrmService;
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private TpmWarningMonitoringSdkService tpmWarningMonitoringSdkService;

    public Page<DetailedForecastVo> findByForecastsForWebList(Pageable pageable, DetailedForecastDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        dto = (DetailedForecastDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new DetailedForecastDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Assert.hasLength((String)dto.getYearMonthStr(), (String)"\u5e74\u6708[yearMonthStr]\u5fc5\u586b");
        return this.detailedForecastRepository.findByForecastsForWebList(pageable, dto);
    }

    public Page<DetailedForecastVo> findByForecasts(Pageable pageable, DetailedForecastDto detailedForecast) {
        return this.detailedForecastRepository.findByForecasts(pageable, detailedForecast);
    }

    public List<DetailedForecastVo> findByActivityDetailItemCode(Set<String> activityDetailItemCodes) {
        if (CollectionUtil.isEmpty(activityDetailItemCodes)) {
            return Collections.emptyList();
        }
        List<DetailedForecastEntity> list = this.detailedForecastRepository.findByActivityDetailItemCodes(activityDetailItemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<DetailedForecastVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, DetailedForecastEntity.class, DetailedForecastVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public DetailedForecastVo create(DetailedForecastDto detailedForecastDto) {
        DetailedForecastEntity detailedForecastEntity = (DetailedForecastEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailedForecastDto, DetailedForecastEntity.class, null, null, new String[0]));
        detailedForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        detailedForecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailedForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(detailedForecastDto);
        SerializableBiConsumer & Serializable onCreate = DetailedForecastLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DetailedForecastLogEventListener.class, (SerializableBiConsumer)onCreate);
        this.detailedForecastRepository.saveOrUpdate((Object)detailedForecastEntity);
        return (DetailedForecastVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailedForecastEntity, DetailedForecastVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public DetailedForecastVo update(DetailedForecastDto detailedForecastDto) {
        DetailedForecastVo detailedForecastVo = this.findById(detailedForecastDto.getId());
        if (ObjectUtils.isEmpty((Object)detailedForecastVo)) {
            throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        DetailedForecastEntity detailedForecastEntity = (DetailedForecastEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailedForecastVo, DetailedForecastEntity.class, null, null, new String[0]));
        detailedForecastEntity.setEstimatedWriteOffAmount(detailedForecastDto.getEstimatedWriteOffAmount());
        detailedForecastEntity.setActualWriteOffAmount(detailedForecastDto.getActualWriteOffAmount());
        this.detailedForecastRepository.saveOrUpdate((Object)detailedForecastEntity);
        DetailedForecastDto dto = (DetailedForecastDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailedForecastVo, DetailedForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
        logEventDto.setOriginal(dto);
        logEventDto.setNewest(detailedForecastDto);
        SerializableBiConsumer & Serializable onUpdate = DetailedForecastLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DetailedForecastLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return detailedForecastVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DetailedForecastEntity> list = this.detailedForecastRepository.findByIds(idList);
        ArrayList<String> businessCodeList = new ArrayList<String>();
        list.forEach(v -> {
            Validate.isTrue((!StringUtils.equals((CharSequence)DetailedPredictionTypeEnum.CONFIRMED.getDictCode(), (CharSequence)v.getDetailedPredictionType()) ? 1 : 0) != 0, (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801[%s]\u5df2\u786e\u8ba4\uff01", (Object[])new Object[]{v.getActivityDetailItemCode()});
            v.setOnlyKey(this.activityDetailPlanPassDetailedForecastUtil.packageOnlyKey((DetailedForecastEntity)((Object)v), DateUtil.getDate((String)"yyyy-MM-dd HH:mm:ss")));
            if (StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)v.getBusinessUnitCode())) {
                businessCodeList.add(v.getActivityDetailItemCode());
            }
        });
        this.activityDetailPlanPassDetailedForecastUtil.releaseVerticalBudget(businessCodeList);
        this.detailedForecastRepository.removeByIds(idList);
    }

    public DetailedForecastVo findById(String id) {
        DetailedForecastEntity detailedForecastEntity = this.detailedForecastRepository.getById((Serializable)((Object)id));
        if (detailedForecastEntity == null) {
            return null;
        }
        return (DetailedForecastVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailedForecastEntity, DetailedForecastVo.class, null, null, new String[0]);
    }

    public void updateDetailedForecast(DetailedForecastDto detailedForecast) {
        DetailedForecastEntity detailedForecastEntity = (DetailedForecastEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailedForecast, DetailedForecastEntity.class, null, null, new String[0]));
        detailedForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        this.detailedForecastRepository.save(detailedForecastEntity);
    }

    public void importSave(List<DetailedForecastDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        importList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        });
        Collection detailedForecastEntitys = this.nebulaToolkitService.copyCollectionByWhiteList(importList, DetailedForecastDto.class, DetailedForecastEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.detailedForecastRepository.saveBatch(new ArrayList(detailedForecastEntitys));
        importList.forEach(dto -> {
            DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = DetailedForecastLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DetailedForecastLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public void updateAuditAmount(List<String> idList) {
        Validate.notEmpty(idList, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        List<DetailedForecastEntity> forecastEntities = this.detailedForecastRepository.findByIds(idList);
        Validate.notEmpty(forecastEntities, (String)"\u4e0d\u5b58\u5728\u7684\u5b9e\u4f8b,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728", (Object[])new Object[0]);
        forecastEntities.forEach(forecastEntity -> Validate.isTrue((!StringUtils.equals((CharSequence)DetailedPredictionTypeEnum.CONFIRMED.getDictCode(), (CharSequence)forecastEntity.getDetailedPredictionType()) ? 1 : 0) != 0, (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801[%s]\u5df2\u786e\u8ba4\uff01", (Object[])new Object[]{forecastEntity.getActivityDetailItemCode()}));
        MqMessageVo mqMessageVo = new MqMessageVo();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        List ids = forecastEntities.stream().map(UuidEntity::getId).distinct().collect(Collectors.toList());
        this.redisService.hSet("tpm:detailed_forecast_auto_refresh_ids", uuid, (Object)JSON.toJSONString(ids), 172800L);
        mqMessageVo.setMsgBody(uuid);
        mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag("TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST_REFRESH");
        this.rocketMqProducer.sendMqMsg(mqMessageVo);
    }

    public void confirm(List<String> idList) {
        Validate.notEmpty(idList, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        List<DetailedForecastEntity> forecastEntities = this.detailedForecastRepository.findByIds(idList);
        Validate.notEmpty(forecastEntities, (String)"\u4e0d\u5b58\u5728\u7684\u5b9e\u4f8b,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728", (Object[])new Object[0]);
        forecastEntities.forEach(forecastEntity -> {
            Validate.isTrue((!StringUtils.equals((CharSequence)DetailedPredictionTypeEnum.CONFIRMED.getDictCode(), (CharSequence)forecastEntity.getDetailedPredictionType()) ? 1 : 0) != 0, (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801[%s]\u5df2\u786e\u8ba4\uff01", (Object[])new Object[]{forecastEntity.getActivityDetailItemCode()});
            forecastEntity.setDetailedPredictionType(DetailedPredictionTypeEnum.CONFIRMED.getDictCode());
        });
        this.detailedForecastRepository.updateBatchById(forecastEntities);
    }

    public Page<DetailedForecastVo> findForAudit(Pageable pageable, DetailedForecastDto detailedForecast) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(detailedForecast)) {
            detailedForecast = new DetailedForecastDto();
        }
        return this.detailedForecastRepository.findForAudit(pageable, detailedForecast);
    }

    public Map<String, BigDecimal> findPreAuditAmount(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Maps.newHashMap();
        }
        List<DetailedForecastEntity> detailedForecastEntities = this.detailedForecastRepository.findByDetailCodes(detailCodes);
        if (CollectionUtils.isEmpty(detailedForecastEntities)) {
            return Maps.newHashMap();
        }
        return detailedForecastEntities.stream().collect(Collectors.toMap(DetailedForecastEntity::getDetailedCaseCode, DetailedForecastEntity::getEstimatedWriteOffAmount, (k1, k2) -> k1));
    }

    public List<DetailedForecastRequestVo> selectUnSynchronizedAll() {
        return this.detailedForecastRepository.selectUnSynchronizedAll();
    }

    public void updateSynchronousRegime(List<DetailedForecastRequestVo> vos) {
        this.detailedForecastRepository.updateSynchronousRegime(vos);
    }

    public void pushEcrm(List<String> idList) {
        Assert.notEmpty(idList, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List<DetailedForecastEntity> entityList = this.detailedForecastRepository.findByIds(idList);
        Assert.notEmpty(entityList, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u63a8\u9001,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        List unSupportEntity = entityList.stream().filter(o -> !BusinessUnitEnum.isDefaultBusinessUnit((String)o.getBusinessUnitCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(unSupportEntity)) {
            throw new UnsupportedOperationException("\u5b58\u5728\u975e\u4e3b\u4f53\u7ec6\u6848\u9884\u6d4b\u6570\u636e\uff0c\u63a8\u9001\u4e2d\u6b62");
        }
        Map requestEntityMap = entityList.stream().collect(Collectors.toMap(DetailedForecastEntity::getActivityDetailItemCode, Function.identity()));
        Map businessUnitCodeActivityDetailPlanItemCodeMap = entityList.stream().collect(Collectors.groupingBy(DetailedForecastEntity::getBusinessUnitCode, Collectors.mapping(DetailedForecastEntity::getActivityDetailItemCode, Collectors.toSet())));
        ArrayList<DetailedForecastRequestVo> result = new ArrayList<DetailedForecastRequestVo>();
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        beanUtilsBean.getConvertUtils().register(false, true, 0);
        try {
            for (String key : businessUnitCodeActivityDetailPlanItemCodeMap.keySet()) {
                if (!BusinessUnitEnum.isDefaultBusinessUnit((String)key)) continue;
                List activityDetailPlanItemVoList = this.activityDetailPlanItemSdkService.listByItemCodeList(new ArrayList(businessUnitCodeActivityDetailPlanItemCodeMap.get(key)));
                List activityDetailPlanVoList = this.activityDetailPlanSdkService.findByCodes(new ArrayList(activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getDetailPlanCode).collect(Collectors.toSet())));
                Map detailPlanMap = activityDetailPlanVoList.stream().collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, Function.identity()));
                List customerCodeList = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getCustomerCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                List customerVoList = this.customerVoService.findCustomerAndContactByCustomerCodes(customerCodeList);
                Map customerMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                ArrayList salesOrgCodeList = new ArrayList();
                salesOrgCodeList.addAll(customerVoList.stream().map(CustomerVo::getSalesInstitutionCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));
                salesOrgCodeList.addAll(customerVoList.stream().map(CustomerVo::getSalesRegionCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));
                salesOrgCodeList.addAll(customerVoList.stream().map(CustomerVo::getSalesOrgCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));
                List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(salesOrgCodeList);
                Map salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
                for (ActivityDetailPlanItemVo itemVo : activityDetailPlanItemVoList) {
                    CustomerVo customerVo;
                    ActivityDetailPlanVo detailPlanVo = (ActivityDetailPlanVo)detailPlanMap.get(itemVo.getDetailPlanCode());
                    DetailedForecastRequestVo requestVo = (DetailedForecastRequestVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)itemVo, DetailedForecastRequestVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    DetailedForecastEntity entity = (DetailedForecastEntity)((Object)requestEntityMap.get(requestVo.getDetailPlanItemCode()));
                    beanUtilsBean.copyProperties((Object)requestVo, (Object)entity);
                    requestVo.setIntegrationId(entity.getId());
                    requestVo.setDetailPlanItemCode(entity.getActivityDetailItemCode());
                    requestVo.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
                    requestVo.setDetailPlanName(detailPlanVo.getDetailPlanName());
                    if (StringUtils.isEmpty((CharSequence)entity.getPushEcrmStatus())) {
                        requestVo.setProcessStatus(PushECRMStatusEnum.ADD.getCode());
                    } else {
                        requestVo.setProcessStatus(PushECRMStatusEnum.UPDATE.getCode());
                    }
                    requestVo.setActivityTypeCode(itemVo.getActivityTypeCode());
                    requestVo.setActivityTypeName(itemVo.getActivityTypeName());
                    requestVo.setActivityFormCode(itemVo.getActivityFormCode());
                    requestVo.setActivityFormName(itemVo.getActivityFormName());
                    requestVo.setAuditConditionValue(entity.getWriteOffConditionValue());
                    requestVo.setAuditCondition(entity.getWriteOffConditions());
                    requestVo.setAuditFormula(entity.getWriteOffFormula());
                    requestVo.setAuditFormulaValue(entity.getWriteOffFormulaValue());
                    requestVo.setSaleGap(Objects.nonNull(entity.getTaskVolumeGap()) ? entity.getTaskVolumeGap().toString() : null);
                    requestVo.setMonthSaleTask(itemVo.getMonthSalesTarget());
                    requestVo.setNowSpreadMarketRatio(Objects.nonNull(itemVo.getCurrentMarketRate()) ? itemVo.getCurrentMarketRate().toString() : null);
                    requestVo.setMonthSpreadMarketRatio(Objects.nonNull(itemVo.getMonthTargetMarketRate()) ? itemVo.getMonthTargetMarketRate().toString() : null);
                    requestVo.setIsLaunchPatrolDemand(itemVo.getIsStartPatrol());
                    requestVo.setPromoteSales(itemVo.getPeriodPromoteQuantity());
                    requestVo.setPromotionAmount(itemVo.getPeriodPromoteAmount());
                    requestVo.setPromoteChannelSales(itemVo.getPeriodChPromoteQuantity());
                    requestVo.setPromotionChannelAmount(itemVo.getPeriodChPromoteAmount());
                    requestVo.setMonthReplyQuantity(itemVo.getMonthReturnQuantity());
                    requestVo.setMonthReplyAmount(itemVo.getMonthReturnAmount());
                    requestVo.setStoreType(itemVo.getTerminalType());
                    requestVo.setTerminalPredictMonthSaleAmount(itemVo.getTerminalMonthSalesAmount());
                    requestVo.setUserName(itemVo.getPersonName());
                    requestVo.setPersonnelType(itemVo.getPersonType());
                    requestVo.setIdCard(itemVo.getPersonIdCard());
                    requestVo.setPrice(itemVo.getMaterialPrice());
                    requestVo.setStandeesDisplayQuantity(Objects.nonNull(itemVo.getQuantity()) ? new BigDecimal(itemVo.getQuantity()) : null);
                    requestVo.setStandeesDisplayPrice(itemVo.getPrice());
                    requestVo.setPurchaseType(itemVo.getProcurementType());
                    requestVo.setDescription(itemVo.getFormDescription());
                    requestVo.setTotalCost(itemVo.getTotalFeeAmount());
                    requestVo.setDealerBearFee(itemVo.getCustomerFeeAmount());
                    requestVo.setApplyFee(itemVo.getHeadFeeAmount());
                    requestVo.setProductName(itemVo.getProductName());
                    if (Objects.nonNull(itemVo.getDepartmentFeeAmount())) {
                        if (Objects.isNull(requestVo.getApplyFee())) {
                            requestVo.setApplyFee(itemVo.getDepartmentFeeAmount());
                        } else {
                            requestVo.setApplyFee(requestVo.getApplyFee().add(itemVo.getDepartmentFeeAmount()));
                        }
                    }
                    requestVo.setEstimateAuditAmount(entity.getEstimatedWriteOffAmount());
                    if (StringUtils.isNotEmpty((CharSequence)itemVo.getCustomerCode()) && (customerVo = (CustomerVo)customerMap.get(itemVo.getCustomerCode())) != null) {
                        SalesOrgVo salesOrg;
                        SalesOrgVo region;
                        SalesOrgVo area;
                        requestVo.setCustomerCode(customerVo.getErpCode());
                        requestVo.setCustomerName(customerVo.getCustomerName());
                        if (StringUtils.isNotEmpty((CharSequence)customerVo.getSalesInstitutionCode()) && (area = (SalesOrgVo)salesOrgMap.get(customerVo.getSalesInstitutionCode())) != null) {
                            requestVo.setSalesInstitutionCode(area.getErpCode());
                            requestVo.setSalesInstitutionName(area.getSalesOrgName());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)customerVo.getSalesRegionCode()) && (region = (SalesOrgVo)salesOrgMap.get(customerVo.getSalesRegionCode())) != null) {
                            requestVo.setSalesOrgRegionCode(region.getErpCode());
                            requestVo.setSalesOrgRegionName(region.getSalesOrgName());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)customerVo.getSalesRegionCode()) && (salesOrg = (SalesOrgVo)salesOrgMap.get(customerVo.getSalesOrgCode())) != null) {
                            requestVo.setSalesOrgProvinceCode(salesOrg.getErpCode());
                            requestVo.setSalesOrgProvinceName(salesOrg.getSalesOrgName());
                        }
                    }
                    requestVo.setActivityBeginTime(DateUtil.format((Date)itemVo.getActivityBeginDate(), (String)"yyyy-MM-dd"));
                    requestVo.setActivityEndTime(DateUtil.format((Date)itemVo.getActivityEndDate(), (String)"yyyy-MM-dd"));
                    result.add(requestVo);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new UnsupportedOperationException(e.getMessage());
        }
        boolean pushResult = this.ecrmService.initiateSynchronization(result);
        if (pushResult) {
            Set<String> activityDetailPlanItemCodeSet = businessUnitCodeActivityDetailPlanItemCodeMap.get(BusinessUnitEnum.HEADQUARTERS.getCode());
            this.detailedForecastRepository.updatePushECRMStatusByCodeSet(activityDetailPlanItemCodeSet);
        }
    }

    public DetailedForecastVo getDetailedForecastByParams(DetailedForecastDto detailedForecast) {
        List<DetailedForecastEntity> list = this.detailedForecastRepository.getDetailedForecastByParams(detailedForecast);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List detailedForecastVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, DetailedForecastEntity.class, DetailedForecastVo.class, HashSet.class, ArrayList.class, new String[0]);
        return (DetailedForecastVo)detailedForecastVos.get(0);
    }

    public List<DetailedForecastVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastEntity> entityList = this.detailedForecastRepository.findByIds(idList);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, DetailedForecastEntity.class, DetailedForecastVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Page<DetailedForecastRequestVo> selectUnSynchronizedPage(Pageable pageable) {
        return this.detailedForecastRepository.selectUnSynchronizedPage(pageable);
    }

    public Long findAutoRefreshCount(DetailedForecastAutoRefreshDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u53f7\uff01", (Object[])new Object[0]);
        return this.detailedForecastRepository.findAutoRefreshDataCount(dto);
    }

    public List<String> findAutoRefreshDataList(Pageable pageable, DetailedForecastAutoRefreshDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)2000));
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u53f7\uff01", (Object[])new Object[0]);
        return this.detailedForecastRepository.findAutoRefreshDataList(pageable, dto);
    }

    public List<String> findAutoCreateDataList(DetailedForecastAutoCreateDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u53f7\uff01", (Object[])new Object[0]);
        return this.detailedForecastRepository.findAutoCreateDataList(dto);
    }

    @Transactional
    public Long autoUpdateShowFLag(DetailedForecastAutoCreateDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u53f7\uff01", (Object[])new Object[0]);
        List<String> activityDetailItemCodes = this.detailedForecastRepository.findAutoUpdateShowFlagDataList(dto);
        if (CollectionUtils.isEmpty(activityDetailItemCodes)) {
            return 0L;
        }
        return this.detailedForecastRepository.autoUpdateShowFLag(activityDetailItemCodes);
    }

    public List<DetailedForecastVo> findByPlanItemCode(Set<String> codeSet) {
        if (CollectionUtils.isEmpty(codeSet)) {
            return null;
        }
        return this.detailedForecastRepository.findByPlanItemCode(codeSet);
    }

    @Transactional
    public void updateWriteOffAmount(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        List<DetailedForecastVo> auditAmountList = this.detailedForecastRepository.findAuditAmount(codes);
        if (CollectionUtils.isEmpty(auditAmountList)) {
            return;
        }
        Map<String, BigDecimal> map = auditAmountList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, DetailedForecastVo::getWriteOffAmount));
        List<DetailedForecastEntity> entityList = this.detailedForecastRepository.findByActivityDetailItemCodes(map.keySet());
        for (DetailedForecastEntity entity : entityList) {
            if (!map.containsKey(entity.getActivityDetailItemCode())) continue;
            entity.setWriteOffAmount(map.get(entity.getActivityDetailItemCode()));
        }
        this.detailedForecastRepository.updateBatchById(entityList);
    }

    public Page<UpExpectAuditAmountMonitorVo> pageUpExpectAuditAmountMonitor(Pageable pageable, UpExpectAuditAmountMonitorDto dto) {
        List idList;
        List tpmWarningMonitoringList;
        List customerErpCodes;
        List subComOrgVos;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new UpExpectAuditAmountMonitorDto();
        }
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setShowFlag(BooleanEnum.TRUE.getCapital());
        Page<UpExpectAuditAmountMonitorVo> monitorPage = this.detailedForecastRepository.pageUpExpectAuditAmountMonitor(pageable, dto);
        if (CollectionUtils.isEmpty((Collection)monitorPage.getRecords())) {
            return monitorPage;
        }
        Map<Object, Object> formulaMap = new HashMap();
        Map<Object, Object> productMap = new HashMap();
        Map<Object, Object> subComOrgVoMap = new HashMap();
        Map<Object, Object> orgVoMap = new HashMap();
        List monitorVoList = monitorPage.getRecords();
        List<String> ids = monitorVoList.stream().map(UuidVo::getId).distinct().collect(Collectors.toList());
        List formulaList = this.detailedForecastFormulaRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty((Collection)formulaList)) {
            formulaMap = formulaList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        List<DetailedForecastProductEntity> productList = this.detailedForecastProductRepository.findByForecastIds(ids);
        if (!CollectionUtils.isEmpty((Collection)formulaList)) {
            productMap = productList.stream().collect(Collectors.groupingBy(DetailedForecastProductEntity::getDetailedForecastId));
        }
        if (!CollectionUtils.isEmpty((Collection)(subComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList(customerErpCodes = monitorVoList.stream().map(UpExpectAuditAmountMonitorVo::getCustomerErpCode).distinct().collect(Collectors.toList()))))) {
            subComOrgVoMap = subComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity()));
            List orgCodes = subComOrgVos.stream().map(SalesOrgSubComOrgVo::getOrgCode).distinct().collect(Collectors.toList());
            List orgVoList = this.orgVoService.findByOrgCodes(orgCodes);
            if (!CollectionUtils.isEmpty((Collection)orgVoList)) {
                orgVoMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
            }
        }
        for (UpExpectAuditAmountMonitorVo monitor : monitorVoList) {
            SalesOrgSubComOrgVo subComOrgVo;
            List productEntityList;
            DetailedForecastFormulaEntity formula = (DetailedForecastFormulaEntity)((Object)formulaMap.get(monitor.getId()));
            if (!Objects.isNull((Object)formula)) {
                monitor.setWriteOffConditions(formula.getWriteOffConditions());
                monitor.setWriteOffFormula(formula.getWriteOffFormula());
                monitor.setWriteOffConditionValue(formula.getWriteOffConditionValue());
                monitor.setWriteOffFormulaValue(formula.getWriteOffFormulaValue());
                monitor.setAuditPrecondition(formula.getWriteOffConditions());
            }
            if (!CollectionUtils.isEmpty((Collection)(productEntityList = (List)productMap.get(monitor.getId())))) {
                productEntityList.sort(Comparator.comparing(DetailedForecastProductEntity::getProductCode));
                List productCodeList = productEntityList.stream().map(DetailedForecastProductEntity::getProductCode).collect(Collectors.toList());
                List productNameList = productEntityList.stream().map(DetailedForecastProductEntity::getProductName).collect(Collectors.toList());
                monitor.setProductCode(String.join((CharSequence)",", productCodeList));
                monitor.setProductName(String.join((CharSequence)",", productNameList));
            }
            if (Objects.isNull(subComOrgVo = (SalesOrgSubComOrgVo)subComOrgVoMap.get(monitor.getCustomerErpCode()))) continue;
            monitor.setOrgCode(subComOrgVo.getOrgCode());
            OrgVo orgVo = (OrgVo)orgVoMap.get(subComOrgVo.getOrgCode());
            if (Objects.isNull(orgVo)) continue;
            monitor.setOrgName(orgVo.getOrgName());
        }
        if (!CollectionUtils.isEmpty((Collection)monitorVoList) && !CollectionUtils.isEmpty((Collection)(tpmWarningMonitoringList = this.tpmWarningMonitoringSdkService.findTpmWarningMonitoringList("tpm_up_expect_audit_amount_monitor", idList = monitorVoList.stream().map(UuidVo::getId).collect(Collectors.toList()))))) {
            Map warningMonitoringVoMap = tpmWarningMonitoringList.stream().collect(Collectors.toMap(TpmWarningMonitoringVo::getBusinessCode, Function.identity()));
            for (UpExpectAuditAmountMonitorVo upExpectAuditAmountMonitorVo : monitorVoList) {
                if (!warningMonitoringVoMap.containsKey(upExpectAuditAmountMonitorVo.getId())) continue;
                TpmWarningMonitoringVo tpmWarningMonitoringVo = (TpmWarningMonitoringVo)warningMonitoringVoMap.get(upExpectAuditAmountMonitorVo.getId());
                upExpectAuditAmountMonitorVo.setWarningCount(tpmWarningMonitoringVo.getWarningCount());
                upExpectAuditAmountMonitorVo.setWarningStatus(tpmWarningMonitoringVo.getWarningStatus());
                upExpectAuditAmountMonitorVo.setWarningVariableCount(tpmWarningMonitoringVo.getWarningVariableCount());
                upExpectAuditAmountMonitorVo.setRecoverWarningCount(tpmWarningMonitoringVo.getRecoverWarningCount());
            }
        }
        return monitorPage;
    }

    public Page<DetailedForecastSummaryVo> summaryPage(Pageable pageable, DetailedForecastSummaryDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        Page<DetailedForecastSummaryVo> page = this.detailedForecastRepository.summaryPageNew(pageable, dto);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return page;
        }
        for (DetailedForecastSummaryVo record : page.getRecords()) {
            if (Objects.nonNull(record.getActualSalesAmount()) && BigDecimal.ZERO.compareTo(record.getActualSalesAmount()) != 0) {
                record.setPreAuditProductionRatio((Objects.isNull(record.getEstimatedWriteOffAmount()) ? BigDecimal.ZERO : record.getEstimatedWriteOffAmount()).multiply(new BigDecimal(100)).divide(record.getActualSalesAmount(), 2, RoundingMode.HALF_UP));
                record.setActualProductionRatio(record.getAlreadyAuditAmount().multiply(new BigDecimal(100)).divide(record.getActualSalesAmount(), 2, RoundingMode.HALF_UP));
            }
            if (!Objects.nonNull(record.getApplyAmount()) || BigDecimal.ZERO.compareTo(record.getApplyAmount()) == 0) continue;
            record.setPreAuditRatio((Objects.isNull(record.getEstimatedWriteOffAmount()) ? BigDecimal.ZERO : record.getEstimatedWriteOffAmount()).multiply(new BigDecimal(100)).divide(record.getApplyAmount(), 2, RoundingMode.HALF_UP));
            record.setActualAuditRatio(record.getAlreadyAuditAmount().multiply(new BigDecimal(100)).divide(record.getApplyAmount(), 2, RoundingMode.HALF_UP));
        }
        return page;
    }

    public List<DetailedForecastVo> findEstimatedWriteOffAmount(DetailedForecastDto detailedForecastDto) {
        if (Objects.isNull(detailedForecastDto)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastEntity> detailedForecastEntities = this.detailedForecastRepository.findEstimatedWriteOffAmount(detailedForecastDto);
        if (CollectionUtils.isEmpty(detailedForecastEntities)) {
            return Lists.newArrayList();
        }
        Collection detailedForecastVos = this.nebulaToolkitService.copyCollectionByWhiteList(detailedForecastEntities, DetailedForecastEntity.class, DetailedForecastVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)detailedForecastVos;
    }

    public List<DetailedForecastVo> findListForSaleAndFeeMonitoring(List<DetailedForecastDto> detailedForecastDtos) {
        if (CollectionUtils.isEmpty(detailedForecastDtos)) {
            return Lists.newArrayList();
        }
        return this.detailedForecastRepository.findListForSaleAndFeeMonitoring(detailedForecastDtos);
    }

    public List<DetailedForecastVo> findByPlanItemCodes(Set<String> constituentDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(constituentDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastEntity> detailedForecastEntities = this.detailedForecastRepository.findByPlanItemCodes(constituentDetailPlanItemCodes);
        if (CollectionUtils.isEmpty(detailedForecastEntities)) {
            return Lists.newArrayList();
        }
        Collection detailedForecastVos = this.nebulaToolkitService.copyCollectionByWhiteList(detailedForecastEntities, DetailedForecastEntity.class, DetailedForecastVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)detailedForecastVos;
    }

    private Object nullToEmptyString(Object o) {
        if (Objects.isNull(o)) {
            return "";
        }
        return o;
    }

    public void detailedForecastSummaryUpdateQuery(DetailedForecastSummaryDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getUpdateQueryBegin()) || StringUtils.isBlank((CharSequence)dto.getUpdateQueryEnd())) {
            return;
        }
        log.info("\u8fdb\u5165\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u8868\u5b9a\u65f6\u4efb\u52a1\u589e\u91cf\u66f4\u65b0");
        try {
            Page page;
            Page<ActivityDetailPlanItemVo> pageResult;
            dto.setTenantCode(TenantUtils.getTenantCode());
            List<ActivityDetailPlanItemVo> activityDetailPlanItemVos = this.detailedForecastRepository.findDetailedForecastSummaryUpdate(dto);
            if (CollectionUtils.isEmpty(activityDetailPlanItemVos)) {
                return;
            }
            this.detailedForecastSummaryRepository.deleteSummaryByPlanCode(activityDetailPlanItemVos.stream().map(ActivityDetailPlanItemBase::getRelatePlanCode).collect(Collectors.toList()));
            dto.setPlanCodes(activityDetailPlanItemVos.stream().map(ActivityDetailPlanItemBase::getRelatePlanCode).collect(Collectors.toList()));
            int current = 1;
            int pageSize = 200;
            int count = 1;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            HashSet mb = Sets.newHashSet((Object[])new String[]{"HDMBPZ3913", "HDMBPZ3922"});
            while (!Objects.isNull(pageResult = this.detailedForecastRepository.findActivityDetailPlanItemList((Page<ActivityDetailPlanItemVo>)(page = new Page((long)current, (long)pageSize)), dto)) && !CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
                ++current;
                List<DetailedForecastVo> result = this.detailedForecastRepository.findDetailedForecastSummaryUpdateList(pageResult.getRecords().stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty(result)) {
                    List<DetailedForecastSummaryVo> list;
                    log.info("\u67e5\u8be2\u7ec6\u6848\u9884\u6d4b\u8fd4\u56de,{}", (Object)JSON.toJSONString(result));
                    Map activityDetailPlanItemVoMap = pageResult.getRecords().stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity(), (v1, v2) -> v1));
                    HashMap data = Maps.newHashMap();
                    result.forEach(record -> {
                        BigDecimal applyAmount;
                        BigDecimal periodPromotionQuantity;
                        String templateConfigCode;
                        ActivityDetailPlanItemVo itemVo = (ActivityDetailPlanItemVo)activityDetailPlanItemVoMap.get(record.getActivityDetailItemCode());
                        log.info("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b-\u7ec6\u6848\u660e\u7ec6,{}", (Object)(itemVo == null ? "null" : JSON.toJSONString((Object)itemVo)));
                        String planCode = itemVo == null ? "" : itemVo.getPlanCode();
                        String planName = itemVo == null ? "" : itemVo.getPlanName();
                        String string = templateConfigCode = itemVo == null ? "" : itemVo.getTemplateConfigCode();
                        BigDecimal bigDecimal = itemVo == null ? BigDecimal.ZERO : (periodPromotionQuantity = itemVo.getPeriodPromotionalNumber() == null ? BigDecimal.ZERO : new BigDecimal(itemVo.getPeriodPromotionalNumber()));
                        BigDecimal bigDecimal2 = itemVo == null ? BigDecimal.ZERO : (applyAmount = itemVo.getFeeAmount() == null ? BigDecimal.ZERO : itemVo.getFeeAmount());
                        BigDecimal alreadyAuditAmount = itemVo == null ? BigDecimal.ZERO : (itemVo.getAlreadyAuditAmount() == null ? BigDecimal.ZERO : itemVo.getAlreadyAuditAmount());
                        String key = StringUtils.join((Object[])new String[]{record.getBusinessUnitCode(), record.getBusinessFormatCode(), planCode, planName, record.getSystemCode(), record.getSystemName(), record.getRegionName(), record.getRegion(), record.getActivityTypeCode(), record.getActivityTypeName(), record.getActivityFormCode(), record.getActivityFormName(), record.getProductBrandCode(), record.getProductBrandName(), dateFormat.format(record.getActivityStartTime()), dateFormat.format(record.getActivityEndTime())});
                        log.info("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b-\u53bb\u91cdkey,{}", (Object)key);
                        String id = DigestUtils.md5Hex((byte[])key.getBytes(StandardCharsets.UTF_8));
                        log.info("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b-\u6a21\u677f\u7f16\u7801,{},\u7ec6\u6848\u7f16\u7801,{}", (Object)key, (Object)itemVo.getDetailPlanCode());
                        if (data.containsKey(id)) {
                            DetailedForecastSummaryEntity entity = (DetailedForecastSummaryEntity)((Object)((Object)data.get(id)));
                            if (mb.contains(templateConfigCode)) {
                                log.info("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b-\u7ec6\u6848\u7f16\u7801,{},\u671f\u95f4\u4fc3\u9500\u91cf,{}", (Object)itemVo.getDetailPlanCode(), (Object)periodPromotionQuantity);
                                entity.setPeriodPromotionQuantity(entity.getPeriodPromotionQuantity().add(periodPromotionQuantity));
                            }
                            entity.setApplyAmount(entity.getApplyAmount().add(applyAmount));
                            entity.setAlreadyAuditAmount(entity.getAlreadyAuditAmount().add(alreadyAuditAmount));
                            entity.setEstimatedWriteOffAmount((Objects.isNull(entity.getEstimatedWriteOffAmount()) ? BigDecimal.ZERO : entity.getEstimatedWriteOffAmount()).add(Objects.isNull(record.getEstimatedWriteOffAmount()) ? BigDecimal.ZERO : record.getEstimatedWriteOffAmount()));
                            data.put(id, entity);
                        } else {
                            DetailedForecastSummaryEntity entity = new DetailedForecastSummaryEntity();
                            BeanUtils.copyProperties((Object)record, (Object)((Object)entity));
                            entity.setSchemeCode(planCode);
                            entity.setSchemeName(planName);
                            entity.setPeriodPromotionQuantity(BigDecimal.ZERO);
                            if (mb.contains(templateConfigCode)) {
                                log.info("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b-\u7ec6\u6848\u7f16\u7801,{},\u671f\u95f4\u4fc3\u9500\u91cf,{}", (Object)itemVo.getDetailPlanCode(), (Object)periodPromotionQuantity);
                                entity.setPeriodPromotionQuantity(periodPromotionQuantity);
                            }
                            entity.setApplyAmount(applyAmount);
                            entity.setAlreadyAuditAmount(alreadyAuditAmount);
                            entity.setId(id);
                            data.put(id, entity);
                        }
                    });
                    HashSet<String> keySet = new HashSet<String>();
                    HashSet<String> keyBrandSet = new HashSet<String>();
                    for (DetailedForecastSummaryEntity record2 : data.values()) {
                        List yearMonthList = DateUtil.getBetweenYearMonths((Date)record2.getActivityStartTime(), (Date)record2.getActivityEndTime(), (String)"yyyyMM");
                        String keyPrefix = record2.getRegionName() + record2.getSystemName() + this.nullToEmptyString(record2.getProductBrandCode());
                        Iterator iterator = yearMonthList.iterator();
                        while (iterator.hasNext()) {
                            String yearMonth = (String)iterator.next();
                            String key = keyPrefix + yearMonth;
                            if (StringUtils.isNotEmpty((CharSequence)record2.getProductBrandCode())) {
                                keyBrandSet.add(key);
                                continue;
                            }
                            keySet.add(key);
                        }
                    }
                    ArrayList salesPerformanceList = Lists.newArrayList();
                    if (!CollectionUtils.isEmpty(keySet)) {
                        list = this.detailedForecastRepository.summarySalesPerformanceList(Lists.newArrayList(keySet), null);
                        salesPerformanceList.addAll(list);
                    }
                    if (!CollectionUtils.isEmpty(keyBrandSet)) {
                        list = this.detailedForecastRepository.summarySalesPerformanceList(null, Lists.newArrayList(keyBrandSet));
                        salesPerformanceList.addAll(list);
                    }
                    log.info("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\uff1a\u5782\u76f4\u9500\u552e\u4e1a\u7ee9\uff1a{}", (Object)salesPerformanceList.size());
                    Map<String, BigDecimal> actualSalesMap = salesPerformanceList.stream().collect(Collectors.toMap(UuidDto::getId, DetailedForecastSummaryVo::getActualSalesAmount));
                    for (DetailedForecastSummaryEntity record3 : data.values()) {
                        List yearMonthList = DateUtil.getBetweenYearMonths((Date)record3.getActivityStartTime(), (Date)record3.getActivityEndTime(), (String)"yyyyMM");
                        String keyPrefix = record3.getRegionName() + record3.getSystemName() + this.nullToEmptyString(record3.getProductBrandCode());
                        BigDecimal actualSalesAmount = BigDecimal.ZERO;
                        for (String yearMonth : yearMonthList) {
                            String key = keyPrefix + yearMonth;
                            actualSalesAmount = actualSalesAmount.add(actualSalesMap.getOrDefault(key, BigDecimal.ZERO));
                        }
                        record3.setActualSalesAmount(actualSalesAmount);
                    }
                    List entityList = ((LambdaQueryChainWrapper)this.detailedForecastSummaryRepository.lambdaQuery().in(UuidEntity::getId, data.keySet())).list();
                    Map databaseMap = entityList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
                    data.values().forEach(value -> {
                        if (databaseMap.containsKey(value.getId())) {
                            value.setPeriodPromotionQuantity(((BigDecimal)ObjectUtils.defaultIfNull((Object)value.getPeriodPromotionQuantity(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)((DetailedForecastSummaryEntity)((Object)((Object)databaseMap.get(value.getId())))).getPeriodPromotionQuantity(), (Object)BigDecimal.ZERO)));
                            value.setApplyAmount(((BigDecimal)ObjectUtils.defaultIfNull((Object)value.getApplyAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)((DetailedForecastSummaryEntity)((Object)((Object)databaseMap.get(value.getId())))).getApplyAmount(), (Object)BigDecimal.ZERO)));
                            value.setEstimatedWriteOffAmount(((BigDecimal)ObjectUtils.defaultIfNull((Object)value.getEstimatedWriteOffAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)((DetailedForecastSummaryEntity)((Object)((Object)databaseMap.get(value.getId())))).getEstimatedWriteOffAmount(), (Object)BigDecimal.ZERO)));
                            value.setAlreadyAuditAmount(((BigDecimal)ObjectUtils.defaultIfNull((Object)value.getAlreadyAuditAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)((DetailedForecastSummaryEntity)((Object)((Object)databaseMap.get(value.getId())))).getAlreadyAuditAmount(), (Object)BigDecimal.ZERO)));
                        }
                        BigDecimal estimatedWriteOffAmount = Optional.ofNullable(value.getEstimatedWriteOffAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal alreadyAuditAmount = Optional.ofNullable(value.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal remnantAuditAmount = estimatedWriteOffAmount.subtract(alreadyAuditAmount);
                        value.setRemnantAuditAmount(remnantAuditAmount);
                    });
                    log.info("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b-\u6570\u636eMAP,{}", (Object)JSON.toJSONString((Object)data));
                    this.detailedForecastSummaryRepository.saveOrUpdateBatch(data.values(), 100);
                    ++count;
                }
                if (pageResult.hasNext() && count <= 1000) continue;
                break;
            }
        }
        catch (Exception e) {
            log.error("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u62a5\u9519\u5566:", (Throwable)e);
            e.printStackTrace();
        }
    }

    public List<DetailedForecastVo> findEstimatedWriteOffAmountByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastVo> list = this.detailedForecastRepository.findEstimatedWriteOffAmountByCodes(codes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<DetailedForecastVo> findByProfitMonitor(List<DetailedForecastDto> records) {
        return this.detailedForecastRepository.findByProfitMonitor(records);
    }

    public List<DetailedForecastVo> findByProfitMonitor1(List<DetailedForecastDto> detailedForecastDtos) {
        return this.detailedForecastRepository.findByProfitMonitor1(detailedForecastDtos);
    }

    public List<AuditDetailedForecastVo> findByActivityDetailItemCodes(List<String> activityDetailItemCodes) {
        if (CollectionUtils.isEmpty(activityDetailItemCodes)) {
            return Lists.newArrayList();
        }
        return this.detailedForecastRepository.findByActivityDetailItemCodes2(activityDetailItemCodes);
    }
}

