/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DetailedForecastShowFlagRefreshXxlJob {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastShowFlagRefreshXxlJob.class);
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;

    @DynamicTaskService(cornExpression="0 0 7/1 * * ?", taskDesc="\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5c55\u793a\u72b6\u6001\u4efb\u52a1")
    public void autoRefresh() {
        log.info("=====>    \u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5c55\u793a\u72b6\u6001[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        this.loginUserService.refreshAuthentication(null);
        try {
            if (this.redisService.hasKey("tpm:detailed_forecast_auto_refresh_show_flag").booleanValue()) {
                Object o = this.redisService.get("tpm:detailed_forecast_auto_refresh_show_flag");
                String msg = "\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5c55\u793a\u72b6\u6001\u8fdb\u884c\u4e2d\uff01\u5f00\u59cb\u65f6\u95f4\uff1a" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            String nowDateTime = DateUtil.getDate((String)"yyyy-MM-dd HH:mm:ss");
            this.redisService.set("tpm:detailed_forecast_auto_refresh_show_flag", (Object)nowDateTime, 300L);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            DetailedForecastAutoCreateDto dto = new DetailedForecastAutoCreateDto();
            dto.setModifyBeginDateTime(LocalDateTime.now().plusDays(-3L).format(formatter));
            dto.setTenantCode(TenantUtils.getTenantCode());
            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                Long count = this.detailedForecastService.autoUpdateShowFLag(dto);
                log.info("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5c55\u793a\u72b6\u6001===\u300b\u4e3b\u4f53===\u300b{}", (Object)count);
                dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                count = this.detailedForecastService.autoUpdateShowFLag(dto);
                log.info("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5c55\u793a\u72b6\u6001===\u300b\u5206\u5b50===\u300b{}", (Object)count);
            }
            catch (Exception e) {
                log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5c55\u793a\u72b6\u6001===\u300b\u4e3b\u4f53===\u300b\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        log.info("=====>    \u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5c55\u793a\u72b6\u6001[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }
}

