/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastSummaryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DetailedForecastSummaryXxlJob {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastSummaryXxlJob.class);
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;

    @DynamicTaskService(cornExpression="0 0 1 * * ?", taskDesc="\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u589e\u91cf\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1")
    public void detailedForecastSummaryUpdateQuery() {
        log.info("=====>    \u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u589e\u91cf\u66f4\u65b0[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        this.loginUserService.refreshAuthentication(null);
        try {
            if (this.redisService.hasKey("tpm:detailed_forecast_summary").booleanValue()) {
                Object o = this.redisService.get("tpm:detailed_forecast_summary");
                String msg = "\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u589e\u91cf\u66f4\u65b0\u8fdb\u884c\u4e2d\uff01\u5f00\u59cb\u65f6\u95f4\uff1a" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            String nowDateTime = DateUtil.getDate((String)"yyyy-MM-dd HH:mm:ss");
            this.redisService.set("tpm:detailed_forecast_summary", (Object)nowDateTime, 3000L);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate localDate = LocalDate.now();
            localDate = localDate.plusDays(-1L);
            DetailedForecastSummaryDto dto = new DetailedForecastSummaryDto();
            dto.setUpdateQueryBegin(localDate.format(formatter) + " " + "00:00:00");
            dto.setUpdateQueryEnd(localDate.format(formatter) + " " + "23:59:59");
            try {
                this.detailedForecastService.detailedForecastSummaryUpdateQuery(dto);
            }
            catch (Exception e) {
                log.error("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u589e\u91cf\u66f4\u65b0===\u300b\u5782\u76f4===\u300b\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            log.error("\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u589e\u91cf\u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        log.info("=====>    \u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u589e\u91cf\u66f4\u65b0[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }
}

