/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.task.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class DeatailedForecastSchedulingImp
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DeatailedForecastSchedulingImp.class);
    private static final String DEFAULT_CRON = "0 0 1,12,17,23 * * ?";
    private String cron = "0 0 1,12,17,23 * * ?";
    @Autowired
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private EcrmService ecrmService;
    @Value(value="${ce1.ce1EnableSchedulingFlag}")
    private boolean ce1EnableSchedulingFlag;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        this.ce1EnableSchedulingFlag = false;
        if (this.ce1EnableSchedulingFlag) {
            taskRegistrar.addTriggerTask(this::executePullTask, triggerContext -> {
                CronTrigger trigger = new CronTrigger(this.cron);
                return trigger.nextExecutionTime(triggerContext);
            });
        } else {
            log.info("\u672a\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u624b\u52a8\u8c03\u7528");
        }
    }

    public void executePullTask() {
        int pageNum = 1;
        int pageSize = 200;
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        Page page = this.detailedForecastService.selectUnSynchronizedPage((Pageable)pageable);
        while (!CollectionUtils.isEmpty((Collection)page.getRecords())) {
            boolean success = this.ecrmService.initiateSynchronization(page.getRecords());
            if (success) {
                this.detailedForecastService.updateSynchronousRegime(page.getRecords());
            }
            if (page.getRecords().size() == pageSize) {
                pageable = PageRequest.of((int)(++pageNum), (int)pageSize);
                page = this.detailedForecastService.selectUnSynchronizedPage((Pageable)pageable);
                continue;
            }
            page.setRecords(new ArrayList());
        }
    }
}

