/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.service.TpmCustomerSummaryConfigureService;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyBudgetVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.CallAuditResponse;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastCallAuditEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastCallAuditListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.VerticalFeeBelongCodeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ActivityDetailPlanPassDetailedForecastUtil {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanPassDetailedForecastUtil.class);
    @Autowired(required=false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private VariableService variableService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService activityConstituentDetailPlanItemVoService;
    @Autowired(required=false)
    private DetailedForecastRepository detailedForecastRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmCustomerSummaryConfigureService tpmCustomerSummaryConfigureService;
    @Autowired(required=false)
    private BusinessPolicyService businessPolicyService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private DetailedForecastMapper detailedForecastMapper;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public String packageOnlyKey(DetailedForecastEntity entity, String timeStamp) {
        if (StringUtils.isEmpty((CharSequence)timeStamp)) {
            timeStamp = "";
        }
        return DigestUtils.md5Hex((String)(entity.getDetailedCaseCode() + entity.getActivityDetailItemCode() + timeStamp));
    }

    @Transactional(rollbackFor={Exception.class})
    public void insert(DetailedForecastDto detailedForecastDto) {
        DetailedForecastEntity detailedForecastEntity = (DetailedForecastEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailedForecastDto, DetailedForecastEntity.class, null, null, new String[0]));
        detailedForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        detailedForecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailedForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailedForecastEntity.setShowFlag(YesOrNoEnum.YES.getCode());
        if (StringUtils.isNotEmpty((CharSequence)detailedForecastEntity.getYearMonthStr())) {
            detailedForecastEntity.setYearMonthLy(DateUtil.parse((String)(detailedForecastEntity.getYearMonthStr() + "-01 00:00:00"), (String)"yyyy-MM"));
        }
        detailedForecastEntity.setOnlyKey(this.packageOnlyKey(detailedForecastEntity, null));
        DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(detailedForecastDto);
        SerializableBiConsumer & Serializable onCreate = DetailedForecastLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DetailedForecastLogEventListener.class, (SerializableBiConsumer)onCreate);
        this.detailedForecastRepository.saveOrUpdate((Object)detailedForecastEntity);
    }

    @Async(value="asyncThread")
    public void buildUnit1Param(ActivityDetailPlanDto activityDetailPlanDto, DetailedForecastDto detailedForecastDto, ActivityDetailPlanItemDto item, UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u4e3b\u4f53\u65b0\u589e\u8ba1\u7b97", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        if (StringUtils.isNotEmpty((CharSequence)item.getAuditType())) {
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
                dto.setAuditType(item.getAuditType());
                dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(detailedForecastDto.getRtmMode());
                dto.setFirstChannel(detailedForecastDto.getFirstChannelCode());
                dto.setSecondChannel(detailedForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(detailedForecastDto.getCustomerAccount());
                dto.setDisplayNumber(detailedForecastDto.getDisplayNumber());
                dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
                List formulaMainVoList = this.auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    CalculateDto calDto = this.buildCalParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                    this.setParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, calDto);
                } else {
                    detailedForecastDto.setAuditFormulaCode(null);
                }
            } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
                AuditFormulaMainVo auditFormulaMainVo = null;
                try {
                    auditFormulaMainVo = this.auditFormulaMainService.findByCode(item.getAuditConditionCode());
                }
                catch (Exception e2) {
                    log.error("\u7ec6\u6848\u7f16\u7801[" + detailedForecastDto.getDetailedCaseCode() + "]\u660e\u7ec6\u7f16\u7801[" + detailedForecastDto.getActivityDetailItemCode() + "]\u7ec6\u6848\u9884\u6d4b\u4e3b\u4f53\u65b0\u589e\u8ba1\u7b97" + e2.getMessage(), (Throwable)e2);
                }
                CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
                this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
            } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
                detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
                detailedForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
            }
        }
        this.insert(detailedForecastDto);
    }

    @Async(value="asyncThread")
    public void buildUnit2Param(DetailedForecastDto detailedForecastDto, SubComActivityDetailPlanItemVo item, UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        log.info("\u5206\u5b50\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u5206\u5b50\u65b0\u589e\u8ba1\u7b97", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        if ("zdhx".equals(item.getAuditCondition()) || TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditCondition())) {
            detailedForecastDto.setAuditType(TpmAuditTypeEnum.AUDITTYPE1.getCode());
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setAuditType(item.getAuditCondition());
            dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
            List formulaMainVoList = this.auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                CalculateDto calDto = this.buildCalParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, calDto);
            } else {
                detailedForecastDto.setAuditFormulaCode(null);
            }
        } else if ("zdyhx".equals(item.getAuditCondition()) || TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditCondition())) {
            detailedForecastDto.setAuditType(TpmAuditTypeEnum.AUDITTYPE2.getCode());
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = this.auditFormulaMainService.findByCode(item.getAuditConditionCode());
            }
            catch (Exception e2) {
                log.error("\u7ec6\u6848\u7f16\u7801[" + detailedForecastDto.getDetailedCaseCode() + "]\u660e\u7ec6\u7f16\u7801[" + detailedForecastDto.getActivityDetailItemCode() + "]\u7ec6\u6848\u9884\u6d4b\u5206\u5b50\u65b0\u589e\u8ba1\u7b97" + e2.getMessage(), (Throwable)e2);
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
            this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
        } else if (StringUtils.isEmpty((CharSequence)item.getAuditCondition()) || "null".equals(item.getAuditCondition()) || TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditCondition())) {
            detailedForecastDto.setAuditType(TpmAuditTypeEnum.AUDITTYPE3.getCode());
            detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            detailedForecastDto.setEstimatedWriteOffAmount(item.getTotalCost());
        }
        this.insert(detailedForecastDto);
    }

    @Async(value="asyncThread")
    public void buildUnit3Param(DetailedForecastDto detailedForecastDto, ActivityDetailPlanItemDto item, UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setAuditType(item.getAuditType());
            dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
            List formulaMainVoList = this.auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                CalculateDto calDto = this.buildCalParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, calDto);
            } else {
                detailedForecastDto.setAuditFormulaCode(null);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = this.auditFormulaMainService.findByCode(item.getAuditConditionCode());
            }
            catch (Exception e2) {
                log.error("\u7ec6\u6848\u7f16\u7801[" + detailedForecastDto.getDetailedCaseCode() + "]\u660e\u7ec6\u7f16\u7801[" + detailedForecastDto.getActivityDetailItemCode() + "]\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97" + e2.getMessage(), (Throwable)e2);
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
            this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
        } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
            detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            detailedForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
        }
        this.verticalOperateBudget(null, detailedForecastDto);
        this.insert(detailedForecastDto);
    }

    @Async(value="asyncThread")
    public void buildUnit4Param(DetailedForecastDto detailedForecastDto, GeneralExpensesVo item, UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        log.info("\u4fc3\u9500\u89c4\u5212\u7f16\u53f7[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        if (StringUtils.isNotBlank((CharSequence)item.getMonthBudgetCode())) {
            detailedForecastDto.setBudgetCode(item.getMonthBudgetCode());
        } else {
            List budgetList = this.businessPolicyService.findBusinessPolicyBudget(item.getCommercePolicyCode());
            if (CollectionUtils.isNotEmpty((Collection)budgetList)) {
                detailedForecastDto.setBudgetCode(((BusinessPolicyBudgetVo)budgetList.get(0)).getBudgetCode());
            }
        }
        if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(detailedForecastDto.getAuditType())) {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = this.auditFormulaMainService.findByCode(item.getAuditConditionCode());
            }
            catch (Exception e2) {
                log.error("\u7ec6\u6848\u7f16\u7801[" + detailedForecastDto.getDetailedCaseCode() + "]\u660e\u7ec6\u7f16\u7801[" + detailedForecastDto.getActivityDetailItemCode() + "]\u7ec6\u6848\u9884\u6d4b\u7535\u5546\u65b0\u589e\u8ba1\u7b97" + e2.getMessage(), (Throwable)e2);
            }
            if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty((Collection)auditFormulaMainVo.getAuditFormulaInfoVoList())) {
                CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, item.getAuditConditionType());
                this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditConditionType())) {
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setAuditType(detailedForecastDto.getAuditType());
            dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
            List formulaMainVoList = this.auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                CalculateDto calDto = this.buildCalParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, calDto);
            } else {
                detailedForecastDto.setAuditFormulaCode(null);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditConditionType())) {
            detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            detailedForecastDto.setEstimatedWriteOffAmount(item.getApplyAmount());
        }
        this.insert(detailedForecastDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void refreshUpdate(DetailedForecastEntity entity, ActivityDetailPlanItemVo detailPlanItemVo, Map<String, ProductVo> productVoMap, UserIdentity loginUser, Map<String, AuditExecuteIndicatorVo> finalAuditExecuteIndicatorMap) {
        AuditExecuteIndicatorVo auditExecuteIndicatorVo;
        this.loginUserService.refreshAuthentication((Object)loginUser);
        DetailedForecastDto dto = (DetailedForecastDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DetailedForecastDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.refreshCal(dto);
        this.verticalOperateBudget(entity, dto);
        if (BusinessUnitEnum.VERTICAL.getCode().equals(entity.getBusinessUnitCode()) && (auditExecuteIndicatorVo = finalAuditExecuteIndicatorMap.get(entity.getActivityDetailItemCode())) != null) {
            entity.setMinusCompostQuantity(auditExecuteIndicatorVo.getIndicatorValue());
        }
        entity.setWriteOffConditions(dto.getWriteOffConditions());
        entity.setWriteOffFormula(dto.getWriteOffFormula());
        entity.setWriteOffConditionValue(dto.getWriteOffConditionValue());
        entity.setWriteOffFormulaValue(dto.getWriteOffFormulaValue());
        entity.setEstimatedWriteOffAmount(dto.getEstimatedWriteOffAmount());
        entity.setWriteOffPremise(dto.getWriteOffPremise());
        entity.setAuditFormulaCode(dto.getAuditFormulaCode());
        entity.setCalEx(dto.getCalEx());
        entity.setCalParam(dto.getCalParam());
        entity.setOverBudgetRemark(dto.getOverBudgetRemark());
        entity.setOverBudgetFailAmount(dto.getOverBudgetFailAmount());
        entity.setOverBudgetSuccess(dto.getOverBudgetSuccess());
        entity.setHeadFeeAmount(dto.getHeadFeeAmount());
        entity.setDepartmentFeeAmount(dto.getDepartmentFeeAmount());
        entity.setOverBudgetAmount(dto.getOverBudgetAmount());
        if (!StringUtils.isBlank((CharSequence)dto.getActivityDetailItemCode())) {
            DetailedForecastCallAuditEventDto eventDto = new DetailedForecastCallAuditEventDto();
            eventDto.setActivityDetailItemCode(dto.getActivityDetailItemCode());
            SerializableBiConsumer & Serializable getWholeAudit = DetailedForecastCallAuditListener::selectWholeAuditFromAuditByActivityCode;
            CallAuditResponse response = (CallAuditResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, DetailedForecastCallAuditListener.class, (SerializableBiConsumer)getWholeAudit);
            if (!Objects.isNull(response)) {
                entity.setWholeAudit(response.getWholeAudit());
            }
        }
        if (Objects.nonNull(detailPlanItemVo)) {
            entity.setProductCode(detailPlanItemVo.getProductCode());
            ProductVo productVo = productVoMap.get(entity.getProductCode());
            if (Objects.nonNull(productVo)) {
                entity.setProductName(productVo.getProductName());
                entity.setProductBrandCode(productVo.getProductBrandCode());
                entity.setProductBrandName(productVo.getProductBrandName());
                entity.setProductCategoryCode(productVo.getProductCategoryCode());
                entity.setProductCategoryName(productVo.getProductCategoryName());
                entity.setProductItemCode(productVo.getProductLevelCode());
                entity.setProductItemName(productVo.getProductLevelName());
            }
        }
        if (StringUtils.isEmpty((CharSequence)entity.getOnlyKey())) {
            entity.setOnlyKey(this.packageOnlyKey(entity, null));
        }
        this.detailedForecastRepository.updateById(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verticalOperateBudget(DetailedForecastEntity entity, DetailedForecastDto dto) {
        if (!StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)dto.getBusinessUnitCode())) {
            return;
        }
        BigDecimal applyAmount = Objects.nonNull(dto.getApplyAmount()) ? dto.getApplyAmount() : BigDecimal.ZERO;
        BigDecimal newOperateAmount = Objects.nonNull(dto.getEstimatedWriteOffAmount()) ? dto.getEstimatedWriteOffAmount() : BigDecimal.ZERO;
        BigDecimal oldOperateAmount = BigDecimal.ZERO;
        if (Objects.nonNull((Object)entity) && StringUtils.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)entity.getOverBudgetSuccess())) {
            oldOperateAmount = Objects.nonNull(entity.getOverBudgetFailAmount()) ? entity.getOverBudgetFailAmount() : BigDecimal.ZERO;
        } else if (Objects.nonNull((Object)entity)) {
            oldOperateAmount = Objects.nonNull(entity.getEstimatedWriteOffAmount()) ? entity.getEstimatedWriteOffAmount() : BigDecimal.ZERO;
        }
        log.error("verticalOperateBudget===>applyAmount===>" + applyAmount);
        log.error("verticalOperateBudget===>newOperateAmount===>" + newOperateAmount);
        log.error("verticalOperateBudget===>oldOperateAmount===>" + oldOperateAmount);
        if (applyAmount.compareTo(oldOperateAmount) > 0 && applyAmount.compareTo(newOperateAmount) > 0) {
            return;
        }
        BigDecimal operateAmount = BigDecimal.ZERO;
        if (applyAmount.compareTo(oldOperateAmount) < 0 && applyAmount.compareTo(newOperateAmount) < 0) {
            operateAmount = newOperateAmount.subtract(oldOperateAmount);
        } else if (applyAmount.compareTo(oldOperateAmount) >= 0 && applyAmount.compareTo(newOperateAmount) < 0) {
            operateAmount = newOperateAmount.subtract(applyAmount);
        } else if (applyAmount.compareTo(oldOperateAmount) < 0 && applyAmount.compareTo(newOperateAmount) >= 0) {
            operateAmount = applyAmount.subtract(oldOperateAmount);
        }
        log.error("verticalOperateBudget===>operateAmount===>" + operateAmount);
        if (BigDecimal.ZERO.compareTo(operateAmount) == 0) {
            return;
        }
        String overBudgetSuccess = YesOrNoEnum.YES.getCode();
        BigDecimal overBudgetFailAmount = dto.getEstimatedWriteOffAmount();
        List<ActivityDetailPlanBudgetVo> budgetVos = this.detailedForecastMapper.findActivityDetailBudgetCodes(dto.getActivityDetailItemCode(), TenantUtils.getTenantCode());
        List budgetCodes = budgetVos.stream().map(ActivityDetailPlanBudgetVo::getMonthBudgetCode).distinct().collect(Collectors.toList());
        try {
            Validate.notEmpty(budgetVos, (String)"\u672a\u83b7\u53d6\u5230\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u5173\u8054\u9884\u7b97", (Object[])new Object[0]);
            boolean lock = this.monthBudgetLockService.lock(budgetCodes, TimeUnit.SECONDS, 30, 60);
            Validate.isTrue((boolean)lock, (String)"\u64cd\u4f5c\u9884\u7b97\u5931\u8d25\uff0c\u83b7\u53d6\u64cd\u4f5c\u9501\u5931\u8d25\uff01", (Object[])new Object[0]);
            List<String> useBudgetCodeList = this.getBudgetSortList(budgetVos);
            List<OperateMonthBudgetDto> operateVos = this.buildOperateList(operateAmount, dto, useBudgetCodeList);
            this.monthBudgetService.operateBudget(operateVos);
            dto.setOverBudgetAmount(dto.getEstimatedWriteOffAmount().subtract(dto.getApplyAmount()));
            dto.setOverBudgetRemark("");
        }
        catch (Exception e) {
            e.printStackTrace();
            String exMsg = "\u5782\u76f4\u5355\u5143-\u7ec6\u6848\u9884\u6d4b-\u8865\u5360\u9884\u7b97\u5f02\u5e38\uff1a" + e.getMessage();
            if (exMsg.length() > 300) {
                exMsg = exMsg.substring(0, 300);
            }
            dto.setOverBudgetRemark(exMsg);
            overBudgetSuccess = YesOrNoEnum.NO.getCode();
        }
        finally {
            this.monthBudgetLockService.unLock(budgetCodes);
        }
        if (StringUtils.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)overBudgetSuccess)) {
            overBudgetFailAmount = Objects.nonNull((Object)entity) && StringUtils.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)entity.getOverBudgetSuccess()) ? entity.getOverBudgetFailAmount() : (Objects.nonNull((Object)entity) ? entity.getEstimatedWriteOffAmount() : BigDecimal.ZERO);
        }
        dto.setOverBudgetFailAmount(overBudgetFailAmount);
        dto.setOverBudgetSuccess(overBudgetSuccess);
    }

    public List<String> getBudgetSortList(List<ActivityDetailPlanBudgetVo> budgetVos) {
        Validate.notEmpty(budgetVos, (String)"\u7ec6\u6848\u9884\u6d4b\u8865\u5360\u9884\u7b97-\u4f7f\u7528\u9884\u7b97\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List sortedList = budgetVos.stream().filter(e -> Objects.nonNull(e.getUseAmount()) && VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode().equals(e.getFeeBelongCode())).sorted(Comparator.comparing(ActivityDetailPlanBudgetVo::getUseAmount).reversed()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sortedList)) {
            return Lists.newArrayList();
        }
        BigDecimal useAmount = ((ActivityDetailPlanBudgetVo)sortedList.get(0)).getUseAmount();
        Map sortedMap = sortedList.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getUseAmount, Collectors.mapping(ActivityDetailPlanBudgetVo::getMonthBudgetCode, Collectors.toList())));
        List budgetCodes = sortedMap.get(useAmount);
        Collections.sort(budgetCodes);
        return Lists.newArrayList((Object[])new String[]{(String)budgetCodes.get(0)});
    }

    public List<OperateMonthBudgetDto> buildOperateList(BigDecimal operateAmount, DetailedForecastDto dto, List<String> budgetCodes) {
        List budgetVos = this.monthBudgetService.findByCodes(budgetCodes, EnableStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isEmpty((Collection)budgetVos)) {
            budgetVos = Lists.newArrayList();
        }
        Map<String, List<MonthBudgetVo>> budgetVosMap = budgetVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getFeeBelongCode())).collect(Collectors.groupingBy(MonthBudgetVo::getFeeBelongCode));
        List<MonthBudgetVo> automaticVos = budgetVosMap.getOrDefault(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode(), Lists.newArrayList());
        ArrayList<OperateMonthBudgetDto> operateVos = new ArrayList<OperateMonthBudgetDto>();
        AtomicReference<BigDecimal> atomicOperateAmount = new AtomicReference<BigDecimal>(operateAmount);
        if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) > 0) {
            List<MonthBudgetDetailVo> detailVos = this.detailedForecastMapper.findBudgetDetailByBusinessCode(dto.getActivityDetailItemCode(), TenantUtils.getTenantCode());
            Map<String, List<MonthBudgetDetailVo>> detailVosMap = detailVos.stream().filter(e -> BigDecimal.ZERO.compareTo(e.getCurOperationAmount()) < 0).collect(Collectors.groupingBy(MonthBudgetDetailVo::getMonthBudgetCode));
            this.release(dto, operateVos, atomicOperateAmount, detailVosMap);
            Validate.isTrue((BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) == 0 ? 1 : 0) != 0, (String)"\u9884\u4f30\u8d85\u989d\u8fd4\u8fd8\u9884\u7b97\u9519\u8bef\uff0c\u5269\u4f59\u5f85\u8fd4\u8fd8\uff1a%s", (Object[])new Object[]{atomicOperateAmount.get().abs()});
        } else {
            automaticVos = this.budgetProductProList(dto, automaticVos, budgetVos);
            List<String> budgetProjectCodes = this.filterBudgetProjectCodes(budgetVos);
            automaticVos = this.filterByProjectCodes(automaticVos, budgetProjectCodes);
            this.occupy(dto, operateVos, automaticVos, atomicOperateAmount, budgetProjectCodes);
        }
        return operateVos;
    }

    public List<MonthBudgetVo> budgetProductProList(DetailedForecastDto dto, List<MonthBudgetVo> automaticVos, List<MonthBudgetVo> budgetVos) {
        Set feeBelongCodeSet = budgetVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getFeeBelongCode())).map(MonthBudgetVo::getFeeBelongCode).collect(Collectors.toSet());
        if (feeBelongCodeSet.contains(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode())) {
            return automaticVos;
        }
        Validate.notBlank((CharSequence)dto.getSystemCode(), (String)"\u5339\u914d\u81ea\u6295\u4ea7\u54c1\u4fc3\u9500\u9884\u7b97\uff1a\u96f6\u552e\u5546\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRegion(), (String)"\u5339\u914d\u81ea\u6295\u4ea7\u54c1\u4fc3\u9500\u9884\u7b97\uff1a\u533a\u57df\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getYearMonthStr(), (String)"\u5339\u914d\u81ea\u6295\u4ea7\u54c1\u4fc3\u9500\u9884\u7b97\uff1a\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        automaticVos = this.detailedForecastMapper.findBudgetProductProList(dto, TenantUtils.getTenantCode(), VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode(), "KAYS030004");
        return automaticVos;
    }

    public List<String> filterBudgetProjectCodes(List<MonthBudgetVo> budgetVos) {
        Set feeBelongCodeSet = budgetVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getFeeBelongCode())).map(MonthBudgetVo::getFeeBelongCode).collect(Collectors.toSet());
        if (feeBelongCodeSet.size() == 0) {
            return Lists.newArrayList();
        }
        if (!feeBelongCodeSet.contains(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode())) {
            return Lists.newArrayList((Object[])new String[]{"KAYS030004"});
        }
        return Lists.newArrayList();
    }

    public List<MonthBudgetVo> filterByProjectCodes(List<MonthBudgetVo> vos, List<String> budgetProjectCodes) {
        vos = vos.stream().filter(e -> CollectionUtils.isEmpty((Collection)budgetProjectCodes) || budgetProjectCodes.contains(e.getBudgetItemCode())).collect(Collectors.toList());
        Validate.notEmpty(vos, (String)"\u672a\u5339\u914d\u5230\u9884\u7b97\u9879\u76ee\u4e3a[\u81ea\u6295\u4ea7\u54c1\u4fc3\u9500]\u7684\u9884\u7b97\uff01", (Object[])new Object[0]);
        return vos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void releaseVerticalBudget(List<String> businessCodeList) {
        if (CollectionUtils.isEmpty(businessCodeList)) {
            return;
        }
        List detailVos = this.monthBudgetService.findDetailByBusinessCodes(businessCodeList);
        if (CollectionUtils.isEmpty((Collection)detailVos)) {
            return;
        }
        List budgetCodes = detailVos.stream().map(MonthBudgetDetailVo::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean lock = this.monthBudgetLockService.lock(budgetCodes, TimeUnit.SECONDS, 10);
        Validate.isTrue((boolean)lock, (String)"\u64cd\u4f5c\u9884\u7b97\u5931\u8d25\uff0c\u83b7\u53d6\u64cd\u4f5c\u9501\u5931\u8d25\uff01", (Object[])new Object[0]);
        try {
            ArrayList operateMonthBudgetDtos = new ArrayList();
            Map<String, List<MonthBudgetDetailVo>> map1 = detailVos.stream().collect(Collectors.groupingBy(MonthBudgetDetailVo::getBusinessCode));
            map1.forEach((businessCode, v1) -> {
                Map<String, List<MonthBudgetDetailVo>> map2 = detailVos.stream().collect(Collectors.groupingBy(MonthBudgetDetailVo::getMonthBudgetCode));
                map2.forEach((budgetCode, v2) -> {
                    BigDecimal amount = v2.stream().map(MonthBudgetDetailVo::getCurOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    OperateMonthBudgetDto dto = new OperateMonthBudgetDto();
                    dto.setOperationType(BudgetOperationTypeEnum.FORECAST_OVER.getCode());
                    dto.setMonthBudgetCode(budgetCode);
                    dto.setBusinessCode(businessCode);
                    dto.setOperationAmount(amount.negate());
                    operateMonthBudgetDtos.add(dto);
                });
            });
            this.monthBudgetService.operateBudget(operateMonthBudgetDtos);
        }
        finally {
            this.monthBudgetLockService.unLock(budgetCodes);
        }
    }

    public void release(DetailedForecastDto dto, List<OperateMonthBudgetDto> operateVos, AtomicReference<BigDecimal> atomicOperateAmount, Map<String, List<MonthBudgetDetailVo>> detailVosMap) {
        block0: for (Map.Entry<String, List<MonthBudgetDetailVo>> entry : detailVosMap.entrySet()) {
            if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get().abs()) >= 0) break;
            String monthBudgetCode = entry.getKey();
            List<MonthBudgetDetailVo> list = entry.getValue();
            for (MonthBudgetDetailVo detailVo : list) {
                if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get().abs()) >= 0) continue block0;
                OperateMonthBudgetDto budgetDto = new OperateMonthBudgetDto();
                budgetDto.setMonthBudgetCode(monthBudgetCode);
                budgetDto.setOperationType(BudgetOperationTypeEnum.FORECAST_OVER.getCode());
                budgetDto.setBusinessCode(dto.getActivityDetailItemCode());
                if (atomicOperateAmount.get().abs().compareTo(detailVo.getCurOperationAmount()) >= 0) {
                    budgetDto.setOperationAmount(detailVo.getCurOperationAmount().negate());
                    atomicOperateAmount.set(atomicOperateAmount.get().add(detailVo.getCurOperationAmount()));
                } else {
                    budgetDto.setOperationAmount(atomicOperateAmount.get());
                    atomicOperateAmount.set(BigDecimal.ZERO);
                }
                operateVos.add(budgetDto);
            }
        }
    }

    public void occupy(DetailedForecastDto dto, List<OperateMonthBudgetDto> operateVos, List<MonthBudgetVo> vos, AtomicReference<BigDecimal> atomicOperateAmount, List<String> budgetProjectCodes) {
        vos.sort(Comparator.comparing(MonthBudgetVo::getMonthBudgetCode));
        int index = 0;
        for (MonthBudgetVo vo : vos) {
            ++index;
            if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) >= 0) break;
            OperateMonthBudgetDto budgetDto = new OperateMonthBudgetDto();
            budgetDto.setMonthBudgetCode(vo.getMonthBudgetCode());
            budgetDto.setOperationType(BudgetOperationTypeEnum.FORECAST_OVER.getCode());
            budgetDto.setBusinessCode(dto.getActivityDetailItemCode());
            if (vo.getAccumulatedAvailableBalance().compareTo(BigDecimal.ZERO) >= 0 && atomicOperateAmount.get().compareTo(vo.getAccumulatedAvailableBalance()) >= 0 && index != vos.size()) {
                budgetDto.setOperationAmount(vo.getAccumulatedAvailableBalance());
                atomicOperateAmount.set(atomicOperateAmount.get().subtract(vo.getAccumulatedAvailableBalance()));
            } else {
                budgetDto.setOperationAmount(atomicOperateAmount.get());
                atomicOperateAmount.set(BigDecimal.ZERO);
            }
            operateVos.add(budgetDto);
        }
    }

    public void refreshCal(DetailedForecastDto detailedForecastDto) {
        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u66f4\u65b0\u8ba1\u7b97", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        detailedForecastDto.setWriteOffConditions("");
        detailedForecastDto.setWriteOffConditionValue("");
        detailedForecastDto.setWriteOffFormula("");
        detailedForecastDto.setWriteOffFormulaValue("");
        detailedForecastDto.setWriteOffPremise("");
        detailedForecastDto.setEstimatedWriteOffAmount(null);
        detailedForecastDto.setCalEx("");
        detailedForecastDto.setCalParam("");
        detailedForecastDto.setOverBudgetRemark("");
        if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(detailedForecastDto.getAuditType()) || StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)detailedForecastDto.getBusinessUnitCode()) && (StringUtils.isEmpty((CharSequence)detailedForecastDto.getAuditType()) || "null".equals(detailedForecastDto.getAuditType()))) {
            if (StringUtils.equals((CharSequence)BusinessUnitEnum.HEADQUARTERS.getCode(), (CharSequence)detailedForecastDto.getBusinessUnitCode()) || StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)detailedForecastDto.getBusinessUnitCode())) {
                List detailPlanItemVos = this.activityDetailPlanItemSdkService.listByItemCodeList((List)Lists.newArrayList((Object[])new String[]{detailedForecastDto.getActivityDetailItemCode()}));
                Validate.notEmpty((Collection)detailPlanItemVos, (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801[%s]\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{detailedForecastDto.getActivityDetailItemCode()});
                detailedForecastDto.setEstimatedWriteOffAmount(((ActivityDetailPlanItemVo)detailPlanItemVos.get(0)).getFeeAmount());
            } else if (StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)detailedForecastDto.getBusinessUnitCode())) {
                List detailPlanItemVos = this.activityConstituentDetailPlanItemVoService.findDetailByItemCodeList((List)Lists.newArrayList((Object[])new String[]{detailedForecastDto.getActivityDetailItemCode()}));
                Validate.notEmpty((Collection)detailPlanItemVos, (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801[%s]\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{detailedForecastDto.getActivityDetailItemCode()});
                detailedForecastDto.setEstimatedWriteOffAmount(((SubComActivityDetailPlanItemVo)detailPlanItemVos.get(0)).getTotalCost());
            } else if (StringUtils.equals((CharSequence)BusinessUnitEnum.ONLINE.getCode(), (CharSequence)detailedForecastDto.getBusinessUnitCode())) {
                List generalExpensesVos = this.generalExpensesService.findByExpensesCode((List)Lists.newArrayList((Object[])new String[]{detailedForecastDto.getActivityDetailItemCode()}));
                Validate.notEmpty((Collection)generalExpensesVos, (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801[%s]\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{detailedForecastDto.getActivityDetailItemCode()});
                detailedForecastDto.setEstimatedWriteOffAmount(((GeneralExpensesVo)generalExpensesVos.get(0)).getApplyAmount());
            }
        } else {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = this.auditFormulaMainService.findByCode(detailedForecastDto.getAuditFormulaCode());
            }
            catch (Exception e2) {
                log.error("\u7ec6\u6848\u7f16\u7801[" + detailedForecastDto.getDetailedCaseCode() + "]\u660e\u7ec6\u7f16\u7801[" + detailedForecastDto.getActivityDetailItemCode() + "]\u7ec6\u6848\u9884\u6d4b\u66f4\u65b0\u8ba1\u7b97\uff01" + e2.getMessage(), (Throwable)e2);
            }
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(detailedForecastDto.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
                dto.setAuditType(detailedForecastDto.getAuditType());
                dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(detailedForecastDto.getRtmMode());
                dto.setFirstChannel(detailedForecastDto.getFirstChannelCode());
                dto.setSecondChannel(detailedForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(detailedForecastDto.getCustomerAccount());
                dto.setDisplayNumber(detailedForecastDto.getDisplayNumber());
                dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
                List formulaMainVoList = this.auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    auditFormulaMainVo = (AuditFormulaMainVo)formulaMainVoList.get(0);
                } else {
                    detailedForecastDto.setAuditFormulaCode(null);
                }
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, detailedForecastDto.getAuditType());
            this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
        }
    }

    public CalculateDto buildCalParam(AuditFormulaMainVo auditFormulaMainVo, DetailedForecastDto detailedForecastDto, String auditType) {
        if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty((Collection)auditFormulaMainVo.getAuditFormulaInfoVoList())) {
            CalculateDto dto = new CalculateDto();
            dto.setCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setCustomerCode(detailedForecastDto.getCustomerCode());
            dto.setCustomerErpCode(detailedForecastDto.getCustomerErpCode());
            dto.setCustomerName(detailedForecastDto.getCustomer());
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setActivityTypeName(detailedForecastDto.getActivityTypeName());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityFormName(detailedForecastDto.getActivityFormName());
            dto.setStartTimeOrDate(detailedForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(detailedForecastDto.getActivityEndTime());
            dto.setFormulaInfoDtoList(this.copyFormulaInfoList(auditFormulaMainVo.getAuditFormulaInfoVoList()));
            dto.setAuditType(auditType);
            dto.setSalesOrgCode(detailedForecastDto.getSaleOrgCode());
            dto.setSalesOrgErpCode(detailedForecastDto.getSalesOrgErpCode());
            dto.setSalesOrganizationCode(detailedForecastDto.getSalesInstitutionCode());
            dto.setSalesOrganizationErpCode(detailedForecastDto.getSalesInstitutionErpCode());
            dto.setSalesRegionCode(detailedForecastDto.getSalesRegionCode());
            dto.setSalesRegionErpCode(detailedForecastDto.getSalesRegionErpCode());
            dto.setSalesGroupCode(detailedForecastDto.getSalesGroupCode());
            dto.setSalesGroupErpCode(detailedForecastDto.getSalesOrgErpCode());
            dto.setProductCode(detailedForecastDto.getProductCode());
            dto.setYearMonthLy(detailedForecastDto.getYearMonthStr());
            dto.setStoresCode(detailedForecastDto.getTerminalCode());
            dto.setBrandCode(detailedForecastDto.getProductBrandCode());
            dto.setCategoryCode(detailedForecastDto.getProductCategoryCode());
            dto.setItemCode(detailedForecastDto.getProductItemCode());
            dto.setDetailPlanItemCode(detailedForecastDto.getActivityDetailItemCode());
            dto.setActivityDetailItemCode(detailedForecastDto.getActivityDetailItemCode());
            dto.setPlanItemCode(detailedForecastDto.getDetailedCaseCode());
            dto.setActivityOrgCode(detailedForecastDto.getRegion());
            dto.setActivityOrgName(detailedForecastDto.getRegionName());
            dto.setRetailBusinessmanCode(detailedForecastDto.getSystemCode());
            dto.setRetailBusinessmanName(detailedForecastDto.getSystemName());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setPersonCode(detailedForecastDto.getPersonCode());
            dto.setIdentityCard(detailedForecastDto.getIdentityCard());
            dto.setSecondChannelCode(detailedForecastDto.getSecondChannelCode());
            dto.setEstoreCustomerLevel(detailedForecastDto.getEstoreCustomerLevel());
            if (Objects.nonNull(detailedForecastDto.getActivityStartTime())) {
                String date = DateUtil.format((Date)detailedForecastDto.getActivityStartTime(), (String)"yyyy-MM-dd");
                if (date.length() == 10) {
                    dto.setDate(DateUtil.parse((String)date, (String)"yyyy-MM-dd"));
                } else if (date.length() == 19) {
                    dto.setDate(DateUtil.parse((String)date, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            dto.setDealerCode(detailedForecastDto.getCustomerErpCode());
            dto.setChannel(detailedForecastDto.getChannelCode());
            dto.setStartTimeOrDate(detailedForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(detailedForecastDto.getActivityEndTime());
            dto.setPersonIdCard(detailedForecastDto.getIdentityCard());
            dto.setFirstChannelCode(detailedForecastDto.getFirstChannelCode());
            dto.setSecondChannelCode(detailedForecastDto.getSecondChannelCode());
            dto.setHeadBudgetItemCode(detailedForecastDto.getHeadBudgetItemCode());
            dto.setMonthBudgetCode(detailedForecastDto.getMonthBudgetCode());
            dto.setSpecification(detailedForecastDto.getFormDescription());
            dto.setIsTemporary(detailedForecastDto.getIsTemporary());
            dto.setCusCreateTime(detailedForecastDto.getCusCreateTime());
            dto.setDistributionChannel(detailedForecastDto.getDistributionChannelCode());
            dto.setDeliveryPartyCode(detailedForecastDto.getTerminalCode());
            if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()) && BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
                Map map = this.tpmCustomerSummaryConfigureService.configureIncludeMap((List)Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}));
                if (map.containsKey(dto.getCustomerCode())) {
                    dto.setCustomerCodeList((Set)map.get(dto.getCustomerCode()));
                } else {
                    dto.setCustomerCodeList((Set)Sets.newHashSet((Object[])new String[]{dto.getCustomerCode()}));
                }
            }
            return dto;
        }
        log.info("\u7ec6\u6848\u9884\u6d4b=====\u300b\u6838\u9500\u6761\u4ef6\u4e3a\u7a7a");
        return null;
    }

    public void setParam(AuditFormulaMainVo auditFormulaMainVo, DetailedForecastDto detailedForecastDto, CalculateDto calDto) {
        if (Objects.isNull(calDto)) {
            return;
        }
        detailedForecastDto.setCalEx("");
        List calculateVos = Lists.newArrayList();
        try {
            calculateVos = this.variableService.orCalculateConditionAndExpression((List)Lists.newArrayList((Object[])new CalculateDto[]{calDto}));
        }
        catch (Exception ex) {
            if (StringUtils.isNotEmpty((CharSequence)ex.getMessage())) {
                int length = Math.min(ex.getMessage().length(), 200);
                detailedForecastDto.setCalEx(ex.getMessage().substring(0, length));
            } else {
                detailedForecastDto.setCalEx("NPE");
            }
            log.error("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u8ba1\u7b97\u5931\u8d25\uff1a{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), ex.getMessage()});
            log.error("", (Throwable)ex);
        }
        AtomicReference<String> filterCondition = new AtomicReference<String>();
        List filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        if (filterVos.size() > 1) {
            log.error("\u6838\u9500\u516c\u5f0f\u7f16\u7801 [" + auditFormulaMainVo.getAuditFormulaCode() + "] \u8ba1\u7b97\u7ed3\u679c\uff1a\u591a\u4e2a\u6838\u9500\u516c\u5f0f\u6761\u4ef6\u540c\u65f6\u6ee1\u8db3\uff01");
        } else if (CollectionUtils.isNotEmpty(filterVos)) {
            filterCondition.set(((CalculateVo)filterVos.get(0)).getFormulaConditionName());
        }
        BigDecimal estimatedWriteOffAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = ((CalculateVo)filterVos.get(0)).getFormulaValue();
        } else {
            log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u672a\u6ee1\u8db3\u516c\u5f0f\u4efb\u4f55\u6761\u4ef6\uff0c\u9ed8\u8ba4\u9884\u6838\u9500\u91d1\u989d\u4e3a0\uff01", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        }
        HashMap variableValueMap = new HashMap();
        calculateVos.forEach(v -> {
            if (Objects.nonNull(v.getVariableValueMap())) {
                variableValueMap.putAll(v.getVariableValueMap());
            }
        });
        ArrayList variableCodeList = new ArrayList();
        for (CalculateVo calculateVo : calculateVos) {
            if (!Objects.nonNull(calculateVo.getVariableValueMap())) continue;
            variableCodeList.addAll(calculateVo.getVariableValueMap().keySet());
        }
        Map variableNameMap = this.variableService.getVariableMap(VariableFunctionEnum.AUDIT.getCode(), variableCodeList);
        HashMap conditionValueMap = new HashMap();
        HashMap formulaValueMap = new HashMap();
        ArrayList canAuditPreList = new ArrayList();
        auditFormulaMainVo.getAuditFormulaInfoVoList().forEach(formula -> {
            Set formulaCondition = MathUtil.getFormulaReplace((String)formula.getAuditFormulaCondition());
            formulaCondition.forEach(v -> {
                if (conditionValueMap.containsKey(v)) {
                    return;
                }
                if (variableValueMap.containsKey(v)) {
                    conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + ((BigDecimal)variableValueMap.get(v)).toString());
                    return;
                }
                conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
            });
            Set auditFormula = MathUtil.getFormulaReplace((String)formula.getAuditFormula());
            auditFormula.forEach(v -> {
                if (formulaValueMap.containsKey(v)) {
                    return;
                }
                if (variableValueMap.containsKey(v)) {
                    formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + ((BigDecimal)variableValueMap.get(v)).toString());
                    return;
                }
                formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                canAuditPreList.add(variableNameMap.getOrDefault(v, v) + "\u8fbe\u6807");
            });
        });
        detailedForecastDto.setCalParam(JSON.toJSONString((Object)calDto));
        detailedForecastDto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
        detailedForecastDto.setWriteOffConditions(auditFormulaMainVo.getAuditFormulaInfoVoList().stream().filter(e -> StringUtils.equals((CharSequence)e.getAuditFormulaConditionName(), (CharSequence)((CharSequence)filterCondition.get()))).map(AuditFormulaInfoVo::getAuditFormulaConditionName).filter(Objects::nonNull).collect(Collectors.joining(" , ")));
        detailedForecastDto.setWriteOffFormula(auditFormulaMainVo.getAuditFormulaInfoVoList().stream().filter(e -> StringUtils.equals((CharSequence)e.getAuditFormulaConditionName(), (CharSequence)((CharSequence)filterCondition.get()))).map(AuditFormulaInfoVo::getAuditFormulaName).filter(Objects::nonNull).collect(Collectors.joining(" , ")));
        detailedForecastDto.setWriteOffConditionValue(String.join((CharSequence)" , ", conditionValueMap.values()));
        detailedForecastDto.setWriteOffFormulaValue(String.join((CharSequence)" , ", formulaValueMap.values()));
        detailedForecastDto.setEstimatedWriteOffAmount(estimatedWriteOffAmount);
        detailedForecastDto.setWriteOffPremise(String.join((CharSequence)" , ", canAuditPreList));
    }

    public List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        ArrayList<FormulaInfoDto> list = new ArrayList<FormulaInfoDto>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }

    public List<AuditExecuteIndicatorVo> getMinusCompostQuantity(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.auditExecuteIndicatorService.getMinusCompostQuantity(detailPlanItemCodes);
    }
}

