/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.util;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastWashDataMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.VerticalFeeBelongCodeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DetailedForecastVerticalBudgetDataUtil {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastVerticalBudgetDataUtil.class);
    @Autowired(required=false)
    private DetailedForecastRepository detailedForecastRepository;
    @Autowired(required=false)
    private DetailedForecastWashDataMapper detailedForecastWashDataMapper;
    @Autowired(required=false)
    private DetailedForecastMapper detailedForecastMapper;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    @Transactional
    public void initBudget(List<String> budgetCodeList) {
    }

    @Transactional
    public void washData(List<String> activityDetailItemCodeList) {
    }

    @Transactional
    public void verticalOperateBudget(DetailedForecastDto dto) {
        BigDecimal operateAmount = dto.getEstimatedWriteOffAmount().subtract(dto.getApplyAmount());
        String overBudgetSuccess = YesOrNoEnum.YES.getCode();
        BigDecimal overBudgetFailAmount = BigDecimal.ZERO;
        List<ActivityDetailPlanBudgetVo> budgetVos = this.detailedForecastMapper.findActivityDetailBudgetCodes(dto.getActivityDetailItemCode(), TenantUtils.getTenantCode());
        try {
            List<String> useBudgetCodeList = this.getBudgetSortList(budgetVos);
            List<OperateMonthBudgetDto> operateVos = this.buildOperateList(operateAmount, dto, useBudgetCodeList);
            this.monthBudgetService.operateBudget(operateVos);
            dto.setOverBudgetRemark("");
        }
        catch (Exception e) {
            e.printStackTrace();
            String exMsg = "\u5782\u76f4\u5355\u5143-\u7ec6\u6848\u9884\u6d4b-\u8865\u5360\u9884\u7b97\u5f02\u5e38\uff1a" + e.getMessage();
            if (exMsg.length() > 300) {
                exMsg = exMsg.substring(0, 300);
            }
            dto.setOverBudgetRemark(exMsg);
            overBudgetSuccess = YesOrNoEnum.NO.getCode();
        }
        if (StringUtils.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)overBudgetSuccess)) {
            overBudgetFailAmount = dto.getEstimatedWriteOffAmount();
        }
        dto.setOverBudgetFailAmount(overBudgetFailAmount);
        dto.setOverBudgetSuccess(overBudgetSuccess);
    }

    public List<String> getBudgetSortList(List<ActivityDetailPlanBudgetVo> budgetVos) {
        Validate.notEmpty(budgetVos, (String)"\u7ec6\u6848\u9884\u6d4b\u8865\u5360\u9884\u7b97-\u4f7f\u7528\u9884\u7b97\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List sortedList = budgetVos.stream().filter(e -> Objects.nonNull(e.getUseAmount()) && VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode().equals(e.getFeeBelongCode())).sorted(Comparator.comparing(ActivityDetailPlanBudgetVo::getUseAmount).reversed()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sortedList)) {
            return Lists.newArrayList();
        }
        BigDecimal useAmount = ((ActivityDetailPlanBudgetVo)sortedList.get(0)).getUseAmount();
        Map sortedMap = sortedList.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getUseAmount, Collectors.mapping(ActivityDetailPlanBudgetVo::getMonthBudgetCode, Collectors.toList())));
        List budgetCodes = sortedMap.get(useAmount);
        Collections.sort(budgetCodes);
        return Lists.newArrayList((Object[])new String[]{(String)budgetCodes.get(0)});
    }

    public List<OperateMonthBudgetDto> buildOperateList(BigDecimal operateAmount, DetailedForecastDto dto, List<String> budgetCodes) {
        List budgetVos = this.monthBudgetService.findByCodes(budgetCodes, EnableStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isEmpty((Collection)budgetVos)) {
            budgetVos = Lists.newArrayList();
        }
        Map<String, List<MonthBudgetVo>> budgetVosMap = budgetVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getFeeBelongCode())).collect(Collectors.groupingBy(MonthBudgetVo::getFeeBelongCode));
        List<MonthBudgetVo> automaticVos = budgetVosMap.getOrDefault(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode(), Lists.newArrayList());
        ArrayList<OperateMonthBudgetDto> operateVos = new ArrayList<OperateMonthBudgetDto>();
        AtomicReference<BigDecimal> atomicOperateAmount = new AtomicReference<BigDecimal>(operateAmount);
        automaticVos = this.budgetProductProList(dto, automaticVos, budgetVos);
        List<String> budgetProjectCodes = this.filterBudgetProjectCodes(budgetVos);
        automaticVos = this.filterByProjectCodes(automaticVos, budgetProjectCodes);
        this.occupy(dto.getActivityDetailItemCode(), operateVos, automaticVos, atomicOperateAmount, budgetProjectCodes);
        return operateVos;
    }

    public List<MonthBudgetVo> budgetProductProList(DetailedForecastDto dto, List<MonthBudgetVo> automaticVos, List<MonthBudgetVo> budgetVos) {
        Set feeBelongCodeSet = budgetVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getFeeBelongCode())).map(MonthBudgetVo::getFeeBelongCode).collect(Collectors.toSet());
        if (feeBelongCodeSet.contains(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode())) {
            return automaticVos;
        }
        Validate.notBlank((CharSequence)dto.getSystemCode(), (String)"\u5339\u914d\u81ea\u6295\u4ea7\u54c1\u4fc3\u9500\u9884\u7b97\uff1a\u96f6\u552e\u5546\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRegion(), (String)"\u5339\u914d\u81ea\u6295\u4ea7\u54c1\u4fc3\u9500\u9884\u7b97\uff1a\u533a\u57df\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getYearMonthStr(), (String)"\u5339\u914d\u81ea\u6295\u4ea7\u54c1\u4fc3\u9500\u9884\u7b97\uff1a\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        automaticVos = this.detailedForecastMapper.findBudgetProductProList(dto, TenantUtils.getTenantCode(), VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode(), "KAYS030004");
        return automaticVos;
    }

    public List<String> filterBudgetProjectCodes(List<MonthBudgetVo> budgetVos) {
        Set feeBelongCodeSet = budgetVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getFeeBelongCode())).map(MonthBudgetVo::getFeeBelongCode).collect(Collectors.toSet());
        if (feeBelongCodeSet.size() == 0) {
            return Lists.newArrayList();
        }
        if (!feeBelongCodeSet.contains(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode())) {
            return Lists.newArrayList((Object[])new String[]{"KAYS030004"});
        }
        return Lists.newArrayList();
    }

    public List<MonthBudgetVo> filterByProjectCodes(List<MonthBudgetVo> vos, List<String> budgetProjectCodes) {
        vos = vos.stream().filter(e -> CollectionUtils.isEmpty((Collection)budgetProjectCodes) || budgetProjectCodes.contains(e.getBudgetItemCode())).collect(Collectors.toList());
        Validate.notEmpty(vos, (String)"\u672a\u5339\u914d\u5230\u9884\u7b97\u9879\u76ee\u4e3a[\u81ea\u6295\u4ea7\u54c1\u4fc3\u9500]\u7684\u9884\u7b97\uff01", (Object[])new Object[0]);
        return vos;
    }

    public void occupy(String activityDetailItemCode, List<OperateMonthBudgetDto> operateVos, List<MonthBudgetVo> vos, AtomicReference<BigDecimal> atomicOperateAmount, List<String> budgetProjectCodes) {
        vos.sort(Comparator.comparing(MonthBudgetVo::getMonthBudgetCode));
        int index = 0;
        for (MonthBudgetVo vo : vos) {
            ++index;
            if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) >= 0) break;
            OperateMonthBudgetDto budgetDto = new OperateMonthBudgetDto();
            budgetDto.setMonthBudgetCode(vo.getMonthBudgetCode());
            budgetDto.setOperationType(BudgetOperationTypeEnum.FORECAST_OVER.getCode());
            budgetDto.setBusinessCode(activityDetailItemCode);
            if (vo.getAccumulatedAvailableBalance().compareTo(BigDecimal.ZERO) >= 0 && atomicOperateAmount.get().compareTo(vo.getAccumulatedAvailableBalance()) >= 0 && index != vos.size()) {
                budgetDto.setOperationAmount(vo.getAccumulatedAvailableBalance());
                atomicOperateAmount.set(atomicOperateAmount.get().subtract(vo.getAccumulatedAvailableBalance()));
            } else {
                budgetDto.setOperationAmount(atomicOperateAmount.get());
                atomicOperateAmount.set(BigDecimal.ZERO);
            }
            operateVos.add(budgetDto);
        }
    }
}

