package com.biz.crm.tpm.business.distrib.close.data.policy.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.biz.crm.tpm.business.distrib.close.data.policy.service.PlatformLogisticsService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.PlatformLogisticsDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;
import java.util.List;

import com.biz.crm.business.common.sdk.model.Result;

/**
 * 平台物流底表
 *
 * @author zhouyang
 * @date 2023-07-20 11:54:47
 */
@Slf4j
@RestController
@RequestMapping("/v1/platformLogistics")
@Api(tags = "平台物流底表")
public class PlatformLogisticsController {

    @Autowired
    private PlatformLogisticsService service;

    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<PlatformLogisticsVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "dto", value = "平台物流底表") PlatformLogisticsDto dto) {
        try {
            return Result.ok(this.service.findByConditions(pageable, dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "详情(编辑页面使用),通过主键进行数据的查询")
    @GetMapping("/findDetailsById")
    public Result<PlatformLogisticsVo> findDetailsById(@RequestParam(value = "id") @ApiParam(name = "id", value = "主键ID") String id) {
        try {
            return Result.ok(this.service.findDetailsById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    /**
     * 删除数据（物理删除）
     *
     * @param ids 主键集合
     * @return
     */
    @ApiOperation(value = "删除数据（物理删除）")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            service.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
