package com.biz.crm.tpm.business.distrib.close.data.policy.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 分销结案政策(TpmDistribClosePolicy)表相关的接口
 *
 * @author hd
 * @create 2023-02-13 15:01:38
 */
@RestController
@RequestMapping("/v1/tpmDistribClosePolicy")
@Slf4j
@Api(tags = "TMP-分销结案政策")
public class TpmDistribClosePolicyController {

    @Autowired(required = false)
    private TpmDistribClosePolicyService tpmDistribClosePolicyService;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmDistribClosePolicyVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "dto", value = "分销结案政策") TpmDistribClosePolicyDto dto) {
        try {
            Page<TpmDistribClosePolicyVo> page = this.tpmDistribClosePolicyService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键集合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            tpmDistribClosePolicyService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量新增
     *
     * @param importList
     */
    @ApiOperation(value = "批量新增")
    @PostMapping("/saveBatchData")
    public Result<?> saveBatchData(@RequestBody List<TpmDistribClosePolicyDto> importList) {
        try {
            tpmDistribClosePolicyService.saveBatchData(importList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
