package com.biz.crm.tpm.business.distrib.close.data.policy.entity;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 平台物流底表
 *
 * @author zhouyang
 * @date 2023-07-20 11:54:47
 */
@Data
@Entity(name = "tpm_platform_logistics")
@TableName("tpm_platform_logistics")
@Table(name = "tpm_platform_logistics")
@org.hibernate.annotations.Table(appliesTo = "tpm_platform_logistics", comment = "平台物流底表")
@ApiModel(value = "PlatformLogistics", description = "平台物流底表")
public class PlatformLogistics extends TenantFlagOpEntity{

    @ApiModelProperty("年月")
    @Column(name = "year_and_month", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '年月'")
    private String yearAndMonth;

    @ApiModelProperty("sap商品编码")
    @Column(name = "sap_product_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT 'sap商品编码'")
    private String sapProductCode;

    @ApiModelProperty("sap商品名称")
    @Column(name = "sap_product_name", length = 128, columnDefinition = "varchar(128) COMMENT 'sap商品名称'")
    private String sapProductName;

    @ApiModelProperty("备案店铺名")
    @Column(name = "store_name", length = 128, columnDefinition = "varchar(128) COMMENT '备案店铺名'")
    private String storeName;

    @ApiModelProperty("商品编码")
    @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty("商品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "varchar(128) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty("订单号")
    @Column(name = "order_code", nullable = false, length = 128, columnDefinition = "varchar(128) COMMENT '订单号'")
    private String orderCode;

    @ApiModelProperty("订单状态")
    @Column(name = "order_status", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '订单状态'")
    private String orderStatus;

    @ApiModelProperty("商品数量")
    @Column(name = "product_number",length = 10, columnDefinition = "int(10) COMMENT '商品数量'")
    private Integer productNumber;

    @ApiModelProperty("提数")
    @Column(name = "number",length = 10, columnDefinition = "int(10) COMMENT '提数'")
    private Integer number;

    @ApiModelProperty("支付时间")
    @Column(name = "pay_time", columnDefinition = "datetime COMMENT '支付时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date payTime;

    @ApiModelProperty("承诺发货时间")
    @Column(name = "promise_delivery_time", columnDefinition = "datetime COMMENT '承诺发货时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date promiseDeliveryTime;

    @ApiModelProperty("发货时间")
    @Column(name = "delivery_time", columnDefinition = "datetime COMMENT '发货时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date deliveryTime;

    @ApiModelProperty("商品id")
    @Column(name = "product_id", length = 64, columnDefinition = "varchar(64) COMMENT '商品id'")
    private String productId;

    @ApiModelProperty("商品规格")
    @Column(name = "product_spec", length = 32, columnDefinition = "varchar(32) COMMENT '商品规格'")
    private String productSpec;

    @ApiModelProperty("售后状态")
    @Column(name = "after_sales_status", length = 32, columnDefinition = "varchar(32) COMMENT '售后状态'")
    private String afterSalesStatus;

    @ApiModelProperty("快递单号")
    @Column(name = "delivery_code", length = 128, columnDefinition = "varchar(128) COMMENT '快递单号'")
    private String deliveryCode;

    @ApiModelProperty("快递公司")
    @Column(name = "delivery_company", length = 128, columnDefinition = "varchar(128) COMMENT '快递公司'")
    private String deliveryCompany;

    @ApiModelProperty("发货人手机号")
    @Column(name = "delivery_person_phone", length = 32, columnDefinition = "varchar(32) COMMENT '发货人手机号'")
    private String deliveryPersonPhone;

    @ApiModelProperty("省")
    @Column(name = "delivery_province", length = 32, columnDefinition = "varchar(32) COMMENT '省'")
    private String deliveryProvince;

    @ApiModelProperty("市")
    @Column(name = "delivery_city", length = 32, columnDefinition = "varchar(32) COMMENT '市'")
    private String deliveryCity;

    @ApiModelProperty("区县")
    @Column(name = "delivery_district", length = 32, columnDefinition = "varchar(32) COMMENT '区县'")
    private String deliveryDistrict;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "varchar(64) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "varchar(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("单据号")
    @Column(name = "item_key", length = 128, columnDefinition = "varchar(128) COMMENT '单据号'")
    private String itemKey;

    @ApiModelProperty("业态")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态 '")
    private String businessFormatCode;

    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty("销售组织编码")
    @Column(name = "sales_org_code",  length = 32, columnDefinition = "VARCHAR(128) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    @Column(name = "sales_org_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String salesOrgName;
}