package com.biz.crm.tpm.business.distrib.close.data.policy.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author hd
 * @create 2023-02-13 15:01:38
 */
@ApiModel(value = "TpmDistribClosePolicy", description = "TPM-分销结案政策")
@TableName("tpm_distrib_close_policy")
@Getter
@Setter
@Entity(name = "tpm_distrib_close_policy")
@org.hibernate.annotations.Table(appliesTo = "tpm_distrib_close_policy", comment = "TPM-分销结案政策")
@Table(name = "tpm_distrib_close_policy", indexes = {
        @Index(name = "tpm_distrib_close_policy_index1", columnList = "id", unique = true),
        @Index(name = "tpm_distrib_close_policy_index2", columnList = "channel_code,sale_department_code"),
        @Index(name = "tpm_distrib_close_policy_index3", columnList = "platform_code")
})
public class TpmDistribClosePolicyEntity extends TenantFlagOpEntity {

    @ApiModelProperty("业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    @ApiModelProperty("业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "varchar(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;

    @ApiModelProperty("渠道")
    @Column(name = "channel", length = 64, columnDefinition = "varchar(64) COMMENT '渠道'")
    private String channel;

    @ApiModelProperty("开始日期(yyyy-MM-dd)")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "start_date", length = 32, columnDefinition = "varchar(32) COMMENT '开始日期'")
    private String startDate;

    @ApiModelProperty("结束日期(yyyy-MM-dd)")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date", length = 32, columnDefinition = "varchar(32) COMMENT '结束日期'")
    private String endDate;

    @ApiModelProperty("销售组编码")
    @Column(name = "sales_group_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码 '")
    private String salesGroupCode;

    @ApiModelProperty("销售组名称")
    @Column(name = "sales_group_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组 '")
    private String salesGroupName;

    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("销售部门编码")
    @Column(name = "sale_department_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售部门编码'")
    private String saleDepartmentCode;

    @ApiModelProperty("销售部门名称")
    @Column(name = "sale_department_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售部门名称'")
    private String saleDepartmentName;

    @ApiModelProperty("平台")
    @Column(name = "platform_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '平台 '")
    private String platformName;

    @ApiModelProperty("平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '平台编码 '")
    private String platformCode;

    @ApiModelProperty("电商客户等级")
    @Column(name = "estore_customer_level", length = 10, columnDefinition = "VARCHAR(10) COMMENT '电商客户等级'")
    private String estoreCustomerLevel;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "varchar(64) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户ERP编码")
    @Column(name = "customer_erp_code", length = 64, columnDefinition = "varchar(64) COMMENT '客户ERP编码'")
    private String customerErpCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("基础返点-旬返")
    @Column(name = "ten_day_return", columnDefinition = "decimal(20,6) COMMENT '基础返点-旬返'")
    private BigDecimal tenDayReturn;

    @ApiModelProperty("基础返点-月返")
    @Column(name = "lunar_return", columnDefinition = "decimal(20,6) COMMENT '基础返点-月返'")
    private BigDecimal lunarReturn;

    @ApiModelProperty("月度目标返")
    @Column(name = "monthly_target_return", columnDefinition = "decimal(20,6) COMMENT '月度目标返'")
    private BigDecimal monthlyTargetReturn;

    @ApiModelProperty("到手价政策")
    @Column(name = "take_home_price_policy", columnDefinition = "decimal(20,6) COMMENT '到手价政策'")
    private BigDecimal takeHomePricePolicy;

    @ApiModelProperty("人员费用")
    @Column(name = "staff_costs", columnDefinition = "decimal(20,6) COMMENT '人员费用'")
    private BigDecimal staffCosts;

    @ApiModelProperty("投放费用")
    @Column(name = "cost_of_placement", columnDefinition = "decimal(20,6) COMMENT '投放费用'")
    private BigDecimal costOfPlacement;

    @ApiModelProperty("物流支持")
    @Column(name = "logistics_support", columnDefinition = "decimal(20,6) COMMENT '物流支持'")
    private BigDecimal logisticsSupport;

    @ApiModelProperty("捆绑返点")
    @Column(name = "bundle_return_point", columnDefinition = "decimal(20,6) COMMENT '捆绑返点'")
    private BigDecimal bundleReturnPoint;

    @ApiModelProperty("其他支持")
    @Column(name = "other_cooperation", columnDefinition = "decimal(20,6) COMMENT '其他支持'")
    private BigDecimal otherCooperation;

    @ApiModelProperty("其他支持2")
    @Column(name = "other_cooperation_two", columnDefinition = "decimal(20,6) COMMENT '其他支持2'")
    private BigDecimal otherCooperationTwo;

    @ApiModelProperty("其他支持3")
    @Column(name = "other_cooperation_three", columnDefinition = "decimal(20,6) COMMENT '其他支持3'")
    private BigDecimal otherCooperationThree;

    @ApiModelProperty("其他支持4")
    @Column(name = "other_cooperation_four", columnDefinition = "decimal(20,6) COMMENT '其他支持4'")
    private BigDecimal otherCooperationFour;

    @ApiModelProperty("季返")
    @Column(name = "quarter_return", columnDefinition = "decimal(20,6) COMMENT '季返'")
    private BigDecimal quarterReturn;

    @ApiModelProperty("年返")
    @Column(name = "annual_return", columnDefinition = "decimal(20,6) COMMENT '年返'")
    private BigDecimal annualReturn;

    @ApiModelProperty(value = "渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty("销售组ERP编码")
    @Column(name = "sales_group_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组ERP编码'")
    private String salesGroupErpCode;

    @ApiModelProperty("销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty("销售部门ERP编码")
    @Column(name = "sale_department_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门ERP编码'")
    private String saleDepartmentErpCode;
}
