package com.biz.crm.tpm.business.distrib.close.data.policy.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.TpmDistribClosePolicyEntity;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DataCheckVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * 分销结案政策(TpmDistribClosePolicy)表mybatis访问层
 *
 * @author hd
 * @create 2023-02-13 15:01:38
 */
public interface TpmDistribClosePolicyMapper extends BaseMapper<TpmDistribClosePolicyEntity> {

    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param dto  查询条件实体
     * @return 所有数据
     */
    Page<TpmDistribClosePolicyVo> findByConditions(@Param("page") Page<TpmDistribClosePolicyDto> page, @Param("dto") TpmDistribClosePolicyDto dto);

    /**
     * 查询数据的校验条件
     *
     * @return
     */
    List<DataCheckVo> findConditionAll();

    /**
     * 根据参数查询
     *
     * @param dto 查询参数
     * @return List
     */
    List<TpmDistribClosePolicyVo> findDistribClosePolicy(@Param("dto") TpmDistribClosePolicyDto dto);

    /**
     * 根据条件查询
     * @param dto
     * @param yearMonthLy
     * @return list
     */
    List<TpmDistribClosePolicyVo> findByCondition(@Param("dto") TpmDistribClosePolicyDto dto, @Param("yearMonthLy") String yearMonthLy);

    List<TpmDistribClosePolicyVo> findPolicyForDistributionCustomerAuditData(@Param("dto") TpmDistribClosePolicyDto distribClosePolicyDto);

    /**
     * 批量新增
     *
     * @param saveList
     */
    void saveBatchData(@Param("saveList") Collection<TpmDistribClosePolicyEntity> saveList);

    /**
     * 获取投放费用
     *
     * @param closePolicyDtos
     * @param tenantCode
     * @return
     */
    List<TpmDistribClosePolicyVo> findCostOfPlacement(@Param("closePolicyDtos") Collection<TpmDistribClosePolicyDto> closePolicyDtos, @Param("tenantCode") String tenantCode);
}
