package com.biz.crm.tpm.business.distrib.close.data.policy.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.TpmDistribClosePolicyEntity;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.constant.DistribClosePolicyConstant;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DataCheckVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DistribClosePolicyImportVo;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.TpmSalesVolumeChannelDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.service.TpmSalesVolumeChannelService;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.vo.TpmSalesVolumeChannelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import javassist.bytecode.stackmap.BasicBlock;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;



import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Component
public class DistribClosePolicyImportProcess implements ImportProcess<DistribClosePolicyImportVo> {

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;
    @Autowired(required = false)
    private TpmSalesVolumeChannelService tpmSalesVolumeChannelService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private TpmDistribClosePolicyService tpmDistribClosePolicyService;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;


    /**
     * 数据分片
     *
     * @return 分片长度
     */
    @Override
    public Integer getBatchCount() {
        return 1000;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, DistribClosePolicyImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Integer, String> errorMap = Maps.newHashMap();
        try {
            Validate.notNull(data, "导入数据不能为空！");
            Validate.isTrue(data.values().size() <= 1000, "单次导入数据不能超过1000条");
            List<TpmDistribClosePolicyDto> importList = this.validate(data,errorMap);
            if (errorMap.isEmpty()) {
                tpmDistribClosePolicyService.saveBatchData(importList);
            }else {
                return errorMap;
            }
        } catch (Exception e) {
            log.error("日志导入失败");
            throw e;
        }
        return errorMap;
    }


    /**
     * 校验单行数据正确性
     *
     * @param data
     * @return
     */
    private List<TpmDistribClosePolicyDto> validate(LinkedHashMap<Integer, DistribClosePolicyImportVo> data,Map<Integer, String> errorMap) {
        //获取业务单元字典
        log.info("日志启用1");
        Map<String, String> unitMap = dictToolkitService.findConvertMapByDictTypeCode(DistribClosePolicyConstant.DISCOUNT_RATE_BUSINESS_UNIT);
        Validate.isTrue(ObjectUtils.isNotEmpty(unitMap), "未查询到业务单元数据字典!");
        Collection<DistribClosePolicyImportVo> values = data.values();
        Map<String, List<CustomerVo>> customerVoMap = new HashMap<>();
        Map<String, List<SalesOrgVo>> salesInstitutionMap = new HashMap<>();
        Map<String, List<SalesOrgVo>> saleDepartmentMap = new HashMap<>();
        Map<String, List<SalesOrgVo>> salesGroupMap = new HashMap<>();
        Map<String, List<ProductVo>> productMap = new HashMap<>();
        // 查询主数据信息
        queryMasterData(values, customerVoMap, salesInstitutionMap, saleDepartmentMap, salesGroupMap,productMap);
        //获取业态字典
        Map<String, String> formatMap = dictToolkitService.findConvertMapByDictTypeCode(DistribClosePolicyConstant.DISCOUNT_RATE_BUSINESS_FORMAT);
        Validate.isTrue(ObjectUtils.isNotEmpty(formatMap), "未查询到业态数据字典!");
        List<TpmDistribClosePolicyDto> policyEntities = new ArrayList<>();
        List<DataCheckVo> dataCheckVos = tpmDistribClosePolicyService.findConditionAll();
        for (Map.Entry<Integer, DistribClosePolicyImportVo> map : data.entrySet()) {
            List<String> errorMsgList = Lists.newArrayList();
            Integer k = map.getKey();
            DistribClosePolicyImportVo v = map.getValue();

                Integer index = k + 2;
                String businessFormatCode = v.getBusinessFormatCode();
//            Validate.notBlank(businessFormatCode, "[行%s]业态不能为空", index);
                if (StringUtils.isEmpty(businessFormatCode)) {
                    errorMsgList.add("业态不能为空");
                }
                String channel = v.getChannel();
                if (StringUtils.isEmpty(businessFormatCode)) {
                    errorMsgList.add("渠道不能为空");
                }
                String businessUnitCode = v.getBusinessUnitCode();
                if (StringUtils.isEmpty(businessUnitCode)){
                    errorMsgList.add("业务单元不能为空");
                }
//            Validate.notBlank(businessUnitCode, "[行%s]业务单元不能为空", index);
                String platformName = v.getPlatformName();
                if (StringUtils.isEmpty(platformName)) {
                    errorMsgList.add("平台不能为空");
                }
//            Validate.notBlank(platformName, "[行%s]平台不能为空", index);
                String salesInstitutionCode = v.getSalesInstitutionCode();
                if (StringUtils.isEmpty(salesInstitutionCode)) {
                    errorMsgList.add("销售机构编码不能为空");
                }
//            Validate.notBlank(salesInstitutionCode, "[行%s]销售机构编码不能为空", index);
                String saleDepartmentCode = v.getSaleDepartmentCode();
/*                if (StringUtils.isEmpty(saleDepartmentCode)) {
                    errorMsgList.add("销售部门编码不能为空");
                }*/
//            Validate.notBlank(saleDepartmentCode, "[行%s]销售部门编码不能为空", index);
                String productCode = v.getProductCode();
                if (StringUtils.isEmpty(productCode)) {
                    errorMsgList.add("产品编码不能为空");
                }
//            Validate.notBlank(productCode, "[行%s]产品编码不能为空", index);
                /*String estoreCustomerLevel = v.getEstoreCustomerLevel();
                if (StringUtils.isEmpty(estoreCustomerLevel)) {
                    errorMsgList.add("电商客户等级不能为空");
                }*/
                if (CollectionUtils.isNotEmpty(errorMsgList)) {
                    errorMap.put(k,String.join(",",errorMsgList));
                    continue;
                }
//            Validate.notBlank(estoreCustomerLevel, "[行%s]电商客户等级不能为空", index);
                if (!formatMap.containsKey(businessFormatCode)) {
                    errorMsgList.add("业态未能识别");
                }
//            Validate.isTrue(formatMap.containsKey(businessFormatCode), "[行%s]业态未能识别", index);
                if (!unitMap.containsKey(businessUnitCode)) {
                    errorMsgList.add("业务单元未能识别");
                }
//            Validate.isTrue(unitMap.containsKey(businessUnitCode), "[行%s]业务单元未能识别", index);
//                if (!DistribClosePolicyConstant.PLATFORM_NAME.equals(platformName)) {
//                    errorMsgList.add("平台错误-[线上分销]");
//                }
//            Validate.isTrue(, "[行%s]平台错误-[线上分销]", index);
                List<SalesOrgVo> salesInstitutionVos = salesInstitutionMap.get(salesInstitutionCode);
                if (CollectionUtils.isEmpty(salesInstitutionVos)) {
                    errorMsgList.add("销售机构编码未能匹配到");
                }
//            Validate.isTrue(), "行号：" + index + ",销售机构编码未能匹配到");
                List<SalesOrgVo> saleDepartmentVos = new ArrayList<>();

                if (StringUtils.isNotEmpty(saleDepartmentCode)) {
                    saleDepartmentVos = saleDepartmentMap.get(saleDepartmentCode);
                    if (CollectionUtils.isEmpty(saleDepartmentVos)) {
                        errorMsgList.add("销售部门编码未能匹配到");
                    }
                }
//            Validate.isTrue(), "行号：" + index + ",销售部门编码未能匹配到");
                String startDate = v.getStartDate();
                if (StringUtils.isEmpty(startDate)){
                    errorMsgList.add("开始日期不能为空");
                }
//            Validate.notBlank(startDate, "[行%s]开始日期不能为空", index);
                if (DateUtil.isValidDate(startDate)) {
                    if (startDate.length() != 10) {
                        errorMsgList.add("开始日期格式错误");
                    }
                }
//            Validate.isTrue(, "[行" + index + "]开始日期格式错误,例：2023-01-01");
                DateUtil.date_yyyy_MM_dd.setLenient(false);
                try {
                    DateUtil.date_yyyy_MM_dd.parse(startDate);
                } catch (Exception e) {
                    //throw new IllegalArgumentException("[行" + index + "]开始日期格式错误【yyyy-MM-dd】");
                    errorMsgList.add("开始日期格式错误");
                }
                String endDate = v.getEndDate();
                if (StringUtils.isEmpty(endDate)){
                    errorMsgList.add("结束日期不能为空");
                }
//            Validate.notBlank(endDate, "[行%s]结束日期不能为空", index);
                if (endDate.length() != 10) {
                    errorMsgList.add("结束日期格式错误");
                }
//            Validate.isTrue(, "[行" + index + "]结束日期格式错误,例：2023-02-02");
                try {
                    DateUtil.date_yyyy_MM_dd.parse(endDate);
                } catch (Exception e) {
                    //throw new IllegalArgumentException("[行" + index + "]结束日期格式错误【yyyy-MM-dd】");
                    errorMsgList.add("结束日期格式错误");
                }
                if (endDate.compareTo(startDate) < 0) {
                    errorMsgList.add("结束日期必须大于开始日期");
                }
                //Validate.isTrue(, "[行%s]结束日期必须大于开始日期", index);
                List<ProductVo> byCodes = new ArrayList<>();
                if (StringUtils.isNotEmpty(productCode)) {
                    byCodes = productMap.get(productCode);
                    if (CollectionUtils.isEmpty(byCodes) || byCodes.size() <= 0) {
                        errorMsgList.add("产品编码未能匹配到");
                    }
                }
                //Validate.isTrue(, "行号：" + index + ",产品编码未能匹配到");
                TpmDistribClosePolicyDto policyEntity = nebulaToolkitService.copyObjectByWhiteList(v, TpmDistribClosePolicyDto.class, LinkedHashSet.class, ArrayList.class);
                policyEntity.setBusinessFormatCode(formatMap.get(businessFormatCode));
                if (StringUtils.isNotEmpty(channel)) {
                    List<CustomerChannelVo> customerChannelVos = customerChannelVoService.findByName(channel);
                    if (CollectionUtils.isEmpty(customerChannelVos) && !Objects.nonNull(customerChannelVos.get(0))) {
                        errorMsgList.add("渠道未能匹配到");
                    }
                    //Validate.isTrue(, "行号：" + index + ",渠道" + channel + "未能匹配到");
                    policyEntity.setChannelCode(customerChannelVos.get(0).getCustomerChannelCode());
                }
                if (StringUtils.isNotEmpty(policyEntity.getSalesInstitutionCode())) {
                    SalesOrgVo salesOrgVo = new SalesOrgVo();
                    if (CollectionUtils.isNotEmpty(salesInstitutionVos)) {
                    salesOrgVo = salesInstitutionVos.stream().filter(e -> StringUtils.isNotEmpty(policyEntity.getChannelCode())&&policyEntity.getChannelCode().equals(e.getChannelCode()) && StringUtils.isNotEmpty(policyEntity.getBusinessFormatCode()) && policyEntity.getBusinessFormatCode().equals(e.getBusinessFormatCode()))
                            .findFirst().orElse(null);
                    }
                    if (ObjectUtils.isEmpty(salesOrgVo)){
                        errorMsgList.add("第["+ index +"]行销售机构编码" + policyEntity.getSalesInstitutionCode() + "错误，请检查！");
                    }else  {
                        policyEntity.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                        policyEntity.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                        policyEntity.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                        //渠道编码
                        if (StringUtils.isNotBlank(policyEntity.getSalesInstitutionCode()) && policyEntity.getSalesInstitutionCode().length() >= 2) {
                            policyEntity.setChannelCode(policyEntity.getSalesInstitutionCode().substring(0,2));
                        }
                        if (StringUtils.isBlank(policyEntity.getChannelCode())) {
                            errorMsgList.add("第["+ index +"]行销售机构编码," + policyEntity.getSalesInstitutionCode() +",未找到对应渠道编码");
                        }
                    }
//                    Validate.isTrue(salesOrgVo != null, "[行%s]销售组织编码" + policyEntity.getSalesInstitutionCode() + "错误，请检查！", index);
                }
                if (StringUtils.isNotEmpty(policyEntity.getSaleDepartmentCode())) {
                    SalesOrgVo salesOrgVo = new SalesOrgVo();
                    if (CollectionUtils.isNotEmpty(saleDepartmentVos)) {
                        salesOrgVo = saleDepartmentVos.stream().filter(e -> policyEntity.getChannelCode().equals(e.getChannelCode()) && policyEntity.getBusinessFormatCode().equals(e.getBusinessFormatCode()))
                                .findFirst().orElse(null);
                    }
                    if (ObjectUtils.isEmpty(salesOrgVo)){
                        errorMsgList.add("第["+ index +"]销售部门编码" + policyEntity.getSaleDepartmentCode() + "错误，请检查！");
                    }
//                    Validate.isTrue(salesOrgVo != null, "[行%s]销售部门编码" + policyEntity.getSaleDepartmentCode() + "错误，请检查！", index);
                    policyEntity.setSaleDepartmentCode(salesOrgVo.getSalesOrgCode());
                    policyEntity.setSaleDepartmentErpCode(salesOrgVo.getErpCode());
                    policyEntity.setSaleDepartmentName(salesOrgVo.getSalesOrgName());
                }
                if (StringUtils.isNotEmpty(policyEntity.getProductName())) {
                    if (CollectionUtils.isNotEmpty(byCodes)) {
                        ProductVo productVo = byCodes.get(0);
                        if (ObjectUtils.isNotEmpty(productVo)) {
                            policyEntity.setProductName(productVo.getProductName());
                        }
                    }
                }
                String salesGroupCode = v.getSalesGroupCode();
                if (StringUtils.isNotEmpty(salesGroupCode)){
                    List<SalesOrgVo> bySalesOrgCodes = salesGroupMap.get(salesGroupCode);
                    if (CollectionUtils.isEmpty(bySalesOrgCodes)) {
                        errorMsgList.add("销售组织编码未能匹配到");
                    }
                    SalesOrgVo salesOrgVo = bySalesOrgCodes.stream().filter(e -> policyEntity.getChannelCode().equals(e.getChannelCode()) && policyEntity.getBusinessFormatCode().equals(e.getBusinessFormatCode()))
                            .findFirst().orElse(null);
                    if (salesOrgVo == null) {
                        errorMsgList.add("销售组织编码未能匹配到");
                    }else {
                        policyEntity.setSalesGroupCode(salesOrgVo.getSalesOrgCode());
                        policyEntity.setSalesGroupErpCode(salesOrgVo.getErpCode());
                        policyEntity.setSalesGroupName(salesOrgVo.getSalesOrgName());
                    }
                }
                policyEntity.setBusinessUnitCode(unitMap.get(businessUnitCode));
                try {
                    CustomerVo customerVo = this.duplicateCheck(policyEntities, policyEntity, index,dataCheckVos,customerVoMap);
                    policyEntity.setCustomerCode(customerVo.getCustomerCode());
                    policyEntity.setCustomerErpCode(customerVo.getErpCode());
                    policyEntity.setCustomerName(customerVo.getCustomerName());
                }catch (Exception e){
                    errorMsgList.add(e.getMessage());
                }
                policyEntities.add(policyEntity);
                log.info("日志关闭2");
            if (!CollectionUtils.isEmpty(errorMsgList)){
                errorMap.put(map.getKey(),String.join(",",errorMsgList));
            }
        }
        return policyEntities;
    }

    /**
     * 查询主数据信息
     *
     * @param values
     * @param customerVoMap
     * @param salesInstitutionMap
     * @param saleDepartmentMap
     * @param salesGroupMap
     */
    private void queryMasterData(Collection<DistribClosePolicyImportVo> values, Map<String, List<CustomerVo>> customerVoMap, Map<String,
            List<SalesOrgVo>> salesInstitutionMap, Map<String, List<SalesOrgVo>> saleDepartmentMap, Map<String, List<SalesOrgVo>> salesGroupMap,Map<String, List<ProductVo>> productMap) {
        List<String> salesInstitutionCodes = values.stream().map(DistribClosePolicyImportVo::getSalesInstitutionCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<String> saleDepartmentCodes = values.stream().map(DistribClosePolicyImportVo::getSaleDepartmentCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<String> salesGroupCodes = values.stream().map(DistribClosePolicyImportVo::getSalesGroupCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<String> customerCodes = values.stream().map(DistribClosePolicyImportVo::getCustomerCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<String> productCodes = values.stream().map(DistribClosePolicyImportVo::getProductCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<CustomerVo> baseByCustomerCodes = customerVoService.findByCustomerMdgCodes(customerCodes);
        if (CollectionUtils.isNotEmpty(baseByCustomerCodes)) {
            Map<String, List<CustomerVo>> map = baseByCustomerCodes.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
            customerVoMap.putAll(map);
        }
        List<SalesOrgVo> salesInstitutions = salesOrgVoService.findByErpCodeList(salesInstitutionCodes);
        if (CollectionUtils.isNotEmpty(salesInstitutions)) {
            Map<String, List<SalesOrgVo>> map = salesInstitutions.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            salesInstitutionMap.putAll(map);
        }
        List<SalesOrgVo> saleDepartments = salesOrgVoService.findByErpCodeList(saleDepartmentCodes);
        if (CollectionUtils.isNotEmpty(saleDepartments)) {
            Map<String, List<SalesOrgVo>> map = saleDepartments.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            saleDepartmentMap.putAll(map);
        }
        List<SalesOrgVo> salesGroups = salesOrgVoService.findByErpCodeList(salesGroupCodes);
        if (CollectionUtils.isNotEmpty(salesGroups)) {
            Map<String, List<SalesOrgVo>> map = salesGroups.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            salesGroupMap.putAll(map);
        }
        List<ProductVo> byCodes = productVoService.findByCodes(productCodes);
        if (CollectionUtils.isNotEmpty(byCodes)) {
            Map<String, List<ProductVo>> map = byCodes.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
            productMap.putAll(map);
        }
    }

    /**
     * 校验数据重复
     *
     * @param importList
     */
    private CustomerVo duplicateCheck(List<TpmDistribClosePolicyDto> importList, TpmDistribClosePolicyDto d, Integer index,
                                  List<DataCheckVo> dataCheckVos,Map<String, List<CustomerVo>> customerVoMap) {
        CustomerVo customerVo1 = new CustomerVo();
        // excel表导入数据校验
        String customerName = null;
        String customerCode = d.getCustomerCode();
        if (StringUtils.isNotEmpty(customerCode)){
            List<CustomerVo> baseByCustomerCodes = customerVoMap.get(customerCode);
            Validate.isTrue(!CollectionUtils.isEmpty(baseByCustomerCodes) || baseByCustomerCodes.size() > 0, "行号：" + index + ",客户编码未能匹配到");
            CustomerVo customerVo = baseByCustomerCodes.stream().filter(e -> d.getChannelCode().equals(e.getCustomerChannelCode()) && d.getSalesInstitutionCode().equals(e.getSalesInstitutionCode()) && d.getBusinessFormatCode().equals(e.getBusinessFormatCode()))
                    .findFirst().orElse(null);
            Validate.notNull(customerVo, "[行%s]客户编码" + customerCode + "错误，请检查！", index);
            String name = d.getCustomerName();
            customerName = StringUtils.isEmpty(name) ? customerVo.getCustomerName() : name;
            customerVo1.setErpCode(customerVo.getErpCode());
            customerVo1.setCustomerCode(customerVo.getCustomerCode());
            customerVo1.setCustomerName(customerName);
        }

        int startDate = Integer.parseInt(d.getStartDate().replace("-", ""));
        int endDate = Integer.parseInt(d.getEndDate().replace("-", ""));
        for (TpmDistribClosePolicyDto entity : importList) {
            if (StringUtils.isEmpty(customerCode) && StringUtils.isEmpty(entity.getCustomerCode()) && d.getProductCode().equals(entity.getProductCode()) && StringUtils.isNotBlank(d.getEstoreCustomerLevel()) && d.getEstoreCustomerLevel().equals(entity.getEstoreCustomerLevel())
            && d.getBusinessUnitCode().equals(entity.getBusinessUnitCode()) && d.getBusinessFormatCode().equals(entity.getBusinessFormatCode()) && d.getChannel().equals(entity.getChannel())) {
                String msg = "【时间+客户+产品+电商客户等级】维度,excel表内" + index + "行存在重复数据，请检查！";
                String start = entity.getStartDate();
                String end = entity.getEndDate();
                oneCheck(startDate, endDate, msg, start, end);
            }
            if (StringUtils.isNotEmpty(customerCode) && customerCode.equals(entity.getCustomerCode()) && d.getProductCode().equals(entity.getProductCode())
                    && d.getBusinessUnitCode().equals(entity.getBusinessUnitCode()) && d.getBusinessFormatCode().equals(entity.getBusinessFormatCode()) && d.getChannel().equals(entity.getChannel())) {

                String msg = "【时间+客户+产品+电商客户等级】维度,excel表内" + index + "行存在重复数据，请检查！";
                String start = entity.getStartDate();
                String end = entity.getEndDate();
                oneCheck(startDate, endDate, msg, start, end);
            }
//            if (d.getProductCode().equals(entity.getProductCode()) && d.getEstoreCustomerLevel().equals(entity.getEstoreCustomerLevel())) {
//                String msg = "【时间+电商客户等级+产品】维度,excel表内" + index + "行存在重复数据，请检查！";
//                String start = entity.getStartDate();
//                String end = entity.getEndDate();
//                oneCheck(startDate,endDate, msg, start, end);
//            }
        }
        for (DataCheckVo entity : dataCheckVos) {
            if (StringUtils.isEmpty(customerCode) && StringUtils.isEmpty(entity.getCustomerCode()) && d.getProductCode().equals(entity.getProductCode()) && StringUtils.isNotBlank(d.getEstoreCustomerLevel()) && d.getEstoreCustomerLevel().equals(entity.getEstoreCustomerLevel())
                    && d.getBusinessUnitCode().equals(entity.getBusinessUnitCode()) && d.getBusinessFormatCode().equals(entity.getBusinessFormatCode()) && d.getChannel().equals(entity.getChannel())) {
                String msg = "【时间+客户+产品+电商客户等级】维度," + index + "行与现存数据存在重复，请检查！";
                String start = entity.getStartDate();
                String end = entity.getEndDate();
                oneCheck(startDate, endDate, msg, start, end);
            }
            if (StringUtils.isNotEmpty(customerCode) && customerCode.equals(entity.getCustomerCode()) && d.getProductCode().equals(entity.getProductCode())
                    && d.getBusinessUnitCode().equals(entity.getBusinessUnitCode()) && d.getBusinessFormatCode().equals(entity.getBusinessFormatCode()) && d.getChannel().equals(entity.getChannel())) {
                String msg = "【时间+客户+产品+电商客户等级】维度," + index + "行与现存数据存在重复，请检查！";
                String start = entity.getStartDate();
                String end = entity.getEndDate();
                oneCheck(startDate, endDate, msg, start, end);
            }
//            if (d.getProductCode().equals(entity.getProductCode()) && d.getEstoreCustomerLevel().equals(entity.getEstoreCustomerLevel())) {
//                String msg = "【时间+电商客户等级+产品】维度," + index + "行与现存数据存在重复，请检查！";
//                String start = entity.getStartDate();
//                String end = entity.getEndDate();
//                oneCheck(startDate,endDate, msg, start, end);
//            }
        }
        return customerVo1;
    }

    /**
     * 导入数据时间维度校验
     *
     */
    private void oneCheck(int startDate,int endDate, String msg, String start, String end) {
        int startI = Integer.parseInt(start.replace("-", ""));
        int endI = Integer.parseInt(end.replace("-", ""));
        Validate.isTrue(startDate < startI || startDate > endI, msg);
        Validate.isTrue(endDate < startI || endDate > endI, msg);
    }

    @Override
    public Class<DistribClosePolicyImportVo> findCrmExcelVoClass() {
        return DistribClosePolicyImportVo.class;
    }

    /**
     * 获取业务编码
     *
     * @return String
     */
    @Override
    public String getBusinessCode() {
        return "TPM_DISTRIB_CLOSE_POLICY_IMPORT";
    }

    /**
     * 获取业务名称
     *
     * @return String
     */
    @Override
    public String getBusinessName() {
        return "TPM分销结案政策导入";
    }

    /**
     * 获取数据实体
     *
     * @return String
     */
    @Override
    public String getTemplateCode() {
        return "TPM_DISTRIB_CLOSE_POLICY_IMPORT";
    }

    /**
     * 获取业务对应的模板描述
     *
     * @return String
     */
    @Override
    public String getTemplateName() {
        return "TPM-分销结案政策导入模板";
    }
}
