package com.biz.crm.tpm.business.distrib.close.data.policy.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.distrib.close.data.policy.mapper.PlatformLogisticsExportMapper;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.PlatformLogisticsExportDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsExportVo;
import liquibase.util.Validate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: zhouyang
 * @Date: 2023/7/21
 */
@Slf4j
@Component
public class PlatformLogisticsExportProcess implements ExportProcess<PlatformLogisticsExportVo> {

    @Autowired
    private PlatformLogisticsExportMapper mapper;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        PlatformLogisticsExportDto dto = this.getDto(params);
        Integer total = mapper.getExportTotal(dto);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    private PlatformLogisticsExportDto getDto(Map<String, Object> params) {
        PlatformLogisticsExportDto dto =new PlatformLogisticsExportDto();
        final Object sapProductCode = params.get("sapProductCode");
        if (Objects.nonNull(sapProductCode)){
            dto.setSapProductCode(sapProductCode.toString());
        }
        final Object orderCode = params.get("orderCode");
        if (Objects.nonNull(orderCode)){
            dto.setOrderCode(orderCode.toString());
        }
        final Object orderStatus = params.get("orderStatus");
        if (Objects.nonNull(orderStatus)){
            dto.setOrderStatus(orderStatus.toString());
        }
        final Object deliveryProvince = params.get("deliveryProvince");
        if (Objects.nonNull(deliveryProvince)){
            dto.setDeliveryProvince(deliveryProvince.toString());
        }
        final Object deliveryCity = params.get("deliveryCity");
        if (Objects.nonNull(deliveryCity)){
            dto.setDeliveryCity(deliveryCity.toString());
        }
        final Object deliveryDistrict = params.get("deliveryDistrict");
        if (Objects.nonNull(deliveryDistrict)){
            dto.setDeliveryDistrict(deliveryDistrict.toString());
        }
        final Object deliveryCode = params.get("deliveryCode");
        if (Objects.nonNull(deliveryCode)){
            dto.setDeliveryCode(deliveryCode.toString());
        }
        final Object customerName = params.get("customerName");
        if (Objects.nonNull(customerName)){
            dto.setCustomerName(customerName.toString());
        }
        final Object yearAndMonth = params.get("yearAndMonth");
        if (Objects.nonNull(yearAndMonth)){
            dto.setYearAndMonth(yearAndMonth.toString());
        }
        return dto;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        PlatformLogisticsExportDto dto = this.getDto(params);
        dto.setOffset(this.getPageSize() * vo.getPageNo());
        dto.setLimit(vo.getPageSize());
        List<PlatformLogisticsExportVo> data = mapper.findData(dto);
        return JSON.parseArray(JSON.toJSONString(data));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_PLATFORM_LOGISTICS_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM平台物流底表导出";
    }

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }
}
