package com.biz.crm.tpm.business.distrib.close.data.policy.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 平台物流底表数据视图
 * @Author: zhouyang
 * @Date: 2023/7/20
 */
@Component
@Slf4j
public class PlatformLogisticsRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_platform_logistics_data_view";
    }

    @Override
    public String desc() {
        return "TPM-平台物流底表";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_platform_logistics t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
