package com.biz.crm.tpm.business.distrib.close.data.policy.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author hd
 * @create 2023-02-13 15:01:38
 * @description：分销结案政策
 */
@Component
@Slf4j
public class TpmDistribClosePolicyRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_distrib_close_policy_data_view";
    }

    @Override
    public String desc() {
        return "TPM-分销结案政策";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_distrib_close_policy t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
