package com.biz.crm.tpm.business.distrib.close.data.policy.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.PlatformLogistics;
import com.biz.crm.tpm.business.distrib.close.data.policy.mapper.PlatformLogisticsMapper;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.PlatformLogisticsDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 平台物流底表接口实现
 *
 * @author zhouyang
 * @date 2023-07-20 11:54:47
 */
@Slf4j
@Component
public class PlatformLogisticsRepository extends ServiceImpl<PlatformLogisticsMapper, PlatformLogistics> {

    @Autowired
    private PlatformLogisticsMapper mapper;

    /**
     * 分页
     * @param pageable 分页参数
     * @param dto dto
     * @return page
     */
    public Page<PlatformLogisticsVo> findByConditions(Pageable pageable, PlatformLogisticsDto dto) {
        return mapper.findByConditions(new Page<>(pageable.getPageNumber(), pageable.getPageSize()), dto);
    }

    /**
     * 查询详情
     * @param id id
     * @return entity
     */
    public PlatformLogistics findDetailsById(String id){
        return StringUtils.hasText(id)
                ? this.getById(id)
                : null;
    }

    public List<PlatformLogistics> findByItemKeys(List<String> itemKeys) {
        return this.lambdaQuery()
                .in(PlatformLogistics::getItemKey,itemKeys)
                .eq(PlatformLogistics::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public List<PlatformLogistics> findByYearMonth(String yearMonth) {
        return this.lambdaQuery()
                .in(PlatformLogistics::getYearAndMonth, yearMonth)
                .eq(PlatformLogistics::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }
}
