package com.biz.crm.tpm.business.distrib.close.data.policy.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.TpmDistribClosePolicyEntity;
import com.biz.crm.tpm.business.distrib.close.data.policy.mapper.TpmDistribClosePolicyMapper;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DataCheckVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;


/**
 * 分销结案政策(TpmDistribClosePolicy)表数据库访问层
 *
 * @author hd
 * @create 2023-02-13 15:01:38
 */
@Component
public class TpmDistribClosePolicyRepository extends ServiceImpl<TpmDistribClosePolicyMapper, TpmDistribClosePolicyEntity> {
    @Autowired(required = false)
    private TpmDistribClosePolicyMapper tpmDistribClosePolicyMapper;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    public Page<TpmDistribClosePolicyVo> findByConditions(Pageable pageable, TpmDistribClosePolicyDto dto) {
        Page<TpmDistribClosePolicyDto> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmDistribClosePolicyVo> pageList = tpmDistribClosePolicyMapper.findByConditions(page, dto);
        return pageList;
    }

    /**
     * 查询数据的校验条件
     *
     * @return
     */
    public List<DataCheckVo> findConditionAll() {
        return tpmDistribClosePolicyMapper.findConditionAll();
    }

    public List<TpmDistribClosePolicyVo> findDistribClosePolicy(TpmDistribClosePolicyDto distribClosePolicy){
        return this.tpmDistribClosePolicyMapper.findDistribClosePolicy(distribClosePolicy);
    }

    public List<TpmDistribClosePolicyVo> findByCondition(TpmDistribClosePolicyDto distribClosePolicy, String yearMonthLy){
        return this.tpmDistribClosePolicyMapper.findByCondition(distribClosePolicy, yearMonthLy);
    }

    public List<TpmDistribClosePolicyVo> findPolicyForDistributionCustomerAuditData(TpmDistribClosePolicyDto distribClosePolicyDto) {
        return this.baseMapper.findPolicyForDistributionCustomerAuditData(distribClosePolicyDto);
    }

    /**
     * 批量新增
     *
     * @param sapEntities
     */
    public void saveBatchData(Collection<TpmDistribClosePolicyEntity> sapEntities) {
        tpmDistribClosePolicyMapper.saveBatchData(sapEntities);
    }

    /**
     * 获取投放费用
     *
     * @param closePolicyDtos
     * @return
     */
    public List<TpmDistribClosePolicyVo> findCostOfPlacement(Collection<TpmDistribClosePolicyDto> closePolicyDtos) {
        return tpmDistribClosePolicyMapper.findCostOfPlacement(closePolicyDtos, TenantUtils.getTenantCode());
    }
}
