package com.biz.crm.tpm.business.distrib.close.data.policy.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.PlatformLogisticsDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 平台物流底表接口
 *
 * @author zhouyang
 * @date 2023-07-20 11:54:47
 */
public interface PlatformLogisticsService{

    /**
     * 分页查询
     * @param pageable 分页参数
     * @param dto 入参
     * @return page 结果
    */
    Page<PlatformLogisticsVo> findByConditions(Pageable pageable, PlatformLogisticsDto dto);

    /**
     * 查询
     * @param id id
     * @return PlatformLogisticsDto PlatformLogisticsDto
     */
    PlatformLogisticsVo findDetailsById(String id);

    /**
     * 删除数据（物理删除）
     * @param ids
     */
    void delete(List<String> ids);

    /**
     * 批量创建
     * @param list
     */
    void createBatch(List<PlatformLogisticsVo> list);
}

