package com.biz.crm.tpm.business.distrib.close.data.policy.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.PlatformLogistics;
import com.biz.crm.tpm.business.distrib.close.data.policy.repository.PlatformLogisticsRepository;
import com.biz.crm.tpm.business.distrib.close.data.policy.service.PlatformLogisticsService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.constant.PlatFormLogisticsConstant;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.PlatformLogisticsDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;

/**
 * 平台物流底表接口实现
 *
 * @author zhouyang
 * @date 2023-07-20 11:54:47
 */
@Slf4j
@Service
public class PlatformLogisticsServiceImpl implements PlatformLogisticsService {

    @Autowired
    private GenerateCodeService generateCodeService;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private PlatformLogisticsRepository repository;

    @Override
    public Page<PlatformLogisticsVo> findByConditions(Pageable pageable, PlatformLogisticsDto dto) {
        return repository.findByConditions(pageable != null?pageable:PageRequest.of(0, 50), dto);
    }
    
    @Override
    public PlatformLogisticsVo findDetailsById(String id){
        Validate.notEmpty(id,"参数错误");
        PlatformLogistics entity = this.repository.findDetailsById(id);
        Validate.notNull(entity,"未找到信息");
        return this.nebulaToolkitService.copyObjectByBlankList(entity,PlatformLogisticsVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public void delete(List<String> ids) {
        Validate.notEmpty(ids,"缺少删除数据id，请选择要删除的数据！");
        this.repository.removeByIds(ids);
    }

    /**
     * 批量创建
     * @param list
     */
    @Override
    public void createBatch(List<PlatformLogisticsVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<PlatformLogistics> entityList = (List<PlatformLogistics>) this.nebulaToolkitService.copyCollectionByBlankList(list,PlatformLogisticsVo.class,PlatformLogistics.class,HashSet.class,ArrayList.class);
        entityList.forEach(e -> {
            //String itemKey = generateCodeService.generateCode(PlatFormLogisticsConstant.PLATFORM_LOGISTICS_ITEM_KEY, 1, 6, 2, TimeUnit.DAYS).get(0);
            StringBuffer itemKey = new StringBuffer();
            itemKey.append(e.getYearAndMonth());
            itemKey.append(e.getSapProductCode());
            itemKey.append(e.getCustomerCode());
            e.setItemKey(itemKey.toString());
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        this.repository.saveBatch(entityList);
    }

}
