package com.biz.crm.tpm.business.distrib.close.data.policy.service.internal;

import com.biz.crm.tpm.business.distrib.close.data.policy.entity.PlatformLogistics;
import com.biz.crm.tpm.business.distrib.close.data.policy.repository.PlatformLogisticsRepository;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.PlatformLogisticsVoService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @Author: zhouyang
 * @Date: 2023/7/21
 */
@Service
public class PlatformLogisticsVoServiceImpl implements PlatformLogisticsVoService {

    @Autowired(required = false)
    private PlatformLogisticsRepository platformLogisticsRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public List<PlatformLogisticsVo> findByItemKeys(List<String> itemKeys) {
        if (CollectionUtils.isEmpty(itemKeys)) {
            return Lists.newArrayList();
        }
        List<PlatformLogistics> list = this.platformLogisticsRepository.findByItemKeys(itemKeys);
        if (CollectionUtils.isNotEmpty(list)) {
            return (List<PlatformLogisticsVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list,PlatformLogistics.class,PlatformLogisticsVo.class, HashSet.class, ArrayList.class);
        }
        return Lists.newArrayList();
    }

    /**
     * 根据年月查询
     *
     * @param yearMonth
     * @return
     */
    @Override
    public List<PlatformLogisticsVo> findByYearMonth(String yearMonth) {
        Validate.notBlank(yearMonth, "年月不能为空");
        List<PlatformLogistics> list = platformLogisticsRepository.findByYearMonth(yearMonth);
        if (CollectionUtils.isNotEmpty(list)) {
            return (List<PlatformLogisticsVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list,PlatformLogistics.class,PlatformLogisticsVo.class, HashSet.class, ArrayList.class);
        }
        return Lists.newArrayList();
    }
}
