package com.biz.crm.tpm.business.distrib.close.data.policy.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.TpmDistribClosePolicyEntity;
import com.biz.crm.tpm.business.distrib.close.data.policy.repository.TpmDistribClosePolicyRepository;
import com.biz.crm.tpm.business.distrib.close.data.policy.service.TpmDistribClosePolicyTransService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DataCheckVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 分销结案政策(TpmDistribClosePolicy)表服务实现类
 *
 * @author hd
 * @create 2023-02-13 15:01:38
 */
@Slf4j
@Service("tpmDistribClosePolicyService")
public class TpmDistribClosePolicyServiceImpl implements TpmDistribClosePolicyService {
    @Autowired(required = false)
    private TpmDistribClosePolicyTransService tpmDistribClosePolicyTransService;
    @Autowired(required = false)
    private TpmDistribClosePolicyRepository tpmDistribClosePolicyRepository;
    @Autowired(required = false)
    private LoginUserService loginUserService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    @Override
    public Page<TpmDistribClosePolicyVo> findByConditions(Pageable pageable, TpmDistribClosePolicyDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmDistribClosePolicyDto();
        }
        return tpmDistribClosePolicyRepository.findByConditions(pageable, dto);
    }

    /**
     * 删除数据
     *
     * @param ids 主键集合
     * @return 删除结果
     */
    @Override
    public void delete(List<String> ids) {
        Validate.isTrue(null != ids && ids.size() > 0, "缺少删除数据id，请选择要删除的数据！");
        List<TpmDistribClosePolicyEntity> entities = tpmDistribClosePolicyRepository.listByIds(ids);
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(entity -> {
                entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            tpmDistribClosePolicyTransService.updateBatchData(entities);
        }
    }

    /**
     * 查询数据的校验条件
     *
     * @return
     */
    @Override
    public List<DataCheckVo> findConditionAll() {
        List<DataCheckVo> dataCheckVos = tpmDistribClosePolicyRepository.findConditionAll();
        if (CollectionUtils.isEmpty(dataCheckVos)) {
            return new ArrayList<>();
        }
        return dataCheckVos;
    }

    /**
     * 批量保存数据
     *
     * @param importList
     */
    @Override
    public void saveBatchData(List<TpmDistribClosePolicyDto> importList) {
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = loginUserService.getAbstractLoginUser();
        Date date = new Date();
        importList.forEach(dto->{
            dto.setCreateAccount(loginDetails.getUsername());
            dto.setCreateName(loginDetails.getRealName());
            dto.setCreateTime(date);
            dto.setTenantCode(loginDetails.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(UUID.randomUUID().toString().replace("-", ""));
        });
        tpmDistribClosePolicyTransService.saveBatchData(nebulaToolkitService.copyCollectionByWhiteList(importList, TpmDistribClosePolicyDto.class, TpmDistribClosePolicyEntity.class, HashSet.class, ArrayList.class));
    }

    @Override
    public List<TpmDistribClosePolicyVo> findDistribClosePolicy(TpmDistribClosePolicyDto distribClosePolicy) {
        return this.tpmDistribClosePolicyRepository.findDistribClosePolicy(distribClosePolicy);

    }

    @Override
    public List<TpmDistribClosePolicyVo> findByCondition(TpmDistribClosePolicyDto distribClosePolicy, String yearMonthLy) {
        return this.tpmDistribClosePolicyRepository.findByCondition(distribClosePolicy, yearMonthLy);
    }

    @Override
    public List<TpmDistribClosePolicyVo> findPolicyForDistributionCustomerAuditData(TpmDistribClosePolicyDto distribClosePolicyDto) {
        return this.tpmDistribClosePolicyRepository.findPolicyForDistributionCustomerAuditData(distribClosePolicyDto);
    }

    @Override
    public List<TpmDistribClosePolicyVo> findCostOfPlacement(Collection<TpmDistribClosePolicyDto> closePolicyDtos) {
        if(CollectionUtils.isEmpty(closePolicyDtos)) {
            return null;
        }
        return tpmDistribClosePolicyRepository.findCostOfPlacement(closePolicyDtos);
    }
}
