package com.biz.crm.tpm.business.distrib.close.data.policy.service.internal;

import com.biz.crm.tpm.business.distrib.close.data.policy.entity.TpmDistribClosePolicyEntity;
import com.biz.crm.tpm.business.distrib.close.data.policy.repository.TpmDistribClosePolicyRepository;
import com.biz.crm.tpm.business.distrib.close.data.policy.service.TpmDistribClosePolicyTransService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;

@Service("tpmDistribClosePolicyTransService")
public class TpmDistribClosePolicyTransServiceImpl implements TpmDistribClosePolicyTransService {

    @Autowired(required = false)
    private TpmDistribClosePolicyRepository tpmDistribClosePolicyRepository;

    /**
     * 批量保存分销结案政策
     *
     * @param sapEntities
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveBatchData(Collection<TpmDistribClosePolicyEntity> sapEntities) {
        tpmDistribClosePolicyRepository.saveBatch(sapEntities);
    }

    /**
     * 批量更新数据
     *
     * @param entities
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateBatchData(Collection<TpmDistribClosePolicyEntity> entities) {
        tpmDistribClosePolicyRepository.updateBatchById(entities);
    }
}
