/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distrib.close.data.policy.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DataCheckVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DistribClosePolicyImportVo;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.service.TpmSalesVolumeChannelService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistribClosePolicyImportProcess
implements ImportProcess<DistribClosePolicyImportVo> {
    private static final Logger log = LoggerFactory.getLogger(DistribClosePolicyImportProcess.class);
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private TpmSalesVolumeChannelService tpmSalesVolumeChannelService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmDistribClosePolicyService tpmDistribClosePolicyService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;

    public Integer getBatchCount() {
        return 1000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, DistribClosePolicyImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap errorMap = Maps.newHashMap();
        try {
            Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((data.values().size() <= 1000 ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u6761", (Object[])new Object[0]);
            List<TpmDistribClosePolicyDto> importList = this.validate(data, errorMap);
            if (!errorMap.isEmpty()) {
                return errorMap;
            }
            this.tpmDistribClosePolicyService.saveBatchData(importList);
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u5bfc\u5165\u5931\u8d25");
            throw e;
        }
        return errorMap;
    }

    private List<TpmDistribClosePolicyDto> validate(LinkedHashMap<Integer, DistribClosePolicyImportVo> data, Map<Integer, String> errorMap) {
        log.info("\u65e5\u5fd7\u542f\u75281");
        Map unitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)unitMap), (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5355\u5143\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Collection<DistribClosePolicyImportVo> values = data.values();
        HashMap<String, List<CustomerVo>> customerVoMap = new HashMap<String, List<CustomerVo>>();
        HashMap<String, List<SalesOrgVo>> salesInstitutionMap = new HashMap<String, List<SalesOrgVo>>();
        HashMap<String, List<SalesOrgVo>> saleDepartmentMap = new HashMap<String, List<SalesOrgVo>>();
        HashMap<String, List<SalesOrgVo>> salesGroupMap = new HashMap<String, List<SalesOrgVo>>();
        HashMap<String, List<ProductVo>> productMap = new HashMap<String, List<ProductVo>>();
        this.queryMasterData(values, customerVoMap, salesInstitutionMap, saleDepartmentMap, salesGroupMap, productMap);
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)formatMap), (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        ArrayList<TpmDistribClosePolicyDto> policyEntities = new ArrayList<TpmDistribClosePolicyDto>();
        List dataCheckVos = this.tpmDistribClosePolicyService.findConditionAll();
        for (Map.Entry<Integer, DistribClosePolicyImportVo> map : data.entrySet()) {
            String salesGroupCode;
            ProductVo productVo;
            SalesOrgVo salesOrgVo;
            String startDate;
            List salesInstitutionVos;
            String salesInstitutionCode;
            String platformName;
            String businessUnitCode;
            ArrayList errorMsgList = Lists.newArrayList();
            Integer k = map.getKey();
            DistribClosePolicyImportVo v = map.getValue();
            Integer index = k + 2;
            String businessFormatCode = v.getBusinessFormatCode();
            if (StringUtils.isEmpty((CharSequence)businessFormatCode)) {
                errorMsgList.add("\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String channel = v.getChannel();
            if (StringUtils.isEmpty((CharSequence)businessFormatCode)) {
                errorMsgList.add("\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)(businessUnitCode = v.getBusinessUnitCode()))) {
                errorMsgList.add("\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)(platformName = v.getPlatformName()))) {
                errorMsgList.add("\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)(salesInstitutionCode = v.getSalesInstitutionCode()))) {
                errorMsgList.add("\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String saleDepartmentCode = v.getSaleDepartmentCode();
            String productCode = v.getProductCode();
            if (StringUtils.isEmpty((CharSequence)productCode)) {
                errorMsgList.add("\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isNotEmpty((Collection)errorMsgList)) {
                errorMap.put(k, String.join((CharSequence)",", errorMsgList));
                continue;
            }
            if (!formatMap.containsKey(businessFormatCode)) {
                errorMsgList.add("\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
            }
            if (!unitMap.containsKey(businessUnitCode)) {
                errorMsgList.add("\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b");
            }
            if (CollectionUtils.isEmpty((Collection)(salesInstitutionVos = (List)salesInstitutionMap.get(salesInstitutionCode)))) {
                errorMsgList.add("\u9500\u552e\u673a\u6784\u7f16\u7801\u672a\u80fd\u5339\u914d\u5230");
            }
            List saleDepartmentVos = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)saleDepartmentCode) && CollectionUtils.isEmpty(saleDepartmentVos = (List)saleDepartmentMap.get(saleDepartmentCode))) {
                errorMsgList.add("\u9500\u552e\u90e8\u95e8\u7f16\u7801\u672a\u80fd\u5339\u914d\u5230");
            }
            if (StringUtils.isEmpty((CharSequence)(startDate = v.getStartDate()))) {
                errorMsgList.add("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (DateUtil.isValidDate((String)startDate) && startDate.length() != 10) {
                errorMsgList.add("\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            }
            DateUtil.date_yyyy_MM_dd.setLenient(false);
            try {
                DateUtil.date_yyyy_MM_dd.parse(startDate);
            }
            catch (Exception e2) {
                errorMsgList.add("\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            }
            String endDate = v.getEndDate();
            if (StringUtils.isEmpty((CharSequence)endDate)) {
                errorMsgList.add("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (endDate.length() != 10) {
                errorMsgList.add("\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            }
            try {
                DateUtil.date_yyyy_MM_dd.parse(endDate);
            }
            catch (Exception e3) {
                errorMsgList.add("\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            }
            if (endDate.compareTo(startDate) < 0) {
                errorMsgList.add("\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f");
            }
            List byCodes = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)productCode) && (CollectionUtils.isEmpty(byCodes = (List)productMap.get(productCode)) || byCodes.size() <= 0)) {
                errorMsgList.add("\u4ea7\u54c1\u7f16\u7801\u672a\u80fd\u5339\u914d\u5230");
            }
            TpmDistribClosePolicyDto policyEntity = (TpmDistribClosePolicyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)v, TpmDistribClosePolicyDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            policyEntity.setBusinessFormatCode((String)formatMap.get(businessFormatCode));
            if (StringUtils.isNotEmpty((CharSequence)channel)) {
                List customerChannelVos = this.customerChannelVoService.findByName(channel);
                if (CollectionUtils.isEmpty((Collection)customerChannelVos) && !Objects.nonNull(customerChannelVos.get(0))) {
                    errorMsgList.add("\u6e20\u9053\u672a\u80fd\u5339\u914d\u5230");
                }
                policyEntity.setChannelCode(((CustomerChannelVo)customerChannelVos.get(0)).getCustomerChannelCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)policyEntity.getSalesInstitutionCode())) {
                salesOrgVo = new SalesOrgVo();
                if (CollectionUtils.isNotEmpty((Collection)salesInstitutionVos)) {
                    salesOrgVo = salesInstitutionVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)policyEntity.getChannelCode()) && policyEntity.getChannelCode().equals(e.getChannelCode()) && StringUtils.isNotEmpty((CharSequence)policyEntity.getBusinessFormatCode()) && policyEntity.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                }
                if (ObjectUtils.isEmpty((Object)salesOrgVo)) {
                    errorMsgList.add("\u7b2c[" + index + "]\u884c\u9500\u552e\u673a\u6784\u7f16\u7801" + policyEntity.getSalesInstitutionCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    policyEntity.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                    policyEntity.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                    policyEntity.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                    if (StringUtils.isNotBlank((CharSequence)policyEntity.getSalesInstitutionCode()) && policyEntity.getSalesInstitutionCode().length() >= 2) {
                        policyEntity.setChannelCode(policyEntity.getSalesInstitutionCode().substring(0, 2));
                    }
                    if (StringUtils.isBlank((CharSequence)policyEntity.getChannelCode())) {
                        errorMsgList.add("\u7b2c[" + index + "]\u884c\u9500\u552e\u673a\u6784\u7f16\u7801," + policyEntity.getSalesInstitutionCode() + ",\u672a\u627e\u5230\u5bf9\u5e94\u6e20\u9053\u7f16\u7801");
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)policyEntity.getSaleDepartmentCode())) {
                salesOrgVo = new SalesOrgVo();
                if (CollectionUtils.isNotEmpty(saleDepartmentVos)) {
                    salesOrgVo = saleDepartmentVos.stream().filter(e -> policyEntity.getChannelCode().equals(e.getChannelCode()) && policyEntity.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                }
                if (ObjectUtils.isEmpty((Object)salesOrgVo)) {
                    errorMsgList.add("\u7b2c[" + index + "]\u9500\u552e\u90e8\u95e8\u7f16\u7801" + policyEntity.getSaleDepartmentCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                policyEntity.setSaleDepartmentCode(salesOrgVo.getSalesOrgCode());
                policyEntity.setSaleDepartmentErpCode(salesOrgVo.getErpCode());
                policyEntity.setSaleDepartmentName(salesOrgVo.getSalesOrgName());
            }
            if (StringUtils.isNotEmpty((CharSequence)policyEntity.getProductName()) && CollectionUtils.isNotEmpty(byCodes) && ObjectUtils.isNotEmpty((Object)(productVo = (ProductVo)byCodes.get(0)))) {
                policyEntity.setProductName(productVo.getProductName());
            }
            if (StringUtils.isNotEmpty((CharSequence)(salesGroupCode = v.getSalesGroupCode()))) {
                SalesOrgVo salesOrgVo2;
                List bySalesOrgCodes = (List)salesGroupMap.get(salesGroupCode);
                if (CollectionUtils.isEmpty((Collection)bySalesOrgCodes)) {
                    errorMsgList.add("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u672a\u80fd\u5339\u914d\u5230");
                }
                if ((salesOrgVo2 = (SalesOrgVo)bySalesOrgCodes.stream().filter(e -> policyEntity.getChannelCode().equals(e.getChannelCode()) && policyEntity.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null)) == null) {
                    errorMsgList.add("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u672a\u80fd\u5339\u914d\u5230");
                } else {
                    policyEntity.setSalesGroupCode(salesOrgVo2.getSalesOrgCode());
                    policyEntity.setSalesGroupErpCode(salesOrgVo2.getErpCode());
                    policyEntity.setSalesGroupName(salesOrgVo2.getSalesOrgName());
                }
            }
            policyEntity.setBusinessUnitCode((String)unitMap.get(businessUnitCode));
            try {
                CustomerVo customerVo = this.duplicateCheck(policyEntities, policyEntity, index, dataCheckVos, customerVoMap);
                policyEntity.setCustomerCode(customerVo.getCustomerCode());
                policyEntity.setCustomerErpCode(customerVo.getErpCode());
                policyEntity.setCustomerName(customerVo.getCustomerName());
            }
            catch (Exception e4) {
                errorMsgList.add(e4.getMessage());
            }
            policyEntities.add(policyEntity);
            log.info("\u65e5\u5fd7\u5173\u95ed2");
            if (CollectionUtils.isEmpty((Collection)errorMsgList)) continue;
            errorMap.put(map.getKey(), String.join((CharSequence)",", errorMsgList));
        }
        return policyEntities;
    }

    private void queryMasterData(Collection<DistribClosePolicyImportVo> values, Map<String, List<CustomerVo>> customerVoMap, Map<String, List<SalesOrgVo>> salesInstitutionMap, Map<String, List<SalesOrgVo>> saleDepartmentMap, Map<String, List<SalesOrgVo>> salesGroupMap, Map<String, List<ProductVo>> productMap) {
        List byCodes;
        List salesGroups;
        List saleDepartments;
        List salesInstitutions;
        List salesInstitutionCodes = values.stream().map(DistribClosePolicyImportVo::getSalesInstitutionCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List saleDepartmentCodes = values.stream().map(DistribClosePolicyImportVo::getSaleDepartmentCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List salesGroupCodes = values.stream().map(DistribClosePolicyImportVo::getSalesGroupCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List customerCodes = values.stream().map(DistribClosePolicyImportVo::getCustomerCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List productCodes = values.stream().map(DistribClosePolicyImportVo::getProductCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List baseByCustomerCodes = this.customerVoService.findByCustomerMdgCodes(customerCodes);
        if (CollectionUtils.isNotEmpty((Collection)baseByCustomerCodes)) {
            Map<String, List<CustomerVo>> map = baseByCustomerCodes.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
            customerVoMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(salesInstitutions = this.salesOrgVoService.findByErpCodeList(salesInstitutionCodes)))) {
            Map<String, List<SalesOrgVo>> map = salesInstitutions.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            salesInstitutionMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(saleDepartments = this.salesOrgVoService.findByErpCodeList(saleDepartmentCodes)))) {
            Map<String, List<SalesOrgVo>> map = saleDepartments.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            saleDepartmentMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(salesGroups = this.salesOrgVoService.findByErpCodeList(salesGroupCodes)))) {
            Map<String, List<SalesOrgVo>> map = salesGroups.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            salesGroupMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(byCodes = this.productVoService.findByCodes(productCodes)))) {
            Map<String, List<ProductVo>> map = byCodes.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
            productMap.putAll(map);
        }
    }

    private CustomerVo duplicateCheck(List<TpmDistribClosePolicyDto> importList, TpmDistribClosePolicyDto d, Integer index, List<DataCheckVo> dataCheckVos, Map<String, List<CustomerVo>> customerVoMap) {
        String end;
        String start;
        String msg;
        CustomerVo customerVo1 = new CustomerVo();
        String customerName = null;
        String customerCode = d.getCustomerCode();
        if (StringUtils.isNotEmpty((CharSequence)customerCode)) {
            List<CustomerVo> baseByCustomerCodes = customerVoMap.get(customerCode);
            Validate.isTrue((!CollectionUtils.isEmpty(baseByCustomerCodes) || baseByCustomerCodes.size() > 0 ? 1 : 0) != 0, (String)("\u884c\u53f7\uff1a" + index + ",\u5ba2\u6237\u7f16\u7801\u672a\u80fd\u5339\u914d\u5230"), (Object[])new Object[0]);
            CustomerVo customerVo = baseByCustomerCodes.stream().filter(e -> d.getChannelCode().equals(e.getCustomerChannelCode()) && d.getSalesInstitutionCode().equals(e.getSalesInstitutionCode()) && d.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
            Validate.notNull((Object)customerVo, (String)("[\u884c%s]\u5ba2\u6237\u7f16\u7801" + customerCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[]{index});
            String name = d.getCustomerName();
            customerName = StringUtils.isEmpty((CharSequence)name) ? customerVo.getCustomerName() : name;
            customerVo1.setErpCode(customerVo.getErpCode());
            customerVo1.setCustomerCode(customerVo.getCustomerCode());
            customerVo1.setCustomerName(customerName);
        }
        int startDate = Integer.parseInt(d.getStartDate().replace("-", ""));
        int endDate = Integer.parseInt(d.getEndDate().replace("-", ""));
        for (TpmDistribClosePolicyDto tpmDistribClosePolicyDto : importList) {
            if (StringUtils.isEmpty((CharSequence)customerCode) && StringUtils.isEmpty((CharSequence)tpmDistribClosePolicyDto.getCustomerCode()) && d.getProductCode().equals(tpmDistribClosePolicyDto.getProductCode()) && StringUtils.isNotBlank((CharSequence)d.getEstoreCustomerLevel()) && d.getEstoreCustomerLevel().equals(tpmDistribClosePolicyDto.getEstoreCustomerLevel()) && d.getBusinessUnitCode().equals(tpmDistribClosePolicyDto.getBusinessUnitCode()) && d.getBusinessFormatCode().equals(tpmDistribClosePolicyDto.getBusinessFormatCode()) && d.getChannel().equals(tpmDistribClosePolicyDto.getChannel())) {
                msg = "\u3010\u65f6\u95f4+\u5ba2\u6237+\u4ea7\u54c1+\u7535\u5546\u5ba2\u6237\u7b49\u7ea7\u3011\u7ef4\u5ea6,excel\u8868\u5185" + index + "\u884c\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01";
                start = tpmDistribClosePolicyDto.getStartDate();
                end = tpmDistribClosePolicyDto.getEndDate();
                this.oneCheck(startDate, endDate, msg, start, end);
            }
            if (!StringUtils.isNotEmpty((CharSequence)customerCode) || !customerCode.equals(tpmDistribClosePolicyDto.getCustomerCode()) || !d.getProductCode().equals(tpmDistribClosePolicyDto.getProductCode()) || !d.getBusinessUnitCode().equals(tpmDistribClosePolicyDto.getBusinessUnitCode()) || !d.getBusinessFormatCode().equals(tpmDistribClosePolicyDto.getBusinessFormatCode()) || !d.getChannel().equals(tpmDistribClosePolicyDto.getChannel())) continue;
            msg = "\u3010\u65f6\u95f4+\u5ba2\u6237+\u4ea7\u54c1+\u7535\u5546\u5ba2\u6237\u7b49\u7ea7\u3011\u7ef4\u5ea6,excel\u8868\u5185" + index + "\u884c\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01";
            start = tpmDistribClosePolicyDto.getStartDate();
            end = tpmDistribClosePolicyDto.getEndDate();
            this.oneCheck(startDate, endDate, msg, start, end);
        }
        for (DataCheckVo dataCheckVo : dataCheckVos) {
            if (StringUtils.isEmpty((CharSequence)customerCode) && StringUtils.isEmpty((CharSequence)dataCheckVo.getCustomerCode()) && d.getProductCode().equals(dataCheckVo.getProductCode()) && StringUtils.isNotBlank((CharSequence)d.getEstoreCustomerLevel()) && d.getEstoreCustomerLevel().equals(dataCheckVo.getEstoreCustomerLevel()) && d.getBusinessUnitCode().equals(dataCheckVo.getBusinessUnitCode()) && d.getBusinessFormatCode().equals(dataCheckVo.getBusinessFormatCode()) && d.getChannel().equals(dataCheckVo.getChannel())) {
                msg = "\u3010\u65f6\u95f4+\u5ba2\u6237+\u4ea7\u54c1+\u7535\u5546\u5ba2\u6237\u7b49\u7ea7\u3011\u7ef4\u5ea6," + index + "\u884c\u4e0e\u73b0\u5b58\u6570\u636e\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01";
                start = dataCheckVo.getStartDate();
                end = dataCheckVo.getEndDate();
                this.oneCheck(startDate, endDate, msg, start, end);
            }
            if (!StringUtils.isNotEmpty((CharSequence)customerCode) || !customerCode.equals(dataCheckVo.getCustomerCode()) || !d.getProductCode().equals(dataCheckVo.getProductCode()) || !d.getBusinessUnitCode().equals(dataCheckVo.getBusinessUnitCode()) || !d.getBusinessFormatCode().equals(dataCheckVo.getBusinessFormatCode()) || !d.getChannel().equals(dataCheckVo.getChannel())) continue;
            msg = "\u3010\u65f6\u95f4+\u5ba2\u6237+\u4ea7\u54c1+\u7535\u5546\u5ba2\u6237\u7b49\u7ea7\u3011\u7ef4\u5ea6," + index + "\u884c\u4e0e\u73b0\u5b58\u6570\u636e\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01";
            start = dataCheckVo.getStartDate();
            end = dataCheckVo.getEndDate();
            this.oneCheck(startDate, endDate, msg, start, end);
        }
        return customerVo1;
    }

    private void oneCheck(int startDate, int endDate, String msg, String start, String end) {
        int startI = Integer.parseInt(start.replace("-", ""));
        int endI = Integer.parseInt(end.replace("-", ""));
        Validate.isTrue((startDate < startI || startDate > endI ? 1 : 0) != 0, (String)msg, (Object[])new Object[0]);
        Validate.isTrue((endDate < startI || endDate > endI ? 1 : 0) != 0, (String)msg, (Object[])new Object[0]);
    }

    public Class<DistribClosePolicyImportVo> findCrmExcelVoClass() {
        return DistribClosePolicyImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_DISTRIB_CLOSE_POLICY_IMPORT";
    }

    public String getBusinessName() {
        return "TPM\u5206\u9500\u7ed3\u6848\u653f\u7b56\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "TPM_DISTRIB_CLOSE_POLICY_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u9500\u7ed3\u6848\u653f\u7b56\u5bfc\u5165\u6a21\u677f";
    }
}

