/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distrib.close.data.policy.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.distrib.close.data.policy.mapper.PlatformLogisticsExportMapper;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.PlatformLogisticsExportDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsExportVo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import liquibase.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlatformLogisticsExportProcess
implements ExportProcess<PlatformLogisticsExportVo> {
    private static final Logger log = LoggerFactory.getLogger(PlatformLogisticsExportProcess.class);
    @Autowired
    private PlatformLogisticsExportMapper mapper;

    public Integer getTotal(Map<String, Object> params) {
        PlatformLogisticsExportDto dto = this.getDto(params);
        Integer total = this.mapper.getExportTotal(dto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"));
        return total;
    }

    private PlatformLogisticsExportDto getDto(Map<String, Object> params) {
        Object yearAndMonth;
        Object customerName;
        Object deliveryCode;
        Object deliveryDistrict;
        Object deliveryCity;
        Object deliveryProvince;
        Object orderStatus;
        Object orderCode;
        PlatformLogisticsExportDto dto = new PlatformLogisticsExportDto();
        Object sapProductCode = params.get("sapProductCode");
        if (Objects.nonNull(sapProductCode)) {
            dto.setSapProductCode(sapProductCode.toString());
        }
        if (Objects.nonNull(orderCode = params.get("orderCode"))) {
            dto.setOrderCode(orderCode.toString());
        }
        if (Objects.nonNull(orderStatus = params.get("orderStatus"))) {
            dto.setOrderStatus(orderStatus.toString());
        }
        if (Objects.nonNull(deliveryProvince = params.get("deliveryProvince"))) {
            dto.setDeliveryProvince(deliveryProvince.toString());
        }
        if (Objects.nonNull(deliveryCity = params.get("deliveryCity"))) {
            dto.setDeliveryCity(deliveryCity.toString());
        }
        if (Objects.nonNull(deliveryDistrict = params.get("deliveryDistrict"))) {
            dto.setDeliveryDistrict(deliveryDistrict.toString());
        }
        if (Objects.nonNull(deliveryCode = params.get("deliveryCode"))) {
            dto.setDeliveryCode(deliveryCode.toString());
        }
        if (Objects.nonNull(customerName = params.get("customerName"))) {
            dto.setCustomerName(customerName.toString());
        }
        if (Objects.nonNull(yearAndMonth = params.get("yearAndMonth"))) {
            dto.setYearAndMonth(yearAndMonth.toString());
        }
        return dto;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        PlatformLogisticsExportDto dto = this.getDto(params);
        dto.setOffset(Integer.valueOf(this.getPageSize() * vo.getPageNo()));
        dto.setLimit(vo.getPageSize());
        List<PlatformLogisticsExportVo> data = this.mapper.findData(dto);
        return JSON.parseArray((String)JSON.toJSONString(data));
    }

    public String getBusinessCode() {
        return "TPM_PLATFORM_LOGISTICS_EXPORT";
    }

    public String getBusinessName() {
        return "TPM\u5e73\u53f0\u7269\u6d41\u5e95\u8868\u5bfc\u51fa";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }
}

