/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distrib.close.data.policy.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.distrib.close.data.policy.service.PlatformLogisticsService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsImportVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlatformLogisticsImportProcess
implements ImportProcess<PlatformLogisticsImportVo> {
    private static final Logger log = LoggerFactory.getLogger(PlatformLogisticsImportProcess.class);
    private static final Integer startRow = 2;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PlatformLogisticsService platformLogisticsService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, PlatformLogisticsImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= this.getBatchCount() ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7%s\u6761", (long)this.getBatchCount().intValue());
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, PlatformLogisticsImportVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            PlatformLogisticsImportVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSapProductCode()), "[sap\u4ee3\u7801]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getOrderCode()), "[\u8ba2\u5355\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getOrderStatus()), "[\u8ba2\u5355\u72b6\u6001]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getAfterSalesStatus()), "[\u552e\u540e\u72b6\u6001]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getDeliveryCode()), "[\u5feb\u9012\u5355\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessFormatCode()), "[\u4e1a\u6001]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "[\u6e20\u9053\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesOrgCode()), "[\u9500\u552e\u7ec4\u7ec7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomerCode()), "[\u5ba2\u6237\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getYearAndMonth()), "[\u6708\u4efd]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getProductNumber() != null, "[\u5546\u54c1\u6570\u91cf]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getNumber() != null, "[\u63d0\u6570]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, PlatformLogisticsImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        List<PlatformLogisticsVo> list = this.validate(data, errMap);
        if (errMap.isEmpty()) {
            this.platformLogisticsService.createBatch(list);
        }
        return errMap;
    }

    private List<PlatformLogisticsVo> validate(LinkedHashMap<Integer, PlatformLogisticsImportVo> data, Map<Integer, String> errMap) {
        ArrayList list = Lists.newArrayList();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Map<Object, Object> saleOrgVoMap = new HashMap();
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> channelVoMap = new HashMap();
        Set salesOrgCodeSet = data.values().stream().map(PlatformLogisticsImportVo::getSalesOrgCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        Set customerCodeSet = data.values().stream().map(PlatformLogisticsImportVo::getCustomerCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format"}));
        Map<String, String> formatMap = ((List)mapDict.get("mdm_business_format")).stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (e1, e2) -> e1));
        List channelCodeSet = data.values().stream().map(PlatformLogisticsImportVo::getChannelCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet));
        if (CollectionUtils.isNotEmpty((Collection)channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, CustomerChannelVo::getCustomerChannelName));
        }
        List saleOrgVoList = this.salesOrgVoService.findByErpCodeList((List)Lists.newArrayList(salesOrgCodeSet));
        List customerVoList = this.customerVoService.findByCustomerMdgCodes((List)Lists.newArrayList(customerCodeSet));
        if (CollectionUtils.isNotEmpty((Collection)saleOrgVoList)) {
            saleOrgVoMap = saleOrgVoList.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)customerVoList)) {
            customerVoMap = customerVoList.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        Map<Object, Object> finalChannelVoMap = channelVoMap;
        HashMap finalSaleOrgVoMap = saleOrgVoMap;
        HashMap finalCustomerVoMap = customerVoMap;
        data.forEach((k, value) -> {
            this.validateIsTrue(value.getProductNumber() > 0 && value.getProductNumber() <= 10, "[\u5546\u54c1\u6570\u91cf]\u4e0d\u80fd\u5c0f\u4e8e1\u6216\u5927\u4e8e10");
            this.validateIsTrue(value.getNumber() > 0, "[\u63d0\u6570]\u4e0d\u80fd\u5c0f\u4e8e1");
            try {
                Date yearAndMonth = sdf.parse(value.getYearAndMonth());
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(yearAndMonth);
                int importYear = calendar2.get(1);
                int importMonth = calendar2.get(2) + 1;
                if (year == importYear && month <= importMonth) {
                    this.validateIsTrue(false, String.format("\u53ea\u80fd\u5bfc\u5165\u5f53\u524d\u6708\u4e4b\u524d\u6570\u636e", new Object[0]));
                } else if (year < importYear) {
                    this.validateIsTrue(false, String.format("\u53ea\u80fd\u5bfc\u5165\u5f53\u524d\u6708\u4e4b\u524d\u6570\u636e", new Object[0]));
                }
            }
            catch (ParseException e2) {
                this.validateIsTrue(false, String.format("\u6708\u4efd\u683c\u5f0f\u9519\u8bef\u3002\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a2023-01", new Object[0]));
            }
            PlatformLogisticsVo vo = (PlatformLogisticsVo)this.nebulaToolkitService.copyObjectByWhiteList(value, PlatformLogisticsVo.class, HashSet.class, ArrayList.class, new String[0]);
            try {
                vo.setPayTime(Objects.nonNull(value.getImportPayTime()) ? sdf2.parse(value.getImportPayTime()) : null);
                vo.setPromiseDeliveryTime(Objects.nonNull(value.getImportPromiseDeliveryTime()) ? sdf2.parse(value.getImportPromiseDeliveryTime()) : null);
                vo.setDeliveryTime(Objects.nonNull(value.getImportDeliveryTime()) ? sdf2.parse(value.getImportDeliveryTime()) : null);
            }
            catch (ParseException e3) {
                this.validateIsTrue(false, String.format("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a2023-01-01 01:01", new Object[0]));
            }
            this.validateIsTrue(finalChannelVoMap.containsKey(value.getChannelCode()), "\u672a\u627e\u5230\u3010" + value.getChannelCode() + "\u3011\u5bf9\u5e94\u7684\u6e20\u9053");
            if (formatMap.containsKey(value.getBusinessFormatCode())) {
                vo.setBusinessFormatCode((String)formatMap.get(value.getBusinessFormatCode()));
            } else {
                this.validateIsTrue(false, "\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e1a\u6001\u540d\u79f0");
            }
            if (finalSaleOrgVoMap.containsKey(value.getSalesOrgCode())) {
                List list1 = (List)finalSaleOrgVoMap.get(value.getSalesOrgCode());
                SalesOrgVo salesOrgVo = list1.stream().filter(e -> value.getChannelCode().equals(e.getChannelCode()) && vo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (salesOrgVo != null) {
                    vo.setSalesOrgName(salesOrgVo.getSalesOrgName());
                } else {
                    this.validateIsTrue(false, "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u3010" + value.getSalesOrgCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            } else {
                this.validateIsTrue(false, "\u672a\u627e\u5230\u3010" + value.getSalesOrgCode() + "\u3011\u5bf9\u5e94\u7684\u7ec4\u7ec7");
            }
            if (finalCustomerVoMap.containsKey(value.getCustomerCode())) {
                List list2 = (List)finalCustomerVoMap.get(value.getCustomerCode());
                CustomerVo customerVo = list2.stream().filter(e -> value.getChannelCode().equals(e.getCustomerChannelCode()) && value.getSalesOrgCode().equals(e.getSalesInstitutionErpCode()) && vo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (customerVo != null) {
                    vo.setCustomerName(customerVo.getCustomerName());
                } else {
                    this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + value.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            } else {
                this.validateIsTrue(false, "\u672a\u627e\u5230\u3010" + value.getCustomerCode() + "\u3011\u5bf9\u5e94\u7684\u5ba2\u6237");
            }
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put((Integer)k, errInfo);
            }
            list.add(vo);
        });
        return list;
    }

    public Class<PlatformLogisticsImportVo> findCrmExcelVoClass() {
        return PlatformLogisticsImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_PLATFORM_LOGISTICS_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u5e73\u53f0\u7269\u6d41\u5e95\u8868\u5bfc\u5165";
    }
}

