/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distrib.close.data.policy.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.PlatformLogistics;
import com.biz.crm.tpm.business.distrib.close.data.policy.mapper.PlatformLogisticsMapper;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.PlatformLogisticsDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PlatformLogisticsRepository
extends ServiceImpl<PlatformLogisticsMapper, PlatformLogistics> {
    private static final Logger log = LoggerFactory.getLogger(PlatformLogisticsRepository.class);
    @Autowired
    private PlatformLogisticsMapper mapper;

    public Page<PlatformLogisticsVo> findByConditions(Pageable pageable, PlatformLogisticsDto dto) {
        return this.mapper.findByConditions((Page<PlatformLogisticsDto>)new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize()), dto);
    }

    public PlatformLogistics findDetailsById(String id) {
        return StringUtils.hasText((String)id) ? (PlatformLogistics)((Object)this.getById((Serializable)((Object)id))) : null;
    }

    public List<PlatformLogistics> findByItemKeys(List<String> itemKeys) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PlatformLogistics::getItemKey, itemKeys)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<PlatformLogistics> findByYearMonth(String yearMonth) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PlatformLogistics::getYearAndMonth, new Object[]{yearMonth})).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }
}

