/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distrib.close.data.policy.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.PlatformLogistics;
import com.biz.crm.tpm.business.distrib.close.data.policy.repository.PlatformLogisticsRepository;
import com.biz.crm.tpm.business.distrib.close.data.policy.service.PlatformLogisticsService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.PlatformLogisticsDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PlatformLogisticsServiceImpl
implements PlatformLogisticsService {
    private static final Logger log = LoggerFactory.getLogger(PlatformLogisticsServiceImpl.class);
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PlatformLogisticsRepository repository;

    @Override
    public Page<PlatformLogisticsVo> findByConditions(Pageable pageable, PlatformLogisticsDto dto) {
        return this.repository.findByConditions((Pageable)(pageable != null ? pageable : PageRequest.of((int)0, (int)50)), dto);
    }

    @Override
    public PlatformLogisticsVo findDetailsById(String id) {
        Validate.notEmpty((CharSequence)id, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        PlatformLogistics entity = this.repository.findDetailsById(id);
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u4fe1\u606f", (Object[])new Object[0]);
        return (PlatformLogisticsVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, PlatformLogisticsVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public void delete(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7f3a\u5c11\u5220\u9664\u6570\u636eid\uff0c\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        this.repository.removeByIds(ids);
    }

    @Override
    public void createBatch(List<PlatformLogisticsVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, PlatformLogisticsVo.class, PlatformLogistics.class, HashSet.class, ArrayList.class, new String[0]);
        entityList.forEach(e -> {
            StringBuffer itemKey = new StringBuffer();
            itemKey.append(e.getYearAndMonth());
            itemKey.append(e.getSapProductCode());
            itemKey.append(e.getCustomerCode());
            e.setItemKey(itemKey.toString());
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        this.repository.saveBatch(entityList);
    }
}

