/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distrib.close.data.policy.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.distrib.close.data.policy.entity.TpmDistribClosePolicyEntity;
import com.biz.crm.tpm.business.distrib.close.data.policy.repository.TpmDistribClosePolicyRepository;
import com.biz.crm.tpm.business.distrib.close.data.policy.service.TpmDistribClosePolicyTransService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DataCheckVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="tpmDistribClosePolicyService")
public class TpmDistribClosePolicyServiceImpl
implements TpmDistribClosePolicyService {
    private static final Logger log = LoggerFactory.getLogger(TpmDistribClosePolicyServiceImpl.class);
    @Autowired(required=false)
    private TpmDistribClosePolicyTransService tpmDistribClosePolicyTransService;
    @Autowired(required=false)
    private TpmDistribClosePolicyRepository tpmDistribClosePolicyRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<TpmDistribClosePolicyVo> findByConditions(Pageable pageable, TpmDistribClosePolicyDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmDistribClosePolicyDto();
        }
        return this.tpmDistribClosePolicyRepository.findByConditions(pageable, dto);
    }

    public void delete(List<String> ids) {
        Validate.isTrue((null != ids && ids.size() > 0 ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u5220\u9664\u6570\u636eid\uff0c\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List entities = this.tpmDistribClosePolicyRepository.listByIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(entity -> entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.tpmDistribClosePolicyTransService.updateBatchData(entities);
        }
    }

    public List<DataCheckVo> findConditionAll() {
        List<DataCheckVo> dataCheckVos = this.tpmDistribClosePolicyRepository.findConditionAll();
        if (CollectionUtils.isEmpty(dataCheckVos)) {
            return new ArrayList<DataCheckVo>();
        }
        return dataCheckVos;
    }

    public void saveBatchData(List<TpmDistribClosePolicyDto> importList) {
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        Date date = new Date();
        importList.forEach(dto -> {
            dto.setCreateAccount(loginDetails.getUsername());
            dto.setCreateName(loginDetails.getRealName());
            dto.setCreateTime(date);
            dto.setTenantCode(loginDetails.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(UUID.randomUUID().toString().replace("-", ""));
        });
        this.tpmDistribClosePolicyTransService.saveBatchData(this.nebulaToolkitService.copyCollectionByWhiteList(importList, TpmDistribClosePolicyDto.class, TpmDistribClosePolicyEntity.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<TpmDistribClosePolicyVo> findDistribClosePolicy(TpmDistribClosePolicyDto distribClosePolicy) {
        return this.tpmDistribClosePolicyRepository.findDistribClosePolicy(distribClosePolicy);
    }

    public List<TpmDistribClosePolicyVo> findByCondition(TpmDistribClosePolicyDto distribClosePolicy, String yearMonthLy) {
        return this.tpmDistribClosePolicyRepository.findByCondition(distribClosePolicy, yearMonthLy);
    }

    public List<TpmDistribClosePolicyVo> findPolicyForDistributionCustomerAuditData(TpmDistribClosePolicyDto distribClosePolicyDto) {
        return this.tpmDistribClosePolicyRepository.findPolicyForDistributionCustomerAuditData(distribClosePolicyDto);
    }

    public List<TpmDistribClosePolicyVo> findCostOfPlacement(Collection<TpmDistribClosePolicyDto> closePolicyDtos) {
        if (CollectionUtils.isEmpty(closePolicyDtos)) {
            return null;
        }
        return this.tpmDistribClosePolicyRepository.findCostOfPlacement(closePolicyDtos);
    }
}

