package com.biz.crm.tpm.business.distrib.close.policy.sdk.dto;

import java.time.*;
import java.math.*;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 平台物流底表
 *
 * @author zhouyang
 * @date 2023-07-20 11:54:47
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PlatformLogisticsDto", description = "平台物流底表")
public class PlatformLogisticsDto extends TenantFlagOpDto {

    @ApiModelProperty("年月")
    private String yearAndMonth;

    @ApiModelProperty("sap商品编码")
    private String sapProductCode;

    @ApiModelProperty("sap商品名称")
    private String sapProductName;

    @ApiModelProperty("备案店铺名")
    private String storeName;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("订单号")
    private String orderCode;

    @ApiModelProperty("订单状态")
    private String orderStatus;

    @ApiModelProperty("商品数量")
    private Integer productNumber;

    @ApiModelProperty("提数")
    private Integer number;

    @ApiModelProperty("支付时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private Data payTime;

    @ApiModelProperty("承诺发货时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private Data promiseDeliveryTime;

    @ApiModelProperty("发货时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date deliveryTime;

    @ApiModelProperty("商品id")
    private String productId;

    @ApiModelProperty("商品规格")
    private String productSpec;

    @ApiModelProperty("售后状态")
    private String afterSalesStatus;

    @ApiModelProperty("快递单号")
    private String deliveryCode;

    @ApiModelProperty("快递公司")
    private String deliveryCompany;

    @ApiModelProperty("发货人手机号")
    private String deliveryPersonPhone;

    @ApiModelProperty("省")
    private String deliveryProvince;

    @ApiModelProperty("市")
    private String deliveryCity;

    @ApiModelProperty("区县")
    private String deliveryDistrict;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("单据号")
    private String itemKey;

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    private String salesOrgName;
}