package com.biz.crm.tpm.business.distrib.close.policy.sdk.dto;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * 平台物流底表导出vo
 * @Author: zhouyang
 * @Date: 2023/7/21
 */
@Data
public class PlatformLogisticsExportDto {

    @ApiModelProperty("sap商品编码")
    private String sapProductCode;

    @ApiModelProperty("订单编码")
    private String orderCode;

    @ApiModelProperty("订单状态")
    private String orderStatus;

    @ApiModelProperty("省")
    private String deliveryProvince;

    @ApiModelProperty("市")
    private String deliveryCity;

    @ApiModelProperty("区")
    private String deliveryDistrict;

    @ApiModelProperty("物流单号")
    private String deliveryCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("日期")
    private String yearAndMonth;

    /**
     * 偏移量
     */
    @ApiModelProperty(name = "offset", notes = "偏移量", value = "偏移量")
    private Integer offset;

    /**
     * limit
     */
    @ApiModelProperty(name = "limit", notes = "limit", value = "limit")
    private Integer limit;
}
