package com.biz.crm.tpm.business.distrib.close.policy.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author hd
 * @create 2023-02-13 15:01:38
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "分销结案政策dto")
public class TpmDistribClosePolicyDto extends TenantFlagOpDto {

    @ApiModelProperty("业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    @ApiModelProperty("业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("开始日期(yyyy-MM-dd)")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    @ApiModelProperty("结束日期(yyyy-MM-dd)")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;

    @ApiModelProperty("销售组编码")
    private String salesGroupCode;

    @ApiModelProperty("销售组名称")
    private String salesGroupName;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("销售部门编码")
    private String saleDepartmentCode;

    @ApiModelProperty("销售部门名称")
    private String saleDepartmentName;

    @ApiModelProperty("平台")
    private String platformName;

    @ApiModelProperty("平台编码")
    private String platformCode;

    @ApiModelProperty("电商客户等级")
    private String estoreCustomerLevel;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户ERP编码")
    private String customerErpCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("基础返点-旬返")
    private BigDecimal tenDayReturn;

    @ApiModelProperty("基础返点-月返")
    private BigDecimal lunarReturn;

    @ApiModelProperty("月度目标返")
    private BigDecimal monthlyTargetReturn;

    @ApiModelProperty("到手价政策")
    private BigDecimal takeHomePricePolicy;

    @ApiModelProperty("人员费用")
    private BigDecimal staffCosts;

    @ApiModelProperty("投放费用")
    private BigDecimal costOfPlacement;

    @ApiModelProperty("物流支持")
    private BigDecimal logisticsSupport;

    @ApiModelProperty("捆绑返点")
    private BigDecimal bundleReturnPoint;

    @ApiModelProperty("其他支持")
    private BigDecimal otherCooperation;

    @ApiModelProperty("其他支持2")
    private BigDecimal otherCooperationTwo;

    @ApiModelProperty("其他支持3")
    private BigDecimal otherCooperationThree;

    @ApiModelProperty("其他支持4")
    private BigDecimal otherCooperationFour;

    @ApiModelProperty("季返")
    private BigDecimal quarterReturn;

    @ApiModelProperty("年返")
    private BigDecimal annualReturn;

    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    @ApiModelProperty(value = "年月", notes = "")
    private String distributionCustomerMonthSaleYearMonth;

    @ApiModelProperty("客户等级")
    private String customerLevel;

    @ApiModelProperty("销售组ERP编码")
    private String salesGroupErpCode;

    @ApiModelProperty("销售机构ERP编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty("销售部门ERP编码")
    private String saleDepartmentErpCode;
}