package com.biz.crm.tpm.business.distrib.close.policy.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.DataCheckVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import org.springframework.data.domain.Pageable;

import java.util.Collection;
import java.util.List;

/**
 * 分销结案政策(TpmDistribClosePolicy)表服务接口
 *
 * @author hd
 * @create 2023-02-13 15:01:38
 */
public interface TpmDistribClosePolicyService {

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    Page<TpmDistribClosePolicyVo> findByConditions(Pageable pageable, TpmDistribClosePolicyDto dto);

    /**
     * 删除数据
     *
     * @param ids 主键集合
     * @return 删除结果
     */
    void delete(List<String> ids);

    /**
     * 查询数据的校验条件
     *
     * @return
     */
    List<DataCheckVo> findConditionAll();

    /**
     * 批量保存数据
     *
     * @param importList
     */
    void saveBatchData(List<TpmDistribClosePolicyDto> importList);

    /**
     * 根据条件查询
     * @param distribClosePolicy 查询参数
     * @return List
     */
    List<TpmDistribClosePolicyVo> findDistribClosePolicy(TpmDistribClosePolicyDto distribClosePolicy);

    /**
     * 根据条件查询
     * @param distribClosePolicy 参数
     * @param YearMonthLy 年月
     * @return List
     */
    List<TpmDistribClosePolicyVo> findByCondition(TpmDistribClosePolicyDto distribClosePolicy, String YearMonthLy);

    /**
     * 分销客户物流结案查询分销物流政策数据
     * @param distribClosePolicyDto
     * @return
     */
    List<TpmDistribClosePolicyVo> findPolicyForDistributionCustomerAuditData(TpmDistribClosePolicyDto distribClosePolicyDto);

    /**
     * 获取投放费用
     *
     * @param closePolicyDtos
     * @return
     */
    List<TpmDistribClosePolicyVo> findCostOfPlacement(Collection<TpmDistribClosePolicyDto> closePolicyDtos);
}
