package com.biz.crm.tpm.business.distrib.close.policy.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author: hd
 * @date: 2023/02/15 15:30
 * @description: 分销结案政策导入vo
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class DistribClosePolicyImportVo extends CrmExcelVo {

    @CrmExcelColumn(value = "*业态")
    private String businessFormatCode;

    @CrmExcelColumn(value = "*业务单元")
    private String businessUnitCode;

    @CrmExcelColumn(value = "渠道")
    private String channel;

    @CrmExcelColumn(value = "*开始日期")
    private String startDate;

    @CrmExcelColumn(value = "*结束日期")
    private String endDate;

    @CrmExcelColumn(value = "*销售机构编码")
    private String salesInstitutionCode;

    @CrmExcelColumn(value = "销售机构名称")
    private String salesInstitutionName;

    @CrmExcelColumn(value = "销售部门编码")
    private String saleDepartmentCode;

    @CrmExcelColumn(value = "销售部门名称")
    private String saleDepartmentName;

    @CrmExcelColumn(value = "销售组编码")
    private String salesGroupCode;

    @CrmExcelColumn(value = "销售组名称")
    private String salesGroupName;

    @CrmExcelColumn(value = "*平台")
    private String platformName;

    @CrmExcelColumn(value = "*电商客户等级")
    private String estoreCustomerLevel;

    @CrmExcelColumn(value = "客户编码")
    private String customerCode;

    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    @CrmExcelColumn(value = "*产品编码")
    private String productCode;

    @CrmExcelColumn(value = "产品名称")
    private String productName;

    @CrmExcelColumn(value = "基础返点-旬返")
    private BigDecimal tenDayReturn;

    @CrmExcelColumn(value = "基础返点-月返")
    private BigDecimal lunarReturn;

    @CrmExcelColumn(value = "月度目标返")
    private BigDecimal monthlyTargetReturn;

    @CrmExcelColumn(value = "到手价政策")
    private BigDecimal takeHomePricePolicy;

    @CrmExcelColumn(value = "人员费用")
    private BigDecimal staffCosts;

    @CrmExcelColumn(value = "投放费用")
    private BigDecimal costOfPlacement;

    @CrmExcelColumn(value = "物流支持")
    private BigDecimal logisticsSupport;

    @CrmExcelColumn(value = "捆绑返点")
    private BigDecimal bundleReturnPoint;

    @CrmExcelColumn(value = "其他支持")
    private BigDecimal otherCooperation;

    @CrmExcelColumn(value = "其他支持2")
    private BigDecimal otherCooperationTwo;

    @CrmExcelColumn("其他支持3")
    private BigDecimal otherCooperationThree;

    @CrmExcelColumn("其他支持4")
    private BigDecimal otherCooperationFour;

    @CrmExcelColumn("季返")
    private BigDecimal quarterReturn;

    @CrmExcelColumn(value = "年返")
    private BigDecimal annualReturn;

    @ApiModelProperty(value = "渠道编码")
    private String channelCode;
}
