package com.biz.crm.tpm.business.distrib.close.policy.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 平台物流底表导出vo
 * @Author: zhouyang
 * @Date: 2023/7/21
 */
@ApiModel(value = "PlatformLogisticsExportVo",description = "平台物流底表导出vo")
@Getter
@Setter
@CrmExcelExport
public class PlatformLogisticsExportVo extends CrmExcelVo {


    @ApiModelProperty("id")
    @CrmExcelColumn("ID")
    private String id;

    @ApiModelProperty("年月")
    @CrmExcelColumn("年月")
    private String yearAndMonth;

    @ApiModelProperty("sap商品编码")
    @CrmExcelColumn("sap商品编码")
    private String sapProductCode;

    @ApiModelProperty("sap商品名称")
    @CrmExcelColumn("商品名称")
    private String sapProductName;

    @ApiModelProperty("备案店铺名")
    @CrmExcelColumn("备案店铺名")
    private String storeName;

    @ApiModelProperty("商品名称")
    @CrmExcelColumn("商品")
    private String productName;

    @ApiModelProperty("订单号")
    @CrmExcelColumn("订单号")
    private String orderCode;

    @ApiModelProperty("订单状态")
    @CrmExcelColumn("订单状态")
    private String orderStatus;

    @ApiModelProperty("商品数量")
    @CrmExcelColumn("商品数量")
    private Integer productNumber;

    @ApiModelProperty("提数")
    @CrmExcelColumn("提数")
    private Integer number;

    @ApiModelProperty("支付时间")
    @CrmExcelColumn("支付时间")
    private String payTime;

    @ApiModelProperty("承诺发货时间")
    @CrmExcelColumn("承诺发货时间")
    private String promiseDeliveryTime;

    @ApiModelProperty("发货时间")
    @CrmExcelColumn("发货时间")
    private String deliveryTime;

    @ApiModelProperty("商品id")
    @CrmExcelColumn("商品ID")
    private String productId;

    @ApiModelProperty("商品规格")
    @CrmExcelColumn("商品规格")
    private String productSpec;

    @ApiModelProperty("售后状态")
    @CrmExcelColumn("售后状态")
    private String afterSalesStatus;

    @ApiModelProperty("快递单号")
    @CrmExcelColumn("快递单号")
    private String deliveryCode;

    @ApiModelProperty("快递公司")
    @CrmExcelColumn("快递公司")
    private String deliveryCompany;

    @ApiModelProperty("发货人手机号")
    @CrmExcelColumn("发货人手机号")
    private String deliveryPersonPhone;

    @ApiModelProperty("省")
    @CrmExcelColumn("省")
    private String deliveryProvince;

    @ApiModelProperty("市")
    @CrmExcelColumn("市")
    private String deliveryCity;

    @ApiModelProperty("区县")
    @CrmExcelColumn("区")
    private String deliveryDistrict;

    @ApiModelProperty("客户编码")
    @CrmExcelColumn("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @CrmExcelColumn("客户名称")
    private String customerName;

    @ApiModelProperty("单据号")
    @CrmExcelColumn("单据号")
    private String itemKey;
}
