package com.biz.crm.tpm.business.distrib.close.policy.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 平台物流底表导入VO
 *
 * @author zhouyang
 * @date 2023-07-20 11:54:47
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PlatformLogisticsImportVo", description = "平台物流底表导入VO")
public class PlatformLogisticsImportVo extends CrmExcelVo {

    @ApiModelProperty("id")
    @CrmExcelColumn(value = "ID（无须填写）")
    private String id;

    /**
     * 业态
     */
    @CrmExcelColumn("*业态")
    private String businessFormatCode;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("*渠道编码")
    private String channelCode;

    /**
     * *销售组织编码
     */
    @CrmExcelColumn(value = "*销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn(value = "销售组织名称")
    private String salesOrgName;

    @ApiModelProperty("年月")
    @CrmExcelColumn(value = "*月份(格式:2021-10)")
    private String yearAndMonth;

    @ApiModelProperty("sap商品编码")
    @CrmExcelColumn(value = "*商品编码")
    private String sapProductCode;

    @ApiModelProperty("sap商品名称")
    @CrmExcelColumn(value = "商品名（政策中标准名称）")
    private String sapProductName;

    @ApiModelProperty("备案店铺名")
    @CrmExcelColumn(value = "备案店铺名")
    private String storeName;

    @ApiModelProperty("商品名称")
    @CrmExcelColumn(value = "商品")
    private String productName;

    @ApiModelProperty("订单号")
    @CrmExcelColumn(value = "*订单号")
    private String orderCode;

    @ApiModelProperty("订单状态")
    @CrmExcelColumn(value = "*订单状态")
    private String orderStatus;

    @ApiModelProperty("商品数量")
    @CrmExcelColumn(value = "*商品数量")
    private Integer productNumber;

    @ApiModelProperty("提数")
    @CrmExcelColumn(value = "*提数")
    private Integer number;

    @ApiModelProperty("支付时间")
    @CrmExcelColumn(value = "支付时间")
    private String importPayTime;

    @ApiModelProperty("承诺发货时间")
    @CrmExcelColumn(value = "承诺发货时间")
    private String importPromiseDeliveryTime;

    @ApiModelProperty("发货时间")
    @CrmExcelColumn(value = "发货时间")
    private String importDeliveryTime;

    @ApiModelProperty("商品ID")
    @CrmExcelColumn(value = "商品ID")
    private String productId;

    @ApiModelProperty("商品规格")
    @CrmExcelColumn(value = "商品规格")
    private String productSpec;

    @ApiModelProperty("售后状态")
    @CrmExcelColumn(value = "*售后状态")
    private String afterSalesStatus;

    @ApiModelProperty("快递单号")
    @CrmExcelColumn(value = "*快递单号")
    private String deliveryCode;

    @ApiModelProperty("快递公司")
    @CrmExcelColumn(value = "快递公司")
    private String deliveryCompany;

    @ApiModelProperty("发货人手机号")
    @CrmExcelColumn(value = "发货人手机号")
    private String deliveryPersonPhone;

    @ApiModelProperty("省")
    @CrmExcelColumn(value = "省")
    private String deliveryProvince;

    @ApiModelProperty("市")
    @CrmExcelColumn(value = "市")
    private String deliveryCity;

    @ApiModelProperty("区县")
    @CrmExcelColumn(value = "区")
    private String deliveryDistrict;

    @ApiModelProperty("客户名称")
    @CrmExcelColumn(value = "客户名称（公司全称）")
    private String customerName;

    @ApiModelProperty("客户编码")
    @CrmExcelColumn(value = "*客户编码")
    private String customerCode;

    @ApiModelProperty("单据号")
    @CrmExcelColumn(value = "单据号（无需填写）")
    private String itemKey;
}