/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.customer.audit.data.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/distribution/customer/audit/data"})
@Api(tags={"TPM-\u5206\u9500\u5ba2\u6237\u6838\u9500\u6570\u636e"})
public class TpmDistributionCustomerAuditDataController {
    private static final Logger log = LoggerFactory.getLogger(TpmDistributionCustomerAuditDataController.class);
    @Autowired(required=false)
    private TpmDistributionCustomerAuditDataService tpmDistributionCustomerAuditDataService;

    @PostMapping(value={"findByConditions"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u6570\u636e", notes="")
    public Result<Page<TpmDistributionCustomerAuditDataRespVo>> findByConditions(Pageable pageable, @RequestBody TpmDistributionCustomerAuditDataDto dto) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)dto.getDelFlag())) {
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            return Result.ok((Object)this.tpmDistributionCustomerAuditDataService.findByConditions(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u6838\u9500\u6570\u636e", notes="")
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.tpmDistributionCustomerAuditDataService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"calculateLogisticCost"})
    @ApiOperation(value="\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public Result<?> calculateLogisticCost(@RequestBody TpmDistributionCustomerAuditDataDto dto) {
        try {
            this.tpmDistributionCustomerAuditDataService.calculateLogisticCost(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"getObtainMonthlySales"})
    @ApiOperation(value="\u83b7\u53d6\u6708\u9500\u552e\u6570\u636e-\u540c\u6b65")
    public Result<?> getObtainMonthlySales(@RequestBody TpmDistributionCustomerAuditDataDto dto) {
        try {
            this.tpmDistributionCustomerAuditDataService.getObtainMonthlySales(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"getSaleQuantity"})
    @ApiOperation(value="\u83b7\u53d6\u5408\u8ba1\u9500\u91cf")
    public Result<?> getSaleQuantity(@RequestBody TpmDistributionCustomerAuditDataDto dto) {
        try {
            this.tpmDistributionCustomerAuditDataService.getSaleQuantity(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

