/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.customer.audit.data.local.controller;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.distribution.customer.audit.data.local.entity.TpmDistributionCustomerAuditDataEntity;
import com.biz.crm.tpm.business.distribution.customer.audit.data.local.repository.TpmDistributionCustomerAuditDataRepository;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataImportDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmDistributionCustomerAuditDataImportHandler
implements ImportProcess<TpmDistributionCustomerAuditDataImportDto> {
    private static final Logger log = LoggerFactory.getLogger(TpmDistributionCustomerAuditDataImportHandler.class);
    @Autowired(required=false)
    private TpmDistributionCustomerAuditDataService tpmDistributionCustomerAuditDataService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private TpmDistributionCustomerAuditDataRepository tpmDistributionCustomerAuditDataRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, TpmDistributionCustomerAuditDataImportDto> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, TpmDistributionCustomerAuditDataImportDto> row : data.entrySet()) {
            int rowNum = row.getKey();
            TpmDistributionCustomerAuditDataImportDto vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getDistributionCustomerAuditYearMonth()), "\u5e74\u6708\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getProductCode()), "\u4ea7\u54c1\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(vo.getSaleQuantity() != null, "\u5408\u8ba1\u9500\u91cf\uff08\u7bb1\uff09\u5fc5\u586b!");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmDistributionCustomerAuditDataImportDto> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Set productCodeList;
        List productList;
        List orgVos;
        List customerVos;
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        ArrayList<TpmDistributionCustomerAuditDataImportDto> importDtoList = new ArrayList<TpmDistributionCustomerAuditDataImportDto>(data.values());
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> orgVoMap = new HashMap();
        Map<Object, Object> channelVoMap = new HashMap();
        Map<Object, Object> productMap = new HashMap();
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> channelCodeSet = new HashSet<String>();
        HashSet<String> orgCodeSet = new HashSet<String>();
        ArrayList<String> repeatList = new ArrayList<String>();
        for (TpmDistributionCustomerAuditDataImportDto importDto : importDtoList) {
            customerCodeSet.add(importDto.getCustomerCode());
            channelCodeSet.add(importDto.getChannelCode());
            orgCodeSet.add(importDto.getSalesInstitutionCode());
            String sb = importDto.getCustomerCode() + "_" + importDto.getProductCode() + "_" + importDto.getDistributionCustomerAuditYearMonth();
            if (repeatList.contains(sb)) {
                this.validateIsTrue(false, "\u5bfc\u5165\u6570\u636e\u91cd\u590d");
            }
            repeatList.add(sb);
        }
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList(MDM_BUSINESS_FORMAT, "mdm_estore_platform"));
        List channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet));
        if (!CollectionUtils.isEmpty((Collection)channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(e -> e.getCustomerChannelCode(), Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(orgVos = this.salesOrgVoService.findByErpCodeList(new ArrayList(orgCodeSet))))) {
            orgVoMap = orgVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)(productList = this.productVoService.findByProductCodes(new ArrayList(productCodeList = importDtoList.stream().map(TpmDistributionCustomerAuditDataImportDto::getProductCode).collect(Collectors.toSet())))))) {
            productMap = productList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        Date date = new Date();
        ArrayList<TpmDistributionCustomerAuditDataDto> entitySaveList = new ArrayList<TpmDistributionCustomerAuditDataDto>();
        ArrayList<TpmDistributionCustomerAuditDataDto> entityUpdateList = new ArrayList<TpmDistributionCustomerAuditDataDto>();
        for (Map.Entry<Integer, TpmDistributionCustomerAuditDataImportDto> row : data.entrySet()) {
            String errInfo;
            List list;
            DictDataVo promotionType = ((List)dictDataMap.get(MDM_BUSINESS_FORMAT)).stream().filter(e -> e.getDictValue().equals(((TpmDistributionCustomerAuditDataImportDto)row.getValue()).getBusinessFormatCode())).findFirst().orElse(null);
            if (promotionType != null) {
                row.getValue().setBusinessFormatCode(promotionType.getDictCode());
            } else {
                this.validateIsTrue(false, "\u4e1a\u6001\u3010" + row.getValue().getBusinessFormatCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (channelVoMap.containsKey(row.getValue().getChannelCode())) {
                row.getValue().setChannelName(((CustomerChannelVo)channelVoMap.get(row.getValue().getChannelCode())).getCustomerChannelName());
            } else {
                this.validateIsTrue(false, "\u6e20\u9053\u7f16\u7801\u3010" + row.getValue().getChannelCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            SalesOrgVo salesOrgVo = null;
            if (orgVoMap.containsKey(row.getValue().getSalesInstitutionCode())) {
                list = (List)orgVoMap.get(row.getValue().getSalesInstitutionCode());
                salesOrgVo = list.stream().filter(e -> ((TpmDistributionCustomerAuditDataImportDto)row.getValue()).getChannelCode().equals(e.getChannelCode()) && ((TpmDistributionCustomerAuditDataImportDto)row.getValue()).getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (salesOrgVo == null) {
                    this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + row.getValue().getSalesInstitutionCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u9500\u552e\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    row.getValue().setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                }
            } else {
                this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + row.getValue().getSalesInstitutionCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (customerVoMap.containsKey(row.getValue().getCustomerCode())) {
                list = (List)customerVoMap.get(row.getValue().getCustomerCode());
                SalesOrgVo finalSalesOrgVo = salesOrgVo;
                CustomerVo customerVo = list.stream().filter(e -> ((TpmDistributionCustomerAuditDataImportDto)row.getValue()).getChannelCode().equals(e.getCustomerChannelCode()) && finalSalesOrgVo.getSalesInstitutionCode().equals(e.getSalesInstitutionCode()) && ((TpmDistributionCustomerAuditDataImportDto)row.getValue()).getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (customerVo == null) {
                    this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + row.getValue().getCustomerCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    row.getValue().setCustomerName(customerVo.getCustomerName());
                }
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + row.getValue().getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (productMap != null && productMap.get(row.getValue().getProductCode()) != null) {
                row.getValue().setProductName(((ProductVo)productMap.get(row.getValue().getProductCode())).getProductName());
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            errMap.put(row.getKey(), errInfo);
        }
        if (!errMap.isEmpty()) {
            return errMap;
        }
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        ArrayList entityList = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), TpmDistributionCustomerAuditDataImportDto.class, TpmDistributionCustomerAuditDataDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        for (TpmDistributionCustomerAuditDataDto entity : entityList) {
            List<TpmDistributionCustomerAuditDataEntity> byUnique = this.tpmDistributionCustomerAuditDataRepository.findByUnique(entity);
            ArrayList entityUniqueList = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(byUnique, TpmDistributionCustomerAuditDataEntity.class, TpmDistributionCustomerAuditDataDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            if (CollectionUtils.isNotEmpty(entityUniqueList)) {
                TpmDistributionCustomerAuditDataDto entityUpdate = (TpmDistributionCustomerAuditDataDto)entityUniqueList.get(0);
                entityUpdate.setSaleQuantity(entity.getSaleQuantity());
                entityUpdate.setPlatformCode(entity.getPlatformCode());
                entityUpdate.setPlatformName(entity.getPlatformName());
                entityUpdate.setStoreName(entity.getStoreName());
                entityUpdateList.add(entityUpdate);
                continue;
            }
            entity.setMd5UniqueKey(entity.generateMd5UniqueKey());
            entity.setCreateAccount(loginDetails.getAccount());
            entity.setCreateName(loginDetails.getUsername());
            entity.setCreateTime(date);
            entity.setModifyAccount(loginDetails.getAccount());
            entity.setModifyName(loginDetails.getUsername());
            entity.setModifyTime(date);
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entitySaveList.add(entity);
        }
        this.tpmDistributionCustomerAuditDataService.saveImport(entitySaveList, entityUpdateList);
        return errMap;
    }

    public Class<TpmDistributionCustomerAuditDataImportDto> findCrmExcelVoClass() {
        return TpmDistributionCustomerAuditDataImportDto.class;
    }

    public String getTemplateCode() {
        return "TPM_DISTRIBUTION_CUSTOMER_AUDIT_DATA_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u9500\u5ba2\u6237\u6838\u9500\u6570\u636e\u5bfc\u5165";
    }
}

