/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.customer.audit.data.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.PlatformLogisticsVoService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.PlatformLogisticsVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.distribution.customer.audit.data.local.entity.TpmDistributionCustomerAuditDataEntity;
import com.biz.crm.tpm.business.distribution.customer.audit.data.local.mapper.TpmDistributionCustomerAuditDataEntityMapper;
import com.biz.crm.tpm.business.distribution.customer.audit.data.local.repository.TpmDistributionCustomerAuditDataRepository;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataImportDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TpmDistributionCustomerAuditDataServiceImpl
implements TpmDistributionCustomerAuditDataService {
    private static final Logger log = LoggerFactory.getLogger(TpmDistributionCustomerAuditDataServiceImpl.class);
    @Autowired(required=false)
    private TpmDistributionCustomerAuditDataEntityMapper tpmDistributionCustomerAuditDataEntityMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private TpmDistribClosePolicyService tpmDistribClosePolicyService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private TpmDistributionCustomerAuditDataRepository tpmDistributionCustomerAuditDataRepository;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private RedissonClient redissonClient;
    @Autowired(required=false)
    private PlatformLogisticsVoService platformLogisticsVoService;
    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";

    public Page<TpmDistributionCustomerAuditDataRespVo> findByConditions(Pageable pageable, TpmDistributionCustomerAuditDataDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.tpmDistributionCustomerAuditDataEntityMapper.findByConditions(page, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        this.tpmDistributionCustomerAuditDataRepository.removeByIds(ids);
    }

    public void saveImport(List<TpmDistributionCustomerAuditDataDto> dtoSaveList, List<TpmDistributionCustomerAuditDataDto> dtoUpdateList) {
        ArrayList entitySaveList = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(dtoSaveList, TpmDistributionCustomerAuditDataDto.class, TpmDistributionCustomerAuditDataEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        ArrayList entityUpdateList = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(dtoUpdateList, TpmDistributionCustomerAuditDataDto.class, TpmDistributionCustomerAuditDataEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmDistributionCustomerAuditDataRepository.saveOrUpdateBatch(entityUpdateList);
        int page = 0;
        int pageSize = 500;
        while (page * pageSize < entitySaveList.size()) {
            if ((page + 1) * pageSize >= entitySaveList.size()) {
                this.saveList(entitySaveList.subList(page * pageSize, entitySaveList.size()));
            } else {
                this.saveList(entitySaveList.subList(page * pageSize, (page + 1) * pageSize));
            }
            ++page;
        }
    }

    private String getLastYearMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.substring(0, 4));
        int month = Integer.parseInt(yearMonth.substring(5, 7));
        if (1 == month) {
            --year;
            month = 12;
        } else {
            --month;
        }
        return "" + year + "-" + String.format("%02d", month);
    }

    public List<TpmDistributionCustomerAuditDataRespVo> listForVariable(TpmDistributionCustomerAuditDataImportDto dto) {
        List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDistributionCustomerAuditDataRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()), TpmDistributionCustomerAuditDataEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCode()), TpmDistributionCustomerAuditDataEntity::getProductCode, (Object)dto.getProductCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getDistributionCustomerAuditYearMonth()), TpmDistributionCustomerAuditDataEntity::getDistributionCustomerAuditYearMonth, (Object)dto.getDistributionCustomerAuditYearMonth())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entityList, TpmDistributionCustomerAuditDataEntity.class, TpmDistributionCustomerAuditDataRespVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void calculateLogisticCost(TpmDistributionCustomerAuditDataDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getDistributionCustomerAuditYearMonth())) {
            throw new UnsupportedOperationException("\u8bf7\u9009\u62e9\u5e74\u6708");
        }
        String rule = "\\d{4}-\\d{2}";
        if (!Pattern.matches(rule, dto.getDistributionCustomerAuditYearMonth())) {
            throw new UnsupportedOperationException("\u5e74\u6708\u683c\u5f0f\u5f02\u5e38");
        }
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        String lock = "tpm:distribution:customer:audit:data:calculate:" + dto.getDistributionCustomerAuditYearMonth();
        RLock rlock = this.redissonClient.getLock(lock);
        boolean flag = false;
        try {
            flag = rlock.tryLock(10L, 300L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("\u5206\u9500\u5ba2\u6237\u7269\u6d41\u70b9\u6570\u8ba1\u7b97\u83b7\u53d6\u9501\u5931\u8d25");
        }
        if (!flag) {
            throw new UnsupportedOperationException("\u7269\u6d41\u7ed3\u6848\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e...");
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.loginUserService.refreshAuthentication((Object)loginDetails);
                Date lastYearMonth = DateUtil.dateAddMonth((Date)DateUtil.parse((String)dto.getDistributionCustomerAuditYearMonth(), (String)"yyyy-MM"), (Integer)-1);
                String lastYearMonthStr = DateUtil.format((Date)lastYearMonth, (String)"yyyy-MM");
                int pageNum = 0;
                int pageSize = 1000;
                Page<TpmDistributionCustomerAuditDataEntity> page = new Page<TpmDistributionCustomerAuditDataEntity>((long)pageNum, (long)pageSize);
                page = this.tpmDistributionCustomerAuditDataRepository.findByYearMonth(page, dto.getDistributionCustomerAuditYearMonth());
                while (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
                    List entityList = page.getRecords();
                    Map customerVoMap = null;
                    List customerCodeList = entityList.stream().map(o -> o.getCustomerCode() + o.getSalesInstitutionCode() + o.getChannelCode() + o.getBusinessFormatCode()).distinct().collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(customerCodeList)) {
                        List customerVoList = this.customerVoService.findBaseByCustomerCodes(customerCodeList);
                        if (CollectionUtils.isNotEmpty((Collection)customerVoList)) {
                            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                        }
                    } else {
                        throw new UnsupportedOperationException("\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38");
                    }
                    List<String> uniqueKeyList = entityList.stream().map(e -> lastYearMonthStr + e.getProductCode() + e.getCustomerCode()).collect(Collectors.toList());
                    List<TpmDistributionCustomerAuditDataEntity> lastMonthDataList = this.tpmDistributionCustomerAuditDataRepository.findByUniqueKeyList(uniqueKeyList);
                    Map<String, Integer> lastNonAuditQuantityMap = lastMonthDataList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getMd5UniqueKey()) && Objects.nonNull(e.getRemainNonAuditQuantity())).collect(Collectors.toMap(TpmDistributionCustomerAuditDataEntity::getMd5UniqueKey, TpmDistributionCustomerAuditDataEntity::getRemainNonAuditQuantity, (v1, v2) -> v2));
                    for (TpmDistributionCustomerAuditDataEntity entity : entityList) {
                        CustomerVo customerVo = (CustomerVo)customerVoMap.get(entity.getCustomerCode() + entity.getSalesInstitutionCode() + entity.getChannelCode() + entity.getBusinessFormatCode());
                        String customerMdgCode = entity.getCustomerCode();
                        TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSaleDto = new TpmDistributionCustomerMonthSaleDto();
                        distributionCustomerMonthSaleDto.setCustomerCode(customerMdgCode);
                        distributionCustomerMonthSaleDto.setProductCode(entity.getProductCode());
                        distributionCustomerMonthSaleDto.setDistributionCustomerMonthSaleYearMonth(entity.getDistributionCustomerAuditYearMonth());
                        List monthSaleData = this.tpmDistributionCustomerMonthSaleService.findCustomerMonthSalesByParams(distributionCustomerMonthSaleDto);
                        SearchPriceDto searchPriceDto = new SearchPriceDto();
                        searchPriceDto.setPriceTypeCode(PriceTypeEnum.ZDS1.getDictCode());
                        ArrayList<SearchPriceDimensionItemDto> itemDtos = new ArrayList<SearchPriceDimensionItemDto>();
                        SearchPriceDimensionItemDto dimensionItemDto3 = new SearchPriceDimensionItemDto();
                        dimensionItemDto3.setDimensionCode(PriceDimensionEnum.SALES_ORG_CODE.getDictCode());
                        dimensionItemDto3.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{entity.getSalesInstitutionCode()}));
                        itemDtos.add(dimensionItemDto3);
                        SearchPriceDimensionItemDto dimensionItemDto4 = new SearchPriceDimensionItemDto();
                        dimensionItemDto4.setDimensionCode(PriceDimensionEnum.PRODUCT_GROUP.getDictCode());
                        dimensionItemDto4.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{entity.getBusinessFormatCode()}));
                        itemDtos.add(dimensionItemDto4);
                        SearchPriceDimensionItemDto dimensionItemDto2 = new SearchPriceDimensionItemDto();
                        dimensionItemDto2.setDimensionCode(PriceDimensionEnum.CUSTOMER.getDictCode());
                        dimensionItemDto2.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{entity.getCustomerCode()}));
                        itemDtos.add(dimensionItemDto2);
                        SearchPriceDimensionItemDto dimensionItemDto1 = new SearchPriceDimensionItemDto();
                        dimensionItemDto1.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
                        dimensionItemDto1.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{entity.getProductCode()}));
                        itemDtos.add(dimensionItemDto1);
                        searchPriceDto.setDimensionItems(itemDtos);
                        searchPriceDto.setSearchTime(DateUtil.parse((String)(entity.getDistributionCustomerAuditYearMonth() + "-01"), (String)"yyyy-MM-dd"));
                        log.info("=================================");
                        log.info("=================================\u83b7\u53d6\u4ef7\u683cdto\uff1a" + JSONObject.toJSONString((Object)searchPriceDto));
                        Map priceMap = this.priceModelVoService.handleSearchPrice(searchPriceDto);
                        log.info("=================================\u83b7\u53d6\u4ef7\u683cmap\uff1a" + JSONObject.toJSONString((Object)priceMap));
                        log.info("=================================");
                        TpmDistribClosePolicyDto distribClosePolicyDto = new TpmDistribClosePolicyDto();
                        distribClosePolicyDto.setCustomerCode(customerMdgCode);
                        distribClosePolicyDto.setProductCode(entity.getProductCode());
                        distribClosePolicyDto.setSalesInstitutionCode(entity.getSalesInstitutionCode());
                        distribClosePolicyDto.setChannel(entity.getChannelCode());
                        distribClosePolicyDto.setBusinessFormatCode(entity.getBusinessFormatCode());
                        distribClosePolicyDto.setEstoreCustomerLevel(customerVo.getEstoreCustomerLevel());
                        distribClosePolicyDto.setStartDate(entity.getDistributionCustomerAuditYearMonth() + "-01");
                        List policyVoList = this.tpmDistribClosePolicyService.findPolicyForDistributionCustomerAuditData(distribClosePolicyDto);
                        TpmDistributionCustomerAuditDataDto distributionCustomerAuditDataDto = new TpmDistributionCustomerAuditDataDto();
                        distributionCustomerAuditDataDto.setCustomerCode(entity.getCustomerCode());
                        distributionCustomerAuditDataDto.setProductCode(entity.getProductCode());
                        distributionCustomerAuditDataDto.setDistributionCustomerAuditYearMonth(entity.getDistributionCustomerAuditYearMonth());
                        distributionCustomerAuditDataDto.setTenantCode(TenantUtils.getTenantCode());
                        LinkedList<TpmDistributionCustomerAuditDataRespVo> latestMonthList = this.tpmDistributionCustomerAuditDataEntityMapper.findLatestList(distributionCustomerAuditDataDto);
                        if (CollectionUtils.isNotEmpty((Collection)monthSaleData)) {
                            TpmDistributionCustomerMonthSaleRespVo monthSale = this.initData((TpmDistributionCustomerMonthSaleRespVo)monthSaleData.get(0));
                            entity.setMonthSaleQuantity(monthSale.getMonthSaleQuantity());
                            entity.setManualAuditQuantity(monthSale.getManualAuditSaleQuantity().intValue());
                            entity.setPolicyAuditQuantity(entity.getMonthSaleQuantity() - entity.getManualAuditQuantity());
                        }
                        if (entity.getPolicyAuditQuantity() == null) {
                            entity.setPolicyAuditQuantity(0);
                        }
                        if (CollectionUtils.isNotEmpty(latestMonthList)) {
                            if (latestMonthList.get(0).getRemainNonAuditQuantity() == null) {
                                latestMonthList.get(0).setRemainNonAuditQuantity(Integer.valueOf(0));
                            }
                            entity.setShouldAuditQuantity(entity.getPolicyAuditQuantity() + latestMonthList.get(0).getRemainNonAuditQuantity());
                        } else {
                            entity.setShouldAuditQuantity(entity.getPolicyAuditQuantity());
                        }
                        if (entity.getSaleQuantity() == null) {
                            entity.setSaleQuantity(0);
                        }
                        entity.setInFactAuditQuantity(entity.getSaleQuantity() <= entity.getShouldAuditQuantity() ? entity.getSaleQuantity() : entity.getShouldAuditQuantity());
                        if (entity.getInFactAuditQuantity() <= 0) {
                            entity.setInFactAuditQuantity(0);
                        }
                        entity.setRemainNonAuditQuantity(entity.getShouldAuditQuantity() - entity.getInFactAuditQuantity());
                        if (priceMap != null && priceMap.get(entity.getProductCode()) != null) {
                            entity.setSupplyPrice(((PriceModelVo)priceMap.get(entity.getProductCode())).getPrice());
                        } else {
                            entity.setSupplyPrice(BigDecimal.ZERO);
                        }
                        entity.setLogisticPoint(BigDecimal.ZERO);
                        if (CollectionUtils.isNotEmpty((Collection)policyVoList)) {
                            if (((TpmDistribClosePolicyVo)policyVoList.get(0)).getLogisticsSupport() != null) {
                                entity.setLogisticPoint(((TpmDistribClosePolicyVo)policyVoList.get(0)).getLogisticsSupport());
                            } else {
                                entity.setLogisticPoint(BigDecimal.ZERO);
                            }
                            entity.setLogisticCost(entity.getLogisticPoint().multiply(entity.getSupplyPrice()).multiply(new BigDecimal(entity.getInFactAuditQuantity())));
                        }
                        if (BigDecimal.ZERO.compareTo(entity.getLogisticPoint()) != 0) continue;
                        entity.setRemainNonAuditQuantity(lastNonAuditQuantityMap.getOrDefault(entity.getMd5UniqueKey(), 0));
                    }
                    this.tpmDistributionCustomerAuditDataRepository.updateBatchById(entityList);
                    if (page.hasNext()) {
                        page = new Page<TpmDistributionCustomerAuditDataEntity>((long)(++pageNum), (long)pageSize);
                        page = this.tpmDistributionCustomerAuditDataRepository.findByYearMonth(page, dto.getDistributionCustomerAuditYearMonth());
                        continue;
                    }
                    page.setRecords(new ArrayList());
                }
            }
            catch (Exception e2) {
                log.error("\u7269\u6d41\u7ed3\u6848\u8ba1\u7b97\u5f02\u5e38\uff1a", (Throwable)e2);
                throw e2;
            }
            finally {
                if (rlock.isLocked() && rlock.isHeldByCurrentThread()) {
                    rlock.unlock();
                }
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void getObtainMonthlySales(TpmDistributionCustomerAuditDataDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u8f93\u5165\u83b7\u53d6\u6708\u9500\u552e\u6570\u636e\u7684\u6761\u4ef6\uff01", (Object[])new Object[0]);
        String distributionCustomerAuditYearMonth = dto.getDistributionCustomerAuditYearMonth();
        Validate.notBlank((CharSequence)distributionCustomerAuditYearMonth, (String)"\u8bf7\u8f93\u5165\u83b7\u53d6\u6708\u9500\u552e\u6570\u636e\u7684\u6761\u4ef6\uff01", (Object[])new Object[0]);
        try {
            DateUtil.date_yyyy_MM.parse(distributionCustomerAuditYearMonth);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8befyyyy-MM\uff01\u4f8b\uff1a2023-01");
        }
        PageRequest pageable = PageRequest.of((int)1, (int)1000);
        TpmDistributionCustomerMonthSaleDto tpmDistributionCustomerMonthSaleDto = new TpmDistributionCustomerMonthSaleDto();
        tpmDistributionCustomerMonthSaleDto.setDistributionCustomerMonthSaleYearMonth(distributionCustomerAuditYearMonth);
        Page pageResult = this.tpmDistributionCustomerMonthSaleService.findByConditions((Pageable)pageable, tpmDistributionCustomerMonthSaleDto);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        if (CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            this.tpmDistributionCustomerAuditDataRepository.deleteByYearMonth(distributionCustomerAuditYearMonth);
        }
        this.buildAndSaveData(pageResult.getRecords(), loginUser);
        while (pageResult.hasNext()) {
            pageResult = this.tpmDistributionCustomerMonthSaleService.findByConditions((Pageable)(pageable = PageRequest.of((int)(pageable.getPageNumber() + 1), (int)pageable.getPageSize())), tpmDistributionCustomerMonthSaleDto);
            if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
                return;
            }
            this.buildAndSaveData(pageResult.getRecords(), loginUser);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void getSaleQuantity(TpmDistributionCustomerAuditDataDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u8f93\u5165\u83b7\u53d6\u5408\u8ba1\u9500\u91cf\u7684\u6761\u4ef6\uff01", (Object[])new Object[0]);
        String distributionCustomerAuditYearMonth = dto.getDistributionCustomerAuditYearMonth();
        Validate.notBlank((CharSequence)distributionCustomerAuditYearMonth, (String)"\u8bf7\u8f93\u5165\u83b7\u53d6\u5408\u8ba1\u9500\u91cf\u7684\u6761\u4ef6\uff01", (Object[])new Object[0]);
        List<TpmDistributionCustomerAuditDataEntity> entities = this.tpmDistributionCustomerAuditDataRepository.findByYearMonth(distributionCustomerAuditYearMonth);
        Validate.notEmpty(entities, (String)"\u672a\u627e\u5230\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e", (Object[])new Object[0]);
        List platformLogisticsVoList = this.platformLogisticsVoService.findByYearMonth(distributionCustomerAuditYearMonth);
        Validate.notEmpty((Collection)platformLogisticsVoList, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7269\u6d41\u5e95\u8868\u7684\u6570\u636e", (Object[])new Object[0]);
        Map<String, List<PlatformLogisticsVo>> platformLogisticsVoMap = platformLogisticsVoList.stream().collect(Collectors.groupingBy(e -> e.getCustomerCode() + e.getSapProductCode()));
        for (TpmDistributionCustomerAuditDataEntity entity : entities) {
            String cp = entity.getCustomerCode() + entity.getProductCode();
            if (!platformLogisticsVoMap.containsKey(cp)) continue;
            List<PlatformLogisticsVo> voList = platformLogisticsVoMap.get(cp);
            Integer saleQuantity = 0;
            for (PlatformLogisticsVo vo : voList) {
                saleQuantity = saleQuantity + vo.getNumber() * vo.getProductNumber();
            }
            entity.setSaleQuantity(saleQuantity);
        }
        this.tpmDistributionCustomerAuditDataRepository.saveOrUpdateBatch(entities);
    }

    private void buildAndSaveData(List<TpmDistributionCustomerMonthSaleRespVo> list, AbstractCrmUserIdentity loginUser) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Date nowTime = new Date();
        String realName = loginUser.getRealName();
        String account = loginUser.getAccount();
        String delCode = DelFlagStatusEnum.NORMAL.getCode();
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList<TpmDistributionCustomerAuditDataEntity> dataEntityList = new ArrayList<TpmDistributionCustomerAuditDataEntity>(list.size());
        for (TpmDistributionCustomerMonthSaleRespVo monthSaleRespVo : list) {
            TpmDistributionCustomerAuditDataEntity auditDataEntity = new TpmDistributionCustomerAuditDataEntity();
            auditDataEntity.setCreateName(realName);
            auditDataEntity.setCreateAccount(account);
            auditDataEntity.setCreateTime(nowTime);
            auditDataEntity.setTenantCode(tenantCode);
            auditDataEntity.setDelFlag(delCode);
            auditDataEntity.setId(monthSaleRespVo.getId());
            auditDataEntity.setBusinessFormatCode(monthSaleRespVo.getBusinessFormatCode());
            auditDataEntity.setChannelName(monthSaleRespVo.getChannelName());
            auditDataEntity.setChannelCode(monthSaleRespVo.getChannelCode());
            auditDataEntity.setSalesInstitutionCode(monthSaleRespVo.getSalesInstitutionCode());
            auditDataEntity.setSalesInstitutionName(monthSaleRespVo.getSalesInstitutionName());
            auditDataEntity.setCustomerCode(monthSaleRespVo.getCustomerCode());
            auditDataEntity.setCustomerName(monthSaleRespVo.getCustomerName());
            auditDataEntity.setProductCode(monthSaleRespVo.getProductCode());
            auditDataEntity.setProductName(monthSaleRespVo.getProductName());
            auditDataEntity.setDistributionCustomerAuditYearMonth(monthSaleRespVo.getDistributionCustomerMonthSaleYearMonth());
            auditDataEntity.setMd5UniqueKey(auditDataEntity.generateMd5UniqueKey());
            dataEntityList.add(auditDataEntity);
        }
        this.tpmDistributionCustomerAuditDataRepository.saveBatchData(dataEntityList);
    }

    public List<TpmDistributionCustomerAuditDataRespVo> findProductListByConditions(TpmDistributionCustomerAuditDataDto customerAuditDataDto) {
        if (Objects.isNull(customerAuditDataDto)) {
            return null;
        }
        return this.tpmDistributionCustomerAuditDataRepository.findProductListByConditions(customerAuditDataDto);
    }

    private TpmDistributionCustomerMonthSaleRespVo initData(TpmDistributionCustomerMonthSaleRespVo monthSaleData) {
        if (monthSaleData.getManualAuditSaleQuantity() == null) {
            monthSaleData.setManualAuditSaleQuantity(BigDecimal.ZERO);
        }
        return monthSaleData;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveList(List<TpmDistributionCustomerAuditDataEntity> entityList) {
        this.tpmDistributionCustomerAuditDataEntityMapper.insertList(entityList);
    }

    public List<TpmDistributionCustomerAuditDataRespVo> findListByConditions(TpmDistributionCustomerAuditDataDto dto) {
        return this.tpmDistributionCustomerAuditDataEntityMapper.findListByConditions(dto);
    }
}

