package com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName TpmDistributionCustomerAuditDataDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/17
 */
@Data
@ApiModel("分销客户核销数据数据传输类")
public class TpmDistributionCustomerAuditDataDto extends TenantFlagOpDto {

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("年月")
    private String distributionCustomerAuditYearMonth;

    @ApiModelProperty("合计销量（箱）")
    private Long saleQuantity;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("平台编码")
    private String platformCode;

    @ApiModelProperty("平台")
    private String platformName;

    @ApiModelProperty("备案店铺名")
    private String storeName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;

    @ApiModelProperty(value = "月度总销量", notes = "")
    private Integer monthSaleQuantity;

    @ApiModelProperty(value = "手工已结案数量", notes = "")
    private Integer manualAuditQuantity;

    @ApiModelProperty(value = "当月政策可核销数量", notes = "")
    private Integer policyAuditQuantity;

    @ApiModelProperty(value = "应核销总数量", notes = "")
    private Integer shouldAuditQuantity;

    @ApiModelProperty(value = "当月实际核销数量", notes = "")
    private Integer inFactAuditQuantity;

    @ApiModelProperty(value = "剩余未核销数量", notes = "")
    private Integer remainNonAuditQuantity;

    @ApiModelProperty(value = "物流点数", notes = "")
    private BigDecimal logisticPoint;

    @ApiModelProperty(value = "供货价", notes = "")
    private BigDecimal supplyPrice;

    @ApiModelProperty(value = "物流费用", notes = "")
    private BigDecimal logisticCost;

    /**
     * 唯一键
     */
    @ApiModelProperty(value = "唯一键", notes = "")
    private String md5UniqueKey;

    /**
     * 生成唯一键
     * @author jiangyin
     * @date 2023/1/3 13:58
     * @return java.lang.String
     */
    public String generateMd5UniqueKey(){
        return this.distributionCustomerAuditYearMonth + this.productCode + this.customerCode;
    }

    @ApiModelProperty("客户编码集合")
    private List<String> customerCodeList;

}
