package com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @ClassName TpmDistributionCustomerAuditDataImportDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/17
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("分销客户核销数据导入数据接收类")
public class TpmDistributionCustomerAuditDataImportDto extends CrmExcelVo {

    /**
     * 业态
     */
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @CrmExcelColumn("销售机构名称")
    private String salesInstitutionName;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("渠道名称")
    private String channelName;

    @ApiModelProperty("产品编码")
    @CrmExcelColumn(value = "产品编码", order = 1)
    private String productCode;

    @ApiModelProperty("产品名称")
    @CrmExcelColumn(value = "产品名称", order = 2)
    private String productName;

    @ApiModelProperty("年月")
    @CrmExcelColumn(value = "年月", order = 3)
    private String distributionCustomerAuditYearMonth;

    @ApiModelProperty("合计销量（箱）")
    @CrmExcelColumn(value = "合计销量（箱）", order = 4)
    private Integer saleQuantity;

    @ApiModelProperty("客户编码")
    @CrmExcelColumn(value = "客户编码", order = 5)
    private String customerCode;

    @ApiModelProperty("客户名称")
    @CrmExcelColumn(value = "客户名称", order = 6)
    private String customerName;

    @ApiModelProperty("平台")
    @CrmExcelColumn(value = "平台", order = 7)
    private String platformName;

    @ApiModelProperty("备案店铺名")
    @CrmExcelColumn(value = "备案店铺名", order = 8)
    private String storeName;

    public boolean validate(){
        return StringUtils.isNotEmpty(this.productCode)
                && StringUtils.isNotEmpty(this.distributionCustomerAuditYearMonth) && this.saleQuantity != null
                && StringUtils.isNotEmpty(this.customerCode)
                && StringUtils.isNotEmpty(this.businessFormatCode)
                && StringUtils.isNotEmpty(this.salesInstitutionCode)
                && StringUtils.isNotEmpty(this.channelCode);
    }

}
