package com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataImportDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import org.springframework.data.domain.Pageable;

import java.util.LinkedHashMap;
import java.util.List;

/**
 * @ClassName TpmDistributionCustomerAuditDataService
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/17
 */
public interface TpmDistributionCustomerAuditDataService {

    /**
     * 分页查询接口
     * @param pageable
	 * @param dto
     * @author jiangyin
     * @date 2023/1/3 15:12
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo>
     */
    Page<TpmDistributionCustomerAuditDataRespVo> findByConditions(Pageable pageable, TpmDistributionCustomerAuditDataDto dto);

    /**
     * 按条件查询
     *
     * @param dto
     * @return
     */
    List<TpmDistributionCustomerAuditDataRespVo> findListByConditions(TpmDistributionCustomerAuditDataDto dto);

    /**
     * 按主键列表删除
     * @param ids
     * @author jiangyin
     * @date 2023/1/3 15:12
     * @return void
     */
    void delete(List<String> ids);

    /**
     * 保存导入数据
     * @author jiangyin
     * @date 2023/1/3 15:13
     * @return void
     */
    void saveImport(List<TpmDistributionCustomerAuditDataDto> entitySaveList, List<TpmDistributionCustomerAuditDataDto> entityUpdateList);

    /**
     * 指标查询数据
     * @param dto
     * @return
     */
    List<TpmDistributionCustomerAuditDataRespVo> listForVariable(TpmDistributionCustomerAuditDataImportDto dto);

    void calculateLogisticCost(TpmDistributionCustomerAuditDataDto dto);

    /**
     * 根据条件获取获取月销售数据同步
     *
     * @param dto
     */
    void getObtainMonthlySales(TpmDistributionCustomerAuditDataDto dto);

    /**
     * 获取合计销量
     *
     * @param dto
     */
    void getSaleQuantity(TpmDistributionCustomerAuditDataDto dto);

    /**
     * 根据条件查产品信息
     *
     * @param customerAuditDataDto
     * @return
     */
    List<TpmDistributionCustomerAuditDataRespVo> findProductListByConditions(TpmDistributionCustomerAuditDataDto customerAuditDataDto);
}
