package com.biz.crm.tpm.business.distribution.customer.month.sale.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.third.system.sdk.constants.CeConstant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description: 电商日销售数据
 * @Author: dengwei
 * @Date: 2023/2/15 0:44
 * @Version: 1.0
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = RocketMqUtil.ORDER + "${rocketmq.topic}" + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = CeConstant.SEND_DISTRIBUTION_CUSTOMER_MONTH_SALE_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = CeConstant.SEND_DISTRIBUTION_CUSTOMER_MONTH_SALE_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.ORDERLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class CeSalesDataDistributionConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService distributionCustomerMonthSaleService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("=====>    分销客户月度销售接受到日销售数据[{}]    <=====", JSON.toJSONString(message));
        if (StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        distributionCustomerMonthSaleService.pullData(message.getMsgBody());
        return "消费成功";
    }


}
