package com.biz.crm.tpm.business.distribution.customer.month.sale.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @ClassName TpmDistributionCustomerMonthSaleController
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/16
 */
@RestController
@RequestMapping("/v1/distribution/customer/month/sale")
@Slf4j
@Api(tags = "TPM-客户月度销售数据管理")
public class TpmDistributionCustomerMonthSaleController {

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    /**
     * 根据条件查询分页数据
     * @param pageable 分页参数
	 * @param dto 查询条件
     * @author jiangyin
     * @date 2022/11/17 14:30
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.DistributionCustomerMonthSaleRespVo>>
     */
    @PostMapping("findByConditions")
    @ApiOperation(value = "客户月度销售数据管理分页查询", notes = "")
    public Result<Page<TpmDistributionCustomerMonthSaleRespVo>> findByConditions(Pageable pageable, @RequestBody TpmDistributionCustomerMonthSaleDto dto){
        try {
            //默认查询未删除数据
            if(StringUtils.isEmpty(dto.getDelFlag())){
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            return Result.ok(tpmDistributionCustomerMonthSaleService.findByConditions(pageable, dto));
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 还原分销客户月度销售数据
     * @param dto
     * @author jiangyin
     * @date 2022/11/17 14:31
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     */
    @PostMapping("saleDataReset")
    @ApiOperation(value = "客户月度销售数据管理-销售数据还原", notes = "")
    public Result<?> saleDataReset(@RequestBody TpmDistributionCustomerMonthSaleDto dto){
        try {
            tpmDistributionCustomerMonthSaleService.saleDataResetNew(dto);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @PostMapping("manualPullMonthSaleData")
    @ApiOperation(value = "重新拉取指定年月的月度销售数据", notes = "")
    public Result<?> manualPullMonthSaleData(@RequestBody TpmDistributionCustomerMonthSaleDto dto){
        try {
            tpmDistributionCustomerMonthSaleService.pullData(dto.getDistributionCustomerMonthSaleYearMonth());
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
