package com.biz.crm.tpm.business.distribution.customer.month.sale.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName TpmDistributionCustomerMonthSaleEntity
 * @description 分销客户月度销售实体类
 * @author jiangyin
 * @date 2023/1/4
 */
@ApiModel(value = "TpmDistributionCustomerMonthSaleEntity", description = "TPM-分销客户月度销售实体类")
@TableName("tpm_distribution_customer_month_sale")
@Getter
@Setter
@Entity(name = "tpm_distribution_customer_month_sale")
@org.hibernate.annotations.Table(appliesTo = "tpm_distribution_customer_month_sale", comment = "TPM-对账要素")
@Table(name = "tpm_distribution_customer_month_sale", indexes = {
        @Index(name = "product_code_index", columnList = "product_code"),
        @Index(name = "customer_code_index", columnList = "customer_code"),
        @Index(name = "tpm_distribution_customer_month_sale_index1", columnList = "verify_code"),
})
public class TpmDistributionCustomerMonthSaleEntity extends TenantFlagOpEntity {

    @ApiModelProperty(value = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 64, columnDefinition = "varchar(20) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(value = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 200, columnDefinition = "varchar(20) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(value = "是否试销期", notes = "")
    @Column(name = "is_test_market", nullable = true, length = 1, columnDefinition = "varchar(1) COMMENT '是否试销期'")
    private String isTestMarket;

    @ApiModelProperty(value = "客户等级", notes = "")
    @Column(name = "customer_level", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '客户等级'")
    private String customerLevel;

    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "distribution_customer_month_sale_year_month", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '年月'")
    private String distributionCustomerMonthSaleYearMonth;

    @ApiModelProperty(value = "产品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(value = "产品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 200, columnDefinition = "varchar(200) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(value = "供货价（元）", notes = "")
    @Column(name = "supply_price", nullable = true, precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '供货价（元）'")
    private BigDecimal supplyPrice;

    @ApiModelProperty(value = "月度总销量（箱）", notes = "")
    @Column(name = "month_sale_quantity", nullable = true, length = 16, columnDefinition = "varchar(20) COMMENT '月度总销量（箱）'")
    private Integer monthSaleQuantity;

    @ApiModelProperty(value = "月度总销售金额（元）", notes = "")
    @Column(name = "month_sale_amount", nullable = true, precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '月度总销售金额（元）'")
    private BigDecimal monthSaleAmount;

    @ApiModelProperty(value = "累计总销量（箱）", notes = "")
    @Column(name = "total_sale_quantity", nullable = true, length = 16, columnDefinition = "varchar(20) COMMENT ''")
    private Integer totalSaleQuantity;

    @ApiModelProperty(value = "累计总销售金额（元）", notes = "")
    @Column(name = "total_sale_amount", nullable = true, precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '累计总销售金额（元）'")
    private BigDecimal totalSaleAmount;

    @ApiModelProperty(value = "捆赠销售数量（箱）", notes = "")
    @Column(name = "bound_gift_sale_quantity", nullable = true, length = 16, columnDefinition = "varchar(20) COMMENT '捆赠销售数量（箱）'")
    private Integer boundGiftSaleQuantity;

    @ApiModelProperty(value = "捆赠销售金额（元）", notes = "")
    @Column(name = "bound_gift_sale_amount", nullable = true, precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '捆赠销售金额（元）'")
    private BigDecimal boundGiftSaleAmount;

    @ApiModelProperty(value = "基础销售数量（箱）", notes = "")
    @Column(name = "basic_sale_quantity", nullable = true, length = 16, columnDefinition = "int(26) COMMENT '基础销售数量（箱）'")
    private Integer basicSaleQuantity;

    @ApiModelProperty(value = "基础销售金额（元）", notes = "")
    @Column(name = "basic_sale_amount", nullable = true, precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '基础销售金额（元）'")
    private BigDecimal basicSaleAmount;

    @ApiModelProperty(value = "待匹配数量（箱）", notes = "")
    @Column(name = "wait_match_quantity", nullable = true, length = 16, columnDefinition = "int(26) COMMENT '待匹配数量（箱）'")
    private Integer waitMatchQuantity;

    @ApiModelProperty(value = "待匹配销售金额（元）", notes = "")
    @Column(name = "wait_match_amount", nullable = true, precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '待匹配销售金额（元）'")
    private BigDecimal waitMatchAmount;

    @ApiModelProperty(value = "还原标志", notes = "")
    @Column(name = "revert_flag", nullable = true, length = 1, columnDefinition = "varchar(1) COMMENT '还原标志'")
    private String revertFlag;

    /**
     * 可拆分数量
     */
    @ApiModelProperty("可拆分数量")
    @Column(name = "num_enable", nullable = false, columnDefinition = "INT COMMENT '可拆分数量'")
    private Integer numEnable;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;

    /**
     * 剔除销量
     */
    @ApiModelProperty("剔除销量")
    @Column(name = "rid_sale_quantity", columnDefinition = "decimal(20,6) COMMENT '剔除销量'")
    private BigDecimal ridSaleQuantity;

    /**
     * 剔除金额
     */
    @ApiModelProperty("剔除金额")
    @Column(name = "rid_sale_amount", columnDefinition = "decimal(20,6) COMMENT '剔除金额'")
    private BigDecimal ridSaleAmount;

    /**
     * 手工已核销销量
     */
    @ApiModelProperty("手工已核销销量")
    @Column(name = "manual_audit_sale_quantity", columnDefinition = "decimal(20,6) COMMENT '手工已核销销量'")
    private BigDecimal manualAuditSaleQuantity;

    /**
     * 手工已核销销售额
     */
    @ApiModelProperty("手工已核销销售额")
    @Column(name = "manual_audit_sale_amount", columnDefinition = "decimal(20,6) COMMENT '手工已核销销售额'")
    private BigDecimal manualAuditSaleAmount;

    @ApiModelProperty("唯一字段")
    @Column(name = "verify_code", columnDefinition = "VARCHAR(512) COMMENT '唯一字段'")
    private String verifyCode;

    @ApiModelProperty("分销商年度剔量金额")
    @Column(name = "distributor_annual_amount", precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '分销商年度剔量金额'")
    private BigDecimal distributorAnnualAmount;

    @ApiModelProperty("分销商年度剔量数量")
    @Column(name = "distributor_annual_quantity", precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '分销商年度剔量数量'")
    private BigDecimal distributorAnnualQuantity;

    @ApiModelProperty("上月待匹配数量")
    @Column(name = "last_month_no_matching_quantity", precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '上月待匹配数量'")
    private BigDecimal lastMonthNoMatchingQuantity;

    @ApiModelProperty("上月销售组合数量")
    @Column(name = "last_month_sale_combination_quantity", precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '上月销售组合数量'")
    private BigDecimal lastMonthSaleCombinationQuantity;

    @ApiModelProperty("当月销售组合数量")
    @Column(name = "this_month_sale_combination_quantity", precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '当月销售组合数量'")
    private BigDecimal thisMonthSaleCombinationQuantity;

    @ApiModelProperty("上月基础销售数量")
    @Column(name = "last_month_base_sale_quantity", precision = 16, scale = 6, columnDefinition = "decimal(16,6) COMMENT '上月基础销售数量'")
    private BigDecimal lastMonthBaseSaleQuantity;

    @ApiModelProperty("待匹配自动生成标记")
    @Column(name = "auto_create", columnDefinition = "VARCHAR(10) COMMENT '待匹配自动生成标记（Y或N）'")
    private String autoCreate;
}
