package com.biz.crm.tpm.business.distribution.customer.month.sale.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.entity.TpmDistributionCustomerMonthSaleEntity;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * @ClassName TpmDistributionCustomerMonthSaleEntityMapper
 * @Description
 * @Author: jiangyin
 * @Date 2023/1/4
 */
public interface TpmDistributionCustomerMonthSaleEntityMapper extends BaseMapper<TpmDistributionCustomerMonthSaleEntity> {
    Page<TpmDistributionCustomerMonthSaleRespVo> findByConditions(Page<TpmDistributionCustomerMonthSaleRespVo> page, @Param("vo") TpmDistributionCustomerMonthSaleDto dto);

    Page<TpmDistributionCustomerMonthSaleDto> findUnRevert(Page<TpmDistributionCustomerMonthSaleDto> page, @Param("dto") TpmDistributionCustomerMonthSaleDto dto);

    List<String> findUnRevertProductCodeList(@Param("dto") TpmDistributionCustomerMonthSaleDto dto);

    TpmDistributionCustomerMonthSaleDto findByCustomerCodeAndProductCodeAndYearMonth(@Param("customerCode") String customerCode,
                                                                                     @Param("productCode") String productCode,
                                                                                     @Param("yearMonth") String lastYearMonthStr);

    /**
     * 获取累计销售总金额
     *
     * @param dto 查询参数
     * @return BigDecimal
     */
    BigDecimal getTotalSaleAmount(@Param("dto") TpmDistributionCustomerMonthSaleDto dto);

    /**
     * 获取年度累计销售总金额
     *
     * @param dto 查询参数
     * @return BigDecimal
     */
    BigDecimal getYearTotalSaleAmount(@Param("dto") TpmDistributionCustomerMonthSaleDto dto);

    /**
     * 查询销售信息
     *
     * @param dto
     * @return
     */
    List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSalesByParams(@Param("dto") TpmDistributionCustomerMonthSaleDto dto, @Param("yearMonthType") Integer yearMonthType);

    List<String> findCustomerErpCodeListByProductListAndYearMonth(@Param("productCodeSet") Set<String> productCodeSet,
                                                                  @Param("yearMonth") String distributionCustomerMonthSaleYearMonth,
                                                                  @Param("tenantCode") String tenantCode);

    List<TpmDistributionCustomerMonthSaleEntity> findListByCustomerCodeAndYearMonth(@Param("customerCode") String customerErpCode,
                                                                                    @Param("yearMonth") String yearMonth,
                                                                                    @Param("lastYearMonth") String lastYearMonth,
                                                                                    @Param("tenantCode") String tenantCode);

    /**
     * 根据年月获取客户数据
     *
     * @param yearMonth
     * @param tenantCode
     * @return
     */
    List<TpmDistributionCustomerMonthSaleRespVo> findAllByYearMonth(@Param("yearMonth") String yearMonth, @Param("tenantCode") String tenantCode);

    /**
     * 根据客户信息获取销售信息
     *
     * @param customerMonthSaleDtos
     * @param tenantCode
     * @return
     */
    List<TpmDistributionCustomerMonthSaleRespVo> findByCustomer(@Param("customerMonthSaleDtos") Collection<TpmDistributionCustomerMonthSaleDto> customerMonthSaleDtos,@Param("tenantCode") String tenantCode);

    List<TpmDistributionCustomerMonthSaleEntity> findAutoCreateData(Page page,
                                                                    @Param("yearMonth") String yearMonth,
                                                                    @Param("tenantCode") String tenantCode);
}
