package com.biz.crm.tpm.business.distribution.customer.month.sale.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @ClassName TpmDistributionCustomerMonthSaleRegister
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/16
 */
@Component
@Slf4j
public class TpmDistributionCustomerMonthSaleRegister implements DataviewRegister {
    @Override
    public String code() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String desc() {
        return "TPM-分销客户月度销售数据";
    }

    @Override
    public String buildSql() {
        return "select * from tpm_distribution_customer_month_sale " +
                "where tenant_code = :tenantCode " +
                "and del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
