package com.biz.crm.tpm.business.distribution.customer.month.sale.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.entity.TpmDistributionCustomerMonthSaleEntity;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.mapper.TpmDistributionCustomerMonthSaleEntityMapper;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * @ClassName TpmDistributionCustomerMonthSaleEntityRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/1/4
 */
@Component
public class TpmDistributionCustomerMonthSaleEntityRepository extends ServiceImpl<TpmDistributionCustomerMonthSaleEntityMapper, TpmDistributionCustomerMonthSaleEntity> {


    public List<TpmDistributionCustomerMonthSaleEntity> findByVerifyCodeList(List<String> verifyCodeList) {
        if (CollectionUtil.isEmpty(verifyCodeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(TpmDistributionCustomerMonthSaleEntity::getVerifyCode, verifyCodeList)
                .list();
    }

    public List<TpmDistributionCustomerMonthSaleEntity> findDistributionCustomerMonthSale(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSaleDto) {
        return this.baseMapper
                .selectList(Wrappers.lambdaQuery(TpmDistributionCustomerMonthSaleEntity.class)
                        .eq(TpmDistributionCustomerMonthSaleEntity::getCustomerCode, distributionCustomerMonthSaleDto.getCustomerCode())
                        .eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, distributionCustomerMonthSaleDto.getDistributionCustomerMonthSaleYearMonth()));
    }

    /**
     * 查询销售总额
     *
     * @param distributionCustomerMonthSale 查询条件
     * @return BigDecimal
     */
    public BigDecimal getTotalSaleAmount(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale) {

        BigDecimal totalSaleAmount = this.baseMapper.getTotalSaleAmount(distributionCustomerMonthSale);

        return (totalSaleAmount != null && totalSaleAmount.compareTo(BigDecimal.ZERO) > 0)
                ? totalSaleAmount
                : BigDecimal.ZERO;
    }

    /**
     * 查询年销售总额
     *
     * @param dto 查询参数
     * @return BigDecimal
     */
    public BigDecimal getYearTotalSaleAmount(TpmDistributionCustomerMonthSaleDto dto) {

        BigDecimal yearTotalSaleAmount = this.baseMapper.getYearTotalSaleAmount(dto);

        return (yearTotalSaleAmount != null && yearTotalSaleAmount.compareTo(BigDecimal.ZERO) > 0)
                ? yearTotalSaleAmount
                : BigDecimal.ZERO;
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSalesByParams(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale) {

        String distributionCustomerMonthSaleYearMonth = distributionCustomerMonthSale.getDistributionCustomerMonthSaleYearMonth();
        Integer yearMonthType = (distributionCustomerMonthSaleYearMonth.length() == 4) ? 0 : 1;
        return this.baseMapper.findCustomerMonthSalesByParams(distributionCustomerMonthSale, yearMonthType);
    }

    public List<String> findCustomerErpCodeListByProductListAndYearMonth(Set<String> productCodeSet, String distributionCustomerMonthSaleYearMonth) {
        return this.baseMapper.findCustomerErpCodeListByProductListAndYearMonth(productCodeSet, distributionCustomerMonthSaleYearMonth, TenantUtils.getTenantCode());
    }

    public List<TpmDistributionCustomerMonthSaleEntity> findListByCustomerCodeAndYearMonth(String customerErpCode, String distributionCustomerMonthSaleYearMonth) {
        String lastYearMonth = DateUtil.formatAddMonth(distributionCustomerMonthSaleYearMonth + "-01", DateUtil.DEFAULT_YEAR_MONTH_DAY, -1).substring(0, 7);
        return this.baseMapper.findListByCustomerCodeAndYearMonth(customerErpCode, distributionCustomerMonthSaleYearMonth, lastYearMonth, TenantUtils.getTenantCode());
    }

    public List<TpmDistributionCustomerMonthSaleEntity> findByYearMonth(String distributionCustomerMonthSaleYearMonth) {
        return this.lambdaQuery()
                .eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, distributionCustomerMonthSaleYearMonth)
                .eq(TpmDistributionCustomerMonthSaleEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDistributionCustomerMonthSaleEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findAllByYearMonth(String distributionCustomerMonthSaleYearMonth) {
        return this.baseMapper.findAllByYearMonth(distributionCustomerMonthSaleYearMonth, TenantUtils.getTenantCode());
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findByCustomer(Collection<TpmDistributionCustomerMonthSaleDto> customerMonthSaleDtos) {
        return this.baseMapper.findByCustomer(customerMonthSaleDtos, TenantUtils.getTenantCode());
    }

    public List<TpmDistributionCustomerMonthSaleEntity> findAutoCreateData(String yearMonth, Page page) {
        return this.baseMapper.findAutoCreateData(page, yearMonth, TenantUtils.getTenantCode());
    }

    public void deleteAutoCreateData(String yearMonth) {
        this.lambdaUpdate()
                .eq(TpmDistributionCustomerMonthSaleEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmDistributionCustomerMonthSaleEntity::getAutoCreate, YesOrNoEnum.YES.getCode())
                .eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, yearMonth)
                .remove();
    }

    public List<TpmDistributionCustomerMonthSaleEntity> listForSplitCustomer(TpmDistributionCustomerMonthSaleDto dto) {
        return this.lambdaQuery()
                .eq(TpmDistributionCustomerMonthSaleEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDistributionCustomerMonthSaleEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, dto.getDistributionCustomerMonthSaleYearMonth())
                .in(TpmDistributionCustomerMonthSaleEntity::getCustomerCode, dto.getCustomerCodeList())
                .list();
    }
}
