package com.biz.crm.tpm.business.distribution.customer.month.sale.local.service.impl;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-28
 */
@Slf4j
@Service
public class TpmDistributionCustomerMonthSalePendingXxlJob {

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    @DynamicTaskService(cornExpression = "0 0 1 1 * ?", taskDesc = "分销客户月度销售表-根据上月待匹配数据自动生成数据")
    public void executeJob() {
        loginUserService.refreshAuthentication(null);
        log.info("分销客户月度销售表-根据上月待匹配数据自动生成数据 start ===> {}", DateUtil.dateStrNowAll());
        String lockKey = "TpmDistributionCustomerMonthSalePendingXxlJob" + DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
        try {
            boolean locked = redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12, 5);
            Validate.isTrue(locked, "执行中...");
            String yearMonth = DateUtil.format(new Date(),DateUtil.DEFAULT_YEAR_MONTH);
            Integer count = tpmDistributionCustomerMonthSaleService.autoGenerateData(yearMonth);
            log.info("分销客户月度销售表-根据上月待匹配数据自动生成数据 数量 ===> {}", count);
        } catch (Exception e) {
            log.error("分销客户月度销售表-根据上月待匹配数据自动生成数据 异常 ===> {}，{}", DateUtil.dateStrNowAll(), e.getMessage());
        } finally {
            redisLockService.unlock(lockKey);
        }
        log.info("分销客户月度销售表-根据上月待匹配数据自动生成数据 end ===> {}", DateUtil.dateStrNowAll());
    }
}
