package com.biz.crm.tpm.business.distribution.customer.month.sale.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.entity.TpmDistributionCustomerMonthSaleEntity;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.mapper.TpmDistributionCustomerMonthSaleEntityMapper;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.repository.TpmDistributionCustomerMonthSaleEntityRepository;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.constants.DistributionCustomerMonthSaleConstants;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.promotion.policy.sdk.service.PromotionPolicyService;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyProductVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jodd.util.CharSequenceUtil;
import liquibase.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @ClassName TpmDistributionCustomerMonthSaleServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/16
 */
@Service
@Slf4j
public class TpmDistributionCustomerMonthSaleServiceImpl implements TpmDistributionCustomerMonthSaleService {

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleEntityMapper tpmDistributionCustomerMonthSaleEntityMapper;

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleEntityRepository tpmDistributionCustomerMonthSaleEntityRepository;

    @Autowired(required = false)
    private PromotionPolicyService promotionPolicyService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private Ce1MnjtSdkService ce1MnjtSdkService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private PriceModelVoService priceModelVoService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    private static final String BUSINESS_MODEL_CODE = "distribution_mode";

    @Override
    public Page<TpmDistributionCustomerMonthSaleRespVo> findByConditions(Pageable pageable, TpmDistributionCustomerMonthSaleDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        Page<TpmDistributionCustomerMonthSaleRespVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return tpmDistributionCustomerMonthSaleEntityMapper.findByConditions(page, dto);
    }

    @Override
    public void saleDataReset(TpmDistributionCustomerMonthSaleDto dto) {
        String rule = "\\d{4}-\\d{2}";
        if (!Pattern.matches(rule, dto.getDistributionCustomerMonthSaleYearMonth())) {
            return;
        }
        List<TpmDistributionCustomerMonthSaleEntity> modifyList = new ArrayList<>();
        //改为分页查询数据
        int pageNum = 0;
        int pageSize = 1000;
        Page<TpmDistributionCustomerMonthSaleDto> page = new Page<>(pageNum, pageSize);
        //获取未还原的分销客户销售数据
        Page<TpmDistributionCustomerMonthSaleDto> dtoPage = tpmDistributionCustomerMonthSaleEntityMapper.findUnRevert(page, dto);
        while (CollectionUtils.isNotEmpty(dtoPage.getRecords())) {
            List<TpmDistributionCustomerMonthSaleDto> dtoList = dtoPage.getRecords();
            //初始化默认值
            for (TpmDistributionCustomerMonthSaleDto monthSaleDto : dtoList) {
                if (monthSaleDto.getManualAuditSaleQuantity() == null) {
                    monthSaleDto.setManualAuditSaleQuantity(BigDecimal.ZERO);
                }
                if (monthSaleDto.getManualAuditSaleAmount() == null) {
                    monthSaleDto.setManualAuditSaleAmount(BigDecimal.ZERO);
                }
            }
            //获取还原数据里全部的产品编码
            List<String> totalProductCodeList = new ArrayList<>(dtoList.stream().map(TpmDistributionCustomerMonthSaleDto::getProductCode).collect(Collectors.toSet()));
            //根据产品编码列表获取促销政策中促销类型为捆赠的促销政策
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.MONTH, -1);
            String lastMonth = DateUtil.format(calendar.getTime(), "yyyy-MM-dd");
            //获取到全部产品的促销政策
            List<PromotionPolicyProductVO> productPromotionPolicyList = promotionPolicyService.findForDistributionCustomerMonthSale(totalProductCodeList, lastMonth);
            //促销政策根据产品编码进行汇总，并按优先级排序
            Map<String, List<PromotionPolicyProductVO>> productPromotionPolicyMapByProductCode = productPromotionPolicyList.stream()
                    .collect(Collectors.groupingBy(PromotionPolicyProductVO::getProductCode));
            for (Map.Entry<String, List<PromotionPolicyProductVO>> entry : productPromotionPolicyMapByProductCode.entrySet()) {
                if (CollectionUtils.isNotEmpty(entry.getValue())) {
                    entry.setValue(entry.getValue().stream().sorted(Comparator.comparing(PromotionPolicyProductVO::getPriorityLevel)).collect(Collectors.toList()));
                }
            }
            //遍历月度销售数据和促销政策数据，月度销售补充促销政策
            for (TpmDistributionCustomerMonthSaleDto monthSaleDto : dtoList) {
                if (CollectionUtils.isNotEmpty(productPromotionPolicyMapByProductCode.get(monthSaleDto.getProductCode()))) {
                    monthSaleDto.setPromotionPolicyCode(productPromotionPolicyMapByProductCode.get(monthSaleDto.getProductCode()).get(0).getPromotionCode());
                }
            }
            //转换数据格式
            Map<String, List<TpmDistributionCustomerMonthSaleDto>> monthSaleMap = dtoList.stream()
                    .collect(Collectors.groupingBy((TpmDistributionCustomerMonthSaleDto o) -> o.getCustomerCode() + (o.getPromotionPolicyCode() == null ? "" : o.getPromotionPolicyCode()), Collectors.toList()));
            Map<String, List<PromotionPolicyProductVO>> productPromotionPolicyMap = productPromotionPolicyList.stream()
                    .collect(Collectors.groupingBy(PromotionPolicyProductVO::getPromotionCode));
            //遍历map，执行处理逻辑
            for (Map.Entry<String, List<TpmDistributionCustomerMonthSaleDto>> entry : monthSaleMap.entrySet()) {
                String customerCode = entry.getValue().get(0).getCustomerCode();
                //key等于客户编码，说明没有匹配促销政策
                if (customerCode.equals(entry.getKey())) {
                    for (TpmDistributionCustomerMonthSaleDto monthSaleDto : entry.getValue()) {
                        monthSaleDto.setBasicSaleAmount(monthSaleDto.getMonthSaleAmount());
                        monthSaleDto.setTotalSaleAmount(monthSaleDto.getMonthSaleAmount());
                        //还原
                        BigDecimal restoreBasicSaleQuantity = new BigDecimal(monthSaleDto.getMonthSaleQuantity()).subtract(monthSaleDto.getManualAuditSaleQuantity()).setScale(2, BigDecimal.ROUND_DOWN);
                        monthSaleDto.setBasicSaleQuantity(restoreBasicSaleQuantity.intValue());
                        monthSaleDto.setTotalSaleQuantity(restoreBasicSaleQuantity.intValue());
                        monthSaleDto.setRevertFlag(BooleanEnum.TRUE.getCapital());
                    }
                }
                //有匹配的政策
                else {
                    String promotionPolicyCode = entry.getValue().get(0).getPromotionPolicyCode();
                    List<PromotionPolicyProductVO> customerProductPromotionPolicyList = productPromotionPolicyMap.get(promotionPolicyCode);
                    String cumulative = customerProductPromotionPolicyList.get(0).getCumulative();
                    int minBoundGiftQuantity = 0;
                    //政策中“是否累计”字段为否，则累计销售数量等于月度销售数量，累计销售金额等于月度销售金额
                    if (BooleanEnum.FALSE.getCapital().equals(cumulative)) {
                        //用累计销售数量除以捆赠政策系数（向下取整），得出的最小数据作为捆赠基数
                        minBoundGiftQuantity = getMinBoundGiftQuantity(entry, customerProductPromotionPolicyList);
                        for (TpmDistributionCustomerMonthSaleDto monthSaleDto : dtoList) {
                            //以捆赠销售数量*供货价得出捆赠销售金额
                            monthSaleDto.setBoundGiftSaleQuantity(minBoundGiftQuantity);
                            monthSaleDto.setBoundGiftSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBoundGiftSaleQuantity())));
                            //基础销售数量=累计销售数量-捆赠销售数量
                            monthSaleDto.setBasicSaleQuantity(monthSaleDto.getMonthSaleQuantity() - monthSaleDto.getBoundGiftSaleQuantity());
                            //基础销售金额=基础销售数量*供货价
                            monthSaleDto.setBasicSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBasicSaleQuantity())));
                            //待匹配数量、待匹配销售金额为0
                            monthSaleDto.setWaitMatchAmount(BigDecimal.ZERO);
                            monthSaleDto.setWaitMatchQuantity(0);
                            monthSaleDto.setRevertFlag(BooleanEnum.TRUE.getCapital());
                            //还原
                            BigDecimal restoreSaleQuantity = new BigDecimal(monthSaleDto.getMonthSaleQuantity()).subtract(monthSaleDto.getManualAuditSaleQuantity());
                            monthSaleDto.setTotalSaleQuantity(restoreSaleQuantity.intValue());
                            monthSaleDto.setTotalSaleAmount(restoreSaleQuantity);
                        }
                    }
                    //政策中“是否累计”字段为是，则累计销售数量等于月度销售数量，累计销售金额等于月度销售金额
                    else {
                        //第一轮循环，查询是否有上月数据
                        for (TpmDistributionCustomerMonthSaleDto monthSaleDto : entry.getValue()) {
                            //取该条数据的上月数据
                            String translateDate = monthSaleDto.getDistributionCustomerMonthSaleYearMonth() + "-01";
                            Calendar calendar1 = Calendar.getInstance();
                            calendar1.setTime(DateUtil.parse(translateDate, DateUtil.DEFAULT_YEAR_MONTH_DAY));
                            calendar1.add(Calendar.MONTH, -1);
                            String lastYearMonthStr = DateUtil.format(calendar1.getTime(), "yyyy-MM-dd");
                            TpmDistributionCustomerMonthSaleDto lastMonthSaleDto = tpmDistributionCustomerMonthSaleEntityMapper.findByCustomerCodeAndProductCodeAndYearMonth(customerCode, monthSaleDto.getProductCode(), lastYearMonthStr);
                            //有上月数据
                            if (lastMonthSaleDto != null) {
                                //将上月的待匹配加入月销售数据的累计销售数据
                                //monthSaleDto.setTotalSaleQuantity(monthSaleDto.getTotalSaleQuantity() + lastMonthSaleDto.getWaitMatchQuantity());
                                //还原
                                BigDecimal restoreTotalSaleQuantity = new BigDecimal(monthSaleDto.getMonthSaleQuantity())
                                        .subtract(monthSaleDto.getManualAuditSaleQuantity())
                                        .add(new BigDecimal(lastMonthSaleDto.getWaitMatchQuantity()));
                                monthSaleDto.setTotalSaleQuantity(restoreTotalSaleQuantity.intValue());
                                monthSaleDto.setTotalSaleAmount(monthSaleDto.getTotalSaleAmount().add(lastMonthSaleDto.getWaitMatchAmount()));
                            }
                        }
                        //第二轮循环，确定基数
                        minBoundGiftQuantity = getMinBoundGiftQuantity(entry, customerProductPromotionPolicyList);
                        //第三轮循环，根据业务逻辑赋值
                        for (TpmDistributionCustomerMonthSaleDto monthSaleDto : dtoList) {
                            //判断是否是促销政策的最后一月，若是最后一月，处理方式同不累计
                            Optional<PromotionPolicyProductVO> productPromotionPolicy = customerProductPromotionPolicyList.stream().filter(o -> o.getProductCode().equals(monthSaleDto.getProductCode())).findFirst();
                            if (productPromotionPolicy.isPresent() && monthSaleDto.getDistributionCustomerMonthSaleYearMonth().equals(DateUtil.format(productPromotionPolicy.get().getBindEndDate(), "yyyy-MM"))) {
                                //以捆赠销售数量*供货价得出捆赠销售金额
                                monthSaleDto.setBoundGiftSaleQuantity(minBoundGiftQuantity);
                                monthSaleDto.setBoundGiftSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBoundGiftSaleQuantity())));
                                //基础销售数量=累计销售数量-捆赠销售数量
                                monthSaleDto.setBasicSaleQuantity(monthSaleDto.getMonthSaleQuantity() - monthSaleDto.getBoundGiftSaleQuantity());
                                //基础销售金额=基础销售数量*供货价
                                monthSaleDto.setBasicSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBasicSaleQuantity())));
                                //待匹配数量、待匹配销售金额为0
                                monthSaleDto.setWaitMatchAmount(BigDecimal.ZERO);
                                monthSaleDto.setWaitMatchQuantity(0);
                                monthSaleDto.setRevertFlag(BooleanEnum.TRUE.getCapital());
                            } else if (productPromotionPolicy.isPresent() && !monthSaleDto.getDistributionCustomerMonthSaleYearMonth().equals(DateUtil.format(productPromotionPolicy.get().getBindEndDate(), "yyyy-MM"))) {
                                //以捆赠销售数量*供货价得出捆赠销售金额
                                monthSaleDto.setBoundGiftSaleQuantity(minBoundGiftQuantity);
                                monthSaleDto.setBoundGiftSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBoundGiftSaleQuantity())));
                                monthSaleDto.setWaitMatchQuantity(minBoundGiftQuantity);
                                //待匹配销售数量=累计销售数量-捆赠销售数量
                                monthSaleDto.setWaitMatchQuantity(monthSaleDto.getMonthSaleQuantity() - monthSaleDto.getBoundGiftSaleQuantity());
                                //待匹配销售金额=基础销售数量*供货价
                                monthSaleDto.setWaitMatchAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBasicSaleQuantity())));
                                //基础数量、基础销售金额为0
                                monthSaleDto.setBasicSaleAmount(BigDecimal.ZERO);
                                monthSaleDto.setBasicSaleQuantity(0);
                                monthSaleDto.setRevertFlag(BooleanEnum.TRUE.getCapital());
                            }
                        }
                    }
                }
            }
            modifyList.addAll(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(dtoList, TpmDistributionCustomerMonthSaleDto.class, TpmDistributionCustomerMonthSaleEntity.class, LinkedHashSet.class, ArrayList.class)));
            if (page.hasNext()) {
                pageNum++;
                page = new Page<>(pageNum, pageSize);
                //获取未还原的分销客户销售数据
                dtoPage = tpmDistributionCustomerMonthSaleEntityMapper.findUnRevert(page, dto);
            } else {
                break;
            }
        }
        tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(modifyList);
    }

    @Override
    public void saleDataResetNew(TpmDistributionCustomerMonthSaleDto dto) {
        List<TpmDistributionCustomerMonthSaleEntity> result = new ArrayList<>();
        Set<String> finalProductCodeList = new HashSet<>();
        //根据年月第一天取全部的政策
        List<PromotionPolicyVO> promotionPolicyVOList = promotionPolicyService.findListByYearMonth(dto.getDistributionCustomerMonthSaleYearMonth());
        for (PromotionPolicyVO policy : promotionPolicyVOList) {
            if (dto.getDistributionCustomerMonthSaleYearMonth().compareTo(DateUtil.format(policy.getBindEndDate(), DateUtil.DEFAULT_YEAR_MONTH)) > -1) {
                finalProductCodeList.addAll(policy.getPromotionPolicyProducts().stream().map(PromotionPolicyProductVO::getProductCode).collect(Collectors.toSet()));
            }
        }
        promotionPolicyVOList = promotionPolicyVOList.stream().sorted(Comparator.comparing(PromotionPolicyVO::getPriorityLevel)).collect(Collectors.toList());
        //无政策，直接填值返回
        if (CollectionUtils.isEmpty(promotionPolicyVOList)) {
            List<TpmDistributionCustomerMonthSaleEntity> monthSaleList = tpmDistributionCustomerMonthSaleEntityRepository.findByYearMonth(dto.getDistributionCustomerMonthSaleYearMonth());
            for (TpmDistributionCustomerMonthSaleEntity entity : monthSaleList) {
                //获取平台供货价
                Set<String> productCodeSet = new HashSet<>();
                productCodeSet.add(entity.getProductCode());
                Map<String, PriceModelVo> priceModelVoMap = getPlatformSupplyPrice(entity.getCustomerCode(), productCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
                //还原
                if (entity.getManualAuditSaleQuantity() == null) {
                    entity.setManualAuditSaleQuantity(BigDecimal.ZERO);
                }
                BigDecimal restoreBasicSaleQuantity = new BigDecimal(entity.getMonthSaleQuantity()).subtract(entity.getManualAuditSaleQuantity()).setScale(2, BigDecimal.ROUND_DOWN);
                entity.setBasicSaleQuantity(restoreBasicSaleQuantity.intValue());
                entity.setTotalSaleQuantity(restoreBasicSaleQuantity.intValue());
                if (priceModelVoMap != null && priceModelVoMap.get(entity.getProductCode()) != null && priceModelVoMap.get(entity.getProductCode()).getPrice() != null) {
                    entity.setSupplyPrice(priceModelVoMap.get(entity.getProductCode()).getPrice());
                    entity.setBasicSaleAmount(restoreBasicSaleQuantity.multiply(entity.getSupplyPrice()));
                    entity.setTotalSaleAmount(restoreBasicSaleQuantity.multiply(entity.getSupplyPrice()));
                }
//                entity.setRevertFlag(BooleanEnum.TRUE.getCapital());
            }
            tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(monthSaleList);
            setNewDate(dto);
            return;
        }
        List<PromotionPolicyProductVO> policyProductVOList = new ArrayList<>();
        for (PromotionPolicyVO policy : promotionPolicyVOList) {
            policyProductVOList.addAll(policy.getPromotionPolicyProducts());
        }
        if (CollectionUtils.isEmpty(policyProductVOList)) {
            return;
        }
        //根据年月+产品，先获取分销客户月度销售数据中的客户信息
        Set<String> policyProductCodeSet = policyProductVOList.stream().map(PromotionPolicyProductVO::getProductCode).collect(Collectors.toSet());
        List<String> customerErpCodeList = tpmDistributionCustomerMonthSaleEntityRepository.findCustomerErpCodeListByProductListAndYearMonth(policyProductCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
        //对每个客户的月度销售数据，分别进行政策的计算
        for (String customerErpCode : customerErpCodeList) {
            List<TpmDistributionCustomerMonthSaleEntity> monthSaleEntityList = tpmDistributionCustomerMonthSaleEntityRepository.findListByCustomerCodeAndYearMonth(customerErpCode, dto.getDistributionCustomerMonthSaleYearMonth());
            if (CollectionUtils.isEmpty(monthSaleEntityList)) {
                continue;
            }
            //循环一遍，设置好累计销售量，需要处理上个月待匹配的数据，处理完后将待匹配置0
            for (TpmDistributionCustomerMonthSaleEntity entity : monthSaleEntityList) {
                if (entity.getManualAuditSaleQuantity() == null) {
                    entity.setManualAuditSaleQuantity(BigDecimal.ZERO);
                }
                if (entity.getWaitMatchQuantity() == null) {
                    entity.setWaitMatchQuantity(0);
                }
                entity.setTotalSaleQuantity(new BigDecimal(entity.getMonthSaleQuantity()).subtract(entity.getManualAuditSaleQuantity()).add(new BigDecimal(entity.getWaitMatchQuantity())).intValue());
                entity.setWaitMatchQuantity(0);
            }
            Map<String, TpmDistributionCustomerMonthSaleEntity> monthSaleMap = monthSaleEntityList.stream().collect(Collectors.toMap(TpmDistributionCustomerMonthSaleEntity::getProductCode, Function.identity()));
            Map<String, Integer> monthSaleRemainMap = monthSaleEntityList.stream().collect(Collectors.toMap(TpmDistributionCustomerMonthSaleEntity::getProductCode, TpmDistributionCustomerMonthSaleEntity::getTotalSaleQuantity));
            Optional<PromotionPolicyVO> policyOptional = promotionPolicyVOList.stream().filter(o -> BooleanEnum.TRUE.getCapital().equals(o.getCumulative())).findAny();
            //有一个政策是累计，则全部按累计处理
            if (policyOptional.isPresent()) {
                Set<String> usedProductCodeSet = new HashSet<>();
                //政策已经排序，直接循环
                for (PromotionPolicyVO policy : promotionPolicyVOList) {
                    int minNum = 0;
                    if (CollectionUtils.isNotEmpty(policy.getPromotionPolicyProducts())) {
                        int counter = 0;
                        //第一次循环，确定最小数量
                        for (PromotionPolicyProductVO policyProductVO : policy.getPromotionPolicyProducts()) {
                            usedProductCodeSet.add(policyProductVO.getProductCode());
                            Integer remainNum = monthSaleRemainMap.get(policyProductVO.getProductCode());
                            //任一产品没有月度销售数据，直接将最小捆赠系数归0，并跳出循环
                            if (remainNum == null) {
                                minNum = 0;
                                break;
                            }
                            if (counter == 0 || minNum > remainNum / policyProductVO.getBindingCoefficient()) {
                                minNum = remainNum / policyProductVO.getBindingCoefficient();
                            }
                            counter++;
                        }
                        //第二次循环，根据最小数量+捆赠系数，计算政策实际占用产品数
                        if (minNum != 0) {
                            for (PromotionPolicyProductVO policyProductVO : policy.getPromotionPolicyProducts()) {
                                String productCode = policyProductVO.getProductCode();
                                monthSaleRemainMap.put(productCode, monthSaleRemainMap.get(productCode) - minNum * policyProductVO.getBindingCoefficient());
                            }
                        }
                    }
                }
                //政策占用完毕，根据剩余数量和累计待匹配数量，计算捆赠销售数量和待匹配数量
                for (Map.Entry<String, TpmDistributionCustomerMonthSaleEntity> entry : monthSaleMap.entrySet()) {
                    if (usedProductCodeSet.contains(entry.getKey())) {
                        String productCode = entry.getKey();
                        Integer remainNum = monthSaleRemainMap.get(productCode);
                        TpmDistributionCustomerMonthSaleEntity entity = entry.getValue();
                        if (finalProductCodeList.contains(productCode)) {
                            entity.setWaitMatchQuantity(0);
                            entity.setBasicSaleQuantity(remainNum);
                        } else {
                            entity.setWaitMatchQuantity(remainNum);
                            entity.setBasicSaleQuantity(0);
                        }
                        entity.setBoundGiftSaleQuantity(entity.getTotalSaleQuantity() - remainNum);
                        //获取平台供货价
                        Set<String> productCodeSet = new HashSet<>();
                        productCodeSet.add(productCode);
                        Map<String, PriceModelVo> priceModelVoMap = getPlatformSupplyPrice(customerErpCode, productCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
                        if (priceModelVoMap != null && priceModelVoMap.get(entity.getProductCode()) != null && priceModelVoMap.get(entity.getProductCode()).getPrice() != null) {
                            BigDecimal price = priceModelVoMap.get(productCode).getPrice();
                            entity.setSupplyPrice(price);
                            entity.setTotalSaleAmount(price.multiply(new BigDecimal(entity.getTotalSaleQuantity())));
                            entity.setBoundGiftSaleAmount(price.multiply(new BigDecimal(entity.getBoundGiftSaleQuantity())));
                            entity.setBasicSaleAmount(price.multiply(new BigDecimal(entity.getBasicSaleQuantity())));
                            entity.setWaitMatchAmount(price.multiply(new BigDecimal(entity.getWaitMatchQuantity())));
//                            entity.setRevertFlag(BooleanEnum.TRUE.getCapital());
                        }
                        result.add(entity);
                    }
                }
                //政策不涉及的产品，需将累计待匹配数量，填入基础销售量中
                List<TpmDistributionCustomerMonthSaleEntity> unUsedEntity = monthSaleEntityList.stream().filter(o -> !usedProductCodeSet.contains(o.getProductCode())).collect(Collectors.toList());
                for (TpmDistributionCustomerMonthSaleEntity entity : unUsedEntity) {
                    entity.setBoundGiftSaleQuantity(0);
                    entity.setBasicSaleQuantity(entity.getTotalSaleQuantity());
                    entity.setWaitMatchQuantity(0);
//                    entity.setRevertFlag(BooleanEnum.TRUE.getCapital());
                    //获取平台供货价
                    Set<String> productCodeSet = new HashSet<>();
                    productCodeSet.add(entity.getProductCode());
                    Map<String, PriceModelVo> priceModelVoMap = getPlatformSupplyPrice(customerErpCode, productCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
                    if (priceModelVoMap != null && priceModelVoMap.get(entity.getProductCode()) != null && priceModelVoMap.get(entity.getProductCode()).getPrice() != null) {
                        BigDecimal price = priceModelVoMap.get(entity.getProductCode()).getPrice();
                        entity.setSupplyPrice(price);
                        entity.setTotalSaleAmount(price.multiply(new BigDecimal(entity.getTotalSaleQuantity())));
                        entity.setBoundGiftSaleAmount(price.multiply(new BigDecimal(entity.getBoundGiftSaleQuantity())));
                        entity.setBasicSaleAmount(price.multiply(new BigDecimal(entity.getBasicSaleQuantity())));
                        entity.setWaitMatchAmount(price.multiply(new BigDecimal(entity.getWaitMatchQuantity())));
                    }
                    result.add(entity);
                }
            }
            //以下是不累计的逻辑
            else {
                //政策已经排序，直接循环
                for (PromotionPolicyVO policy : promotionPolicyVOList) {
                    int minNum = 0;
                    if (CollectionUtils.isNotEmpty(policy.getPromotionPolicyProducts())) {
                        int counter = 0;
                        //第一次循环，确定最小数量
                        for (PromotionPolicyProductVO policyProductVO : policy.getPromotionPolicyProducts()) {
                            Integer remainNum = monthSaleRemainMap.get(policyProductVO.getProductCode());
                            //任一产品没有月度销售数据，直接将最小捆赠系数归0，并跳出循环
                            if (remainNum == null) {
                                minNum = 0;
                                break;
                            }
                            if (counter == 0 || minNum > remainNum / policyProductVO.getBindingCoefficient()) {
                                minNum = remainNum / policyProductVO.getBindingCoefficient();
                            }
                            counter++;
                        }
                        //第二次循环，根据最小数量+捆赠系数，计算政策实际占用产品数
                        if (minNum != 0) {
                            for (PromotionPolicyProductVO policyProductVO : policy.getPromotionPolicyProducts()) {
                                String productCode = policyProductVO.getProductCode();
                                monthSaleRemainMap.put(productCode, monthSaleRemainMap.get(productCode) - minNum * policyProductVO.getBindingCoefficient());
                            }
                        }
                    }
                }
                //政策占用完毕，根据剩余数量和累计待匹配数量，计算捆赠销售数量和基础销售数量
                for (Map.Entry<String, TpmDistributionCustomerMonthSaleEntity> entry : monthSaleMap.entrySet()) {
                    String productCode = entry.getKey();
                    Integer remainNum = monthSaleRemainMap.get(productCode);
                    TpmDistributionCustomerMonthSaleEntity entity = entry.getValue();
                    entity.setBoundGiftSaleQuantity(entity.getTotalSaleQuantity() - remainNum);
                    entity.setWaitMatchQuantity(0);
                    entity.setBasicSaleQuantity(remainNum);
                    //获取平台供货价
                    Set<String> productCodeSet = new HashSet<>();
                    productCodeSet.add(entity.getProductCode());
                    Map<String, PriceModelVo> priceModelVoMap = getPlatformSupplyPrice(customerErpCode, productCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
                    if (priceModelVoMap != null && priceModelVoMap.get(productCode) != null && priceModelVoMap.get(productCode).getPrice() != null) {
                        BigDecimal price = priceModelVoMap.get(productCode).getPrice();
                        entity.setSupplyPrice(price);
                        entity.setTotalSaleAmount(price.multiply(new BigDecimal(entity.getTotalSaleQuantity())));
                        entity.setBoundGiftSaleAmount(price.multiply(new BigDecimal(entity.getBoundGiftSaleQuantity())));
                        entity.setBasicSaleAmount(price.multiply(new BigDecimal(entity.getBasicSaleQuantity())));
                        entity.setWaitMatchAmount(price.multiply(new BigDecimal(entity.getWaitMatchQuantity())));
                    }
//                    entity.setRevertFlag(BooleanEnum.TRUE.getCapital());
                    result.add(entity);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(result)) {
            tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(result);
        }

        //新增加逻辑
        setNewDate(dto);
    }

    private void setNewDate(TpmDistributionCustomerMonthSaleDto dto) {
        //上月待匹配数量=同客户同产品的上月的“剩余待匹配数量”
        //上月销售组合数量=MIN(剩余上月待匹配数量，组合装销售总量）
        //当月销售组合数量=组合装销售总量-上月销售组合数量
        //上月基础销售数量=上月剩余待匹配数量-上月销售组合数量
        //当月基础销售数量=月度销售数量-手工已结案数量- 当月销售组合数量
        String month = dto.getDistributionCustomerMonthSaleYearMonth();
        if (StringUtils.isEmpty(month)) {
            return;
        }
        String lastMonth = month + "-01";
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM");
        lastMonth = dtf2.format(LocalDate.parse(lastMonth, dtf).minusMonths(1));

        log.info("分销客户月度销售报表还原1：lastMonth：{},month:{}", lastMonth, month);
        List<TpmDistributionCustomerMonthSaleEntity> lastMonthData = tpmDistributionCustomerMonthSaleEntityRepository.findByYearMonth(lastMonth);
        List<TpmDistributionCustomerMonthSaleEntity> thisMonthData = tpmDistributionCustomerMonthSaleEntityRepository.findByYearMonth(month);
        if (CollectionUtils.isEmpty(thisMonthData)) {
            return;
        }
        log.info("分销客户月度销售报表还原2:lastMonthData:{},thisMonthData:{}", JsonUtils.obj2JsonString(lastMonthData), JsonUtils.obj2JsonString(thisMonthData));

        Map<String, TpmDistributionCustomerMonthSaleEntity> lastMonthDataMap = lastMonthData.stream().collect(Collectors.toMap(o -> o.getCustomerCode() + o.getProductCode(), Function.identity(), (n, o) -> o));

        List<TpmDistributionCustomerMonthSaleEntity> update = new ArrayList<>();
        for (TpmDistributionCustomerMonthSaleEntity thisMonthDatum : thisMonthData) {
            TpmDistributionCustomerMonthSaleEntity one = lastMonthDataMap.get(thisMonthDatum.getCustomerCode() + thisMonthDatum.getProductCode());
            thisMonthDatum.setLastMonthNoMatchingQuantity((one == null || one.getWaitMatchQuantity() == null) ? BigDecimal.ZERO : new BigDecimal(one.getWaitMatchQuantity()));
            BigDecimal boundGiftSaleQuantity = new BigDecimal(Optional.ofNullable(thisMonthDatum.getBoundGiftSaleQuantity()).orElse(0));
            thisMonthDatum.setLastMonthSaleCombinationQuantity(thisMonthDatum.getLastMonthNoMatchingQuantity().compareTo(boundGiftSaleQuantity) <= 0 ? thisMonthDatum.getLastMonthNoMatchingQuantity() : boundGiftSaleQuantity);
            thisMonthDatum.setLastMonthBaseSaleQuantity(thisMonthDatum.getLastMonthNoMatchingQuantity().subtract(thisMonthDatum.getLastMonthSaleCombinationQuantity()));
            thisMonthDatum.setThisMonthSaleCombinationQuantity(boundGiftSaleQuantity.subtract(thisMonthDatum.getLastMonthSaleCombinationQuantity()));
            BigDecimal monthSaleQuantity = new BigDecimal(Optional.ofNullable(thisMonthDatum.getMonthSaleQuantity()).orElse(0));
            BigDecimal manualAuditSaleQuantity = Optional.ofNullable(thisMonthDatum.getManualAuditSaleQuantity()).orElse(BigDecimal.ZERO);
            thisMonthDatum.setBasicSaleQuantity(monthSaleQuantity.subtract(manualAuditSaleQuantity).subtract(thisMonthDatum.getThisMonthSaleCombinationQuantity()).intValue());
            TpmDistributionCustomerMonthSaleEntity one2 = new TpmDistributionCustomerMonthSaleEntity();
            one2.setId(thisMonthDatum.getId());
            one2.setLastMonthNoMatchingQuantity(thisMonthDatum.getLastMonthNoMatchingQuantity());
            one2.setLastMonthSaleCombinationQuantity(thisMonthDatum.getLastMonthSaleCombinationQuantity());
            one2.setLastMonthBaseSaleQuantity(thisMonthDatum.getLastMonthBaseSaleQuantity());
            one2.setThisMonthSaleCombinationQuantity(thisMonthDatum.getThisMonthSaleCombinationQuantity());
            one2.setBasicSaleQuantity(thisMonthDatum.getBasicSaleQuantity());
            update.add(one2);
        }
        if (CollectionUtils.isNotEmpty(update)) {
            tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(update);
        }
    }

    private Map<String, PriceModelVo> getPlatformSupplyPrice(String customerErpCode, Set<String> productCodeList, String yearMonth) {
        loginUserService.refreshAuthentication(null);
        SearchPriceDto searchPriceDto = new SearchPriceDto();
        searchPriceDto.setPriceTypeCode(PriceTypeEnum.PLATFORM_SUPPLY_PRICE.getDictCode());
        searchPriceDto.setDimensionItems(new ArrayList<>());
        SearchPriceDimensionItemDto customerDimension = new SearchPriceDimensionItemDto();
        customerDimension.setDimensionCode(PriceDimensionEnum.CUSTOMER.getDictCode());
        Set<String> customerCodeSet = new HashSet<>();
        customerCodeSet.add(customerErpCode);
        customerDimension.setRelateCodeSet(customerCodeSet);
        searchPriceDto.getDimensionItems().add(customerDimension);
        SearchPriceDimensionItemDto productDimension = new SearchPriceDimensionItemDto();
        productDimension.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
        productDimension.setRelateCodeSet(productCodeList);
        searchPriceDto.getDimensionItems().add(productDimension);
        searchPriceDto.setSearchTime(DateUtil.parse(yearMonth + "-01", DateUtil.DEFAULT_YEAR_MONTH_DAY));
        return priceModelVoService.handleSearchPrice(searchPriceDto);
    }

    /**
     * 批量修改
     *
     * @param distributionCustomerMonthSaleDtos
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchUpdate(List<TpmDistributionCustomerMonthSaleDto> distributionCustomerMonthSaleDtos) {
        Collection<TpmDistributionCustomerMonthSaleEntity> entities = nebulaToolkitService.copyCollectionByWhiteList(distributionCustomerMonthSaleDtos, TpmDistributionCustomerMonthSaleDto.class, TpmDistributionCustomerMonthSaleEntity.class, LinkedHashSet.class, ArrayList.class);
        tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(entities);
    }

    @Override
    public List<TpmDistributionCustomerMonthSaleRespVo> findDistribution(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSaleDto) {
        List<TpmDistributionCustomerMonthSaleEntity> list = tpmDistributionCustomerMonthSaleEntityRepository.findDistributionCustomerMonthSale(distributionCustomerMonthSaleDto);
        return this.nebulaToolkitService.copyCollectionByWhiteList(list
                , TpmDistributionCustomerMonthSaleEntity.class
                , TpmDistributionCustomerMonthSaleRespVo.class
                , HashSet.class
                , ArrayList.class)
                .stream()
                .collect(Collectors.toList());
    }

    @Override
    public BigDecimal getTotalSaleAmount(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale) {
        return this.tpmDistributionCustomerMonthSaleEntityRepository.getTotalSaleAmount(distributionCustomerMonthSale);
    }

    @Override
    public BigDecimal getYearTotalSaleAmount(TpmDistributionCustomerMonthSaleDto dto) {

        return this.tpmDistributionCustomerMonthSaleEntityRepository.getYearTotalSaleAmount(dto);
    }

    @Override
    public List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSalesByParams(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale) {
        return this.tpmDistributionCustomerMonthSaleEntityRepository.findCustomerMonthSalesByParams(distributionCustomerMonthSale);
    }

    /**
     * 是否有重复数据
     *
     * @param distributionCustomerMonthSaleDtos
     */
    @Override
    public void beRepeat(List<TpmDistributionCustomerMonthSaleDto> distributionCustomerMonthSaleDtos) {
        distributionCustomerMonthSaleDtos.forEach(e -> {
            Integer count = tpmDistributionCustomerMonthSaleEntityRepository.lambdaQuery()
                    .ne(TpmDistributionCustomerMonthSaleEntity::getId, e.getId())
                    .eq(TpmDistributionCustomerMonthSaleEntity::getCustomerCode, e.getCustomerCode())
                    .eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, e.getDistributionCustomerMonthSaleYearMonth())
                    .eq(TpmDistributionCustomerMonthSaleEntity::getChannelCode, e.getChannelCode())
                    .eq(TpmDistributionCustomerMonthSaleEntity::getSalesInstitutionCode, e.getSalesInstitutionCode())
                    .eq(TpmDistributionCustomerMonthSaleEntity::getBusinessFormatCode, e.getBusinessFormatCode())
                    .eq(TpmDistributionCustomerMonthSaleEntity::getProductCode, e.getProductCode()).count();
            if (count > 0) {
                throw new IllegalArgumentException("行id【" + e.getId() + "】在表中存在重复数据");
            }
        });
    }

    /**
     * 变量查询
     *
     * @param dto
     * @return
     */
    @Override
    public List<TpmDistributionCustomerMonthSaleRespVo> listForVariable(TpmDistributionCustomerMonthSaleDto dto, String yearMonthType) {
        if (StringUtils.isNotEmpty(dto.getCustomerCode())
                && StringUtils.isNotEmpty(dto.getSalesInstitutionCode())
                && StringUtils.isNotEmpty(dto.getBusinessFormatCode())
                && StringUtils.isNotEmpty(dto.getChannelCode())
                && StringUtils.isNotEmpty(dto.getDistributionCustomerMonthSaleYearMonth())
        ) {
            if (yearMonthType.equals("year")) {
                //判断为几月，如果为1月则查询上一年
                String year = dto.getDistributionCustomerMonthSaleYearMonth().substring(0, 4);
                String m = dto.getDistributionCustomerMonthSaleYearMonth().substring(5, dto.getDistributionCustomerMonthSaleYearMonth().length());
                StringBuilder start = new StringBuilder();
                StringBuilder end = new StringBuilder();
                if (m.equals("01")) {
                    start = start.append(Integer.parseInt(year) - 1).append("-01");
                    end = end.append(Integer.parseInt(year) - 1).append("-12");
                } else {
                    start = start.append(year).append("-01");
                    end = end.append(dto.getDistributionCustomerMonthSaleYearMonth());
                }
                List<TpmDistributionCustomerMonthSaleEntity> list = this.tpmDistributionCustomerMonthSaleEntityRepository.lambdaQuery()
                        .eq(TpmDistributionCustomerMonthSaleEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                        .eq(TpmDistributionCustomerMonthSaleEntity::getTenantCode, TenantUtils.getTenantCode())
                        .eq(StringUtils.isNotEmpty(dto.getCustomerCode()), TpmDistributionCustomerMonthSaleEntity::getCustomerCode, dto.getCustomerCode())
                        .eq(StringUtils.isNotEmpty(dto.getSalesInstitutionCode()), TpmDistributionCustomerMonthSaleEntity::getSalesInstitutionCode, dto.getSalesInstitutionCode())
                        .eq(StringUtils.isNotEmpty(dto.getBusinessFormatCode()), TpmDistributionCustomerMonthSaleEntity::getBusinessFormatCode, dto.getBusinessFormatCode())
                        .eq(StringUtils.isNotEmpty(dto.getChannelCode()), TpmDistributionCustomerMonthSaleEntity::getChannelCode, dto.getChannelCode())
                        .between(StringUtils.isNotEmpty(start) && StringUtils.isNotEmpty(end), TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, start.toString(), end.toString())
                        .in(CollectionUtils.isNotEmpty(dto.getIncludeProductCodeList()), TpmDistributionCustomerMonthSaleEntity::getProductCode, dto.getIncludeProductCodeList())
                        .eq(StringUtils.isNotEmpty(dto.getProductCode()), TpmDistributionCustomerMonthSaleEntity::getProductCode, dto.getProductCode())
                        .list();
                return (List<TpmDistributionCustomerMonthSaleRespVo>) nebulaToolkitService.copyCollectionByWhiteList(list, TpmDistributionCustomerMonthSaleEntity.class, TpmDistributionCustomerMonthSaleRespVo.class, HashSet.class, ArrayList.class);
            } else {
                List<TpmDistributionCustomerMonthSaleEntity> list = this.tpmDistributionCustomerMonthSaleEntityRepository.lambdaQuery()
                        .eq(TpmDistributionCustomerMonthSaleEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                        .eq(TpmDistributionCustomerMonthSaleEntity::getTenantCode, TenantUtils.getTenantCode())
                        .eq(StringUtils.isNotEmpty(dto.getCustomerCode()), TpmDistributionCustomerMonthSaleEntity::getCustomerCode, dto.getCustomerCode())
                        .eq(StringUtils.isNotEmpty(dto.getSalesInstitutionCode()), TpmDistributionCustomerMonthSaleEntity::getSalesInstitutionCode, dto.getSalesInstitutionCode())
                        .eq(StringUtils.isNotEmpty(dto.getBusinessFormatCode()), TpmDistributionCustomerMonthSaleEntity::getBusinessFormatCode, dto.getBusinessFormatCode())
                        .eq(StringUtils.isNotEmpty(dto.getChannelCode()), TpmDistributionCustomerMonthSaleEntity::getChannelCode, dto.getChannelCode())
                        .eq(StringUtils.isNotEmpty(dto.getProductCode()), TpmDistributionCustomerMonthSaleEntity::getProductCode, dto.getProductCode())
                        .eq(StringUtils.isNotEmpty(dto.getDistributionCustomerMonthSaleYearMonth()), TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, dto.getDistributionCustomerMonthSaleYearMonth())
                        .in(CollectionUtils.isNotEmpty(dto.getIncludeProductCodeList()), TpmDistributionCustomerMonthSaleEntity::getProductCode, dto.getIncludeProductCodeList())

                        .list();
                return (List<TpmDistributionCustomerMonthSaleRespVo>) nebulaToolkitService.copyCollectionByWhiteList(list, TpmDistributionCustomerMonthSaleEntity.class, TpmDistributionCustomerMonthSaleRespVo.class, HashSet.class, ArrayList.class);
            }

        }
        return Lists.newArrayList();
    }


    /**
     * 拆分客户查询
     *
     * @param dto
     * @return
     */
    @Override
    public List<TpmDistributionCustomerMonthSaleRespVo> listForSplitCustomer(TpmDistributionCustomerMonthSaleDto dto) {
        List<TpmDistributionCustomerMonthSaleEntity> list = tpmDistributionCustomerMonthSaleEntityRepository.listForSplitCustomer(dto);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return (List<TpmDistributionCustomerMonthSaleRespVo>) nebulaToolkitService.copyCollectionByWhiteList(list, TpmDistributionCustomerMonthSaleEntity.class, TpmDistributionCustomerMonthSaleRespVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSale(List<String> onlyDimensionList) {
        List<TpmDistributionCustomerMonthSaleEntity> list = this.tpmDistributionCustomerMonthSaleEntityRepository
                .lambdaQuery()
                .in(TpmDistributionCustomerMonthSaleEntity::getVerifyCode, onlyDimensionList)
                .list();

        return new ArrayList<>(this.nebulaToolkitService
                .copyCollectionByWhiteList(
                        list
                        , TpmDistributionCustomerMonthSaleEntity.class
                        , TpmDistributionCustomerMonthSaleRespVo.class
                        , HashSet.class
                        , ArrayList.class));

    }

    @Override
    @Transactional(rollbackFor = Exception.class, propagation = Propagation.NOT_SUPPORTED)
    public void pullData(String ds) {
        Assert.hasLength(ds, "ds时间[yyyyMMdd]不能为空!");
        try {
            Date date = DateUtil.date_yyyyMMdd.parse(ds);
            Assert.isTrue(ds.equals(DateUtil.date_yyyyMMdd.format(date)), "年月格式错误【yyyyMMdd】");
        } catch (Exception e) {
            throw new IllegalArgumentException("年月格式错误【yyyyMMdd】");
        }
        boolean lockSuccess = redisLockService.tryLock(DistributionCustomerMonthSaleConstants.GLOBAL_DISTRIBUTION_CUSTOMER_MONTH_SALE_LOCK + ds, TimeUnit.HOURS, 2);
        if (!lockSuccess) {
            log.error("分销客户月度销售接受到日销售数据处理中");
            return;
        }
        //根据传入日期字符获取财年财月
        String financialYear = ds.substring(0, 4);
        String financialMonth = String.format("%3s", ds.substring(4, 6)).replace(" ", "0");
        try {
            Page<Ce1MnjtFullVo2> fullVo2Page = null;
            Pageable pageable = PageRequest.of(1, 600);
            do {
                fullVo2Page = ce1MnjtSdkService.getMonthSummaryByFinancialYearAndFinancialMonth(pageable, financialYear, financialMonth);
                log.info("=====>    分销客户月度销售接受到日销售数据[{}],[{}/{}]  size[{}] <=====", ds,
                        fullVo2Page.getCurrent(), fullVo2Page.getPages(), fullVo2Page.getSize());
                pageable = pageable.next();
                if (CollectionUtil.isEmpty(fullVo2Page.getRecords())) {
                    return;
                }
                List<TpmDistributionCustomerMonthSaleDto> saleDtoList = buildSalesData(fullVo2Page.getRecords());

            } while (fullVo2Page.hasNext());
        } catch (Exception e) {
            log.error("分销客户月度销售接受到日销售数据异常:{}", e.getMessage());
        } finally {
            redisLockService.unlock(DistributionCustomerMonthSaleConstants.GLOBAL_DISTRIBUTION_CUSTOMER_MONTH_SALE_LOCK + ds);
        }
    }

    private List<TpmDistributionCustomerMonthSaleDto> buildSalesData(List<Ce1MnjtFullVo2> summaryData) {
        if (CollectionUtil.isEmpty(summaryData)) {
            return Collections.emptyList();
        }
        List<TpmDistributionCustomerMonthSaleDto> saleDtoList = Lists.newArrayList();
        //获取待填充数据
        Set<String> customerCodeSet = summaryData.stream().map(this::generateCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<String, CustomerVo> customerVoMap = null;
        if (CollectionUtils.isNotEmpty(customerCodeSet)) {
            List<CustomerVo> customerVoList = customerVoService.findBaseByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (CollectionUtils.isNotEmpty(customerVoList)) {
                customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
        }

        Set<String> productCodeSet = summaryData.stream().filter(k -> StringUtil.isNotEmpty(k.getProductCode()))
                .map(Ce1MnjtFullVo2::getProductCode).collect(Collectors.toSet());
        Map<String, ProductVo> productVoMap = null;
        if (CollectionUtils.isNotEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findByProductCodes(new ArrayList<>(productCodeSet));
            if (CollectionUtils.isNotEmpty(productVoList)) {
                productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            }
        }

        Set<String> salesOrgCodeSet = summaryData.stream().map(this::generateSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<String, SalesOrgVo> salesOrgVoMap = null;
        if (CollectionUtils.isNotEmpty(salesOrgCodeSet)) {
            List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findBySalesOrgCodesPost(new ArrayList<>(salesOrgCodeSet));
            if (CollectionUtils.isNotEmpty(salesOrgVoList)) {
                salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            }
        }

        //填充数据
        for (Ce1MnjtFullVo2 vo : summaryData) {
            TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
            if (customerVoMap != null && customerVoMap.get(generateCustomerCode(vo)) != null) {
                if (StringUtils.isEmpty(customerVoMap.get(generateCustomerCode(vo)).getBusinessModelCode())
                        || !CharSequenceUtil.equals(BUSINESS_MODEL_CODE, customerVoMap.get(generateCustomerCode(vo)).getBusinessModelCode())) {
                    continue;
                }
                dto.setCustomerName(customerVoMap.get(generateCustomerCode(vo)).getCustomerName());
            } else {
                continue;
            }

            dto.setBusinessFormatCode(vo.getProductTeamCode());
            dto.setSalesInstitutionCode(vo.getSaleOrgCode());
            dto.setChannelCode(vo.getDistributionChannelCode());
            dto.setCustomerCode(vo.getCustomerCode());
            dto.setDistributionCustomerMonthSaleYearMonth(vo.getFiscalYear() + "-" + String.format("%02d", Integer.valueOf(vo.getPeriod())));
            dto.setProductCode(vo.getProductCode());
            dto.setMonthSaleQuantity(vo.getSalesVolumes().intValue());
            dto.setMonthSaleAmount(new BigDecimal(vo.getSalesIncludingTaxNet()));
            dto.setRevertFlag(BooleanEnum.FALSE.getCapital());
            if (salesOrgVoMap != null && salesOrgVoMap.get(generateSalesOrgCode(vo)) != null) {
                dto.setSalesInstitutionName(salesOrgVoMap.get(generateSalesOrgCode(vo)).getSalesOrgName());
            }

            if (productVoMap != null && productVoMap.get(vo.getProductCode()) != null) {
                dto.setProductName(productVoMap.get(vo.getProductCode()).getProductName());
            }
            //验证唯一性
            String verifyCode = vo.getSaleOrgCode() +
                    vo.getDistributionChannelCode() +
                    vo.getProductTeamCode() +
                    vo.getCustomerCode() +
                    vo.getProductCode() +
                    vo.getFiscalYear() +
                    vo.getPeriod();

            dto.setVerifyCode(verifyCode);
            saleDtoList.add(dto);
        }
        return saleDtoList;
    }


    @Override
    @Transactional(rollbackFor = Exception.class, propagation = Propagation.NOT_SUPPORTED)
    public void batchSave(List<TpmDistributionCustomerMonthSaleDto> dtos) {
        if (CollectionUtil.isEmpty(dtos)) {
            return;
        }
        dtos = dtos.stream().filter(k -> StringUtil.isNotEmpty(k.getVerifyCode())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(dtos)) {
            return;
        }
        List<String> verifyCodeList = dtos.stream().filter(k -> StringUtil.isNotEmpty(k.getVerifyCode()))
                .map(TpmDistributionCustomerMonthSaleDto::getVerifyCode).distinct().collect(Collectors.toList());
        List<TpmDistributionCustomerMonthSaleEntity> oldSaleEntityList = tpmDistributionCustomerMonthSaleEntityRepository.findByVerifyCodeList(verifyCodeList);
        Map<String, TpmDistributionCustomerMonthSaleEntity> oldSaleEntityMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(oldSaleEntityList)) {
            oldSaleEntityMap.putAll(oldSaleEntityList.stream().collect(Collectors.toMap(TpmDistributionCustomerMonthSaleEntity::getVerifyCode, v -> v, (n, o) -> n)));
        }
        List<TpmDistributionCustomerMonthSaleEntity> newList = new ArrayList<>();
        List<TpmDistributionCustomerMonthSaleEntity> updateList = new ArrayList<>();
        Map<String, List<TpmDistributionCustomerMonthSaleDto>> saveOrUpdateMap = dtos.stream().collect(Collectors.groupingBy(TpmDistributionCustomerMonthSaleDto::getVerifyCode));
        for (Map.Entry<String, List<TpmDistributionCustomerMonthSaleDto>> one : saveOrUpdateMap.entrySet()) {
            TpmDistributionCustomerMonthSaleEntity oldEntity = oldSaleEntityMap.get(one.getKey());
            if (oldEntity == null) {
                TpmDistributionCustomerMonthSaleEntity newEntity = new TpmDistributionCustomerMonthSaleEntity();
                BeanUtils.copyProperties(one.getValue().get(0), newEntity);
                newEntity.setMonthSaleQuantity(one.getValue().get(0).getMonthSaleQuantity());
                newEntity.setMonthSaleAmount(BigDecimal.ZERO);
                newEntity.setMonthSaleQuantity(0);
                for (TpmDistributionCustomerMonthSaleDto dto : one.getValue()) {
                    newEntity.setMonthSaleAmount(newEntity.getMonthSaleAmount().add(Optional.ofNullable(dto.getMonthSaleAmount()).orElse(BigDecimal.ZERO)));
                    newEntity.setMonthSaleQuantity(newEntity.getMonthSaleQuantity() + Optional.ofNullable(dto.getMonthSaleQuantity()).orElse(0));
                }
                newEntity.setId(null);
                newEntity.setTenantCode(TenantUtils.getTenantCode());
                newEntity.setNumEnable(Optional.ofNullable(newEntity.getNumEnable()).orElse(0));
                newList.add(newEntity);
            } else {
                for (TpmDistributionCustomerMonthSaleDto dto : one.getValue()) {
                    oldEntity.setMonthSaleAmount(Optional.ofNullable(dto.getMonthSaleAmount()).orElse(BigDecimal.ZERO));
                    oldEntity.setMonthSaleQuantity(Optional.ofNullable(dto.getMonthSaleQuantity()).orElse(0));
                }
                oldEntity.setNumEnable(Optional.ofNullable(oldEntity.getNumEnable()).orElse(0));
                updateList.add(oldEntity);
            }
        }
        if (CollectionUtil.isNotEmpty(newList)) {
            tpmDistributionCustomerMonthSaleEntityRepository.saveBatch(newList);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(updateList);
        }
    }


    /**
     * 根据年月查客户信息
     *
     * @param distributionCustomerMonthSaleYearMonth
     * @return
     */
    @Override
    public List<TpmDistributionCustomerMonthSaleRespVo> findAllByYearMonth(String distributionCustomerMonthSaleYearMonth) {
        if (StringUtils.isBlank(distributionCustomerMonthSaleYearMonth)) {
            return null;
        }
        return tpmDistributionCustomerMonthSaleEntityRepository.findAllByYearMonth(distributionCustomerMonthSaleYearMonth);
    }

    /**
     * 根据客户信息查销售信息
     *
     * @param customerMonthSaleDtos
     * @return
     */
    @Override
    public List<TpmDistributionCustomerMonthSaleRespVo> findByCustomer(Collection<TpmDistributionCustomerMonthSaleDto> customerMonthSaleDtos) {
        if (CollectionUtils.isEmpty(customerMonthSaleDtos)) {
            return null;
        }
        return tpmDistributionCustomerMonthSaleEntityRepository.findByCustomer(customerMonthSaleDtos);
    }

    @Transactional
    @Override
    public Integer autoGenerateData(String yearMonth) {
        if (StringUtils.isEmpty(yearMonth)) {
            //yearMonth = DateUtil.DEFAULT_YEAR_MONTH;
            yearMonth = DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH);
        }
        //删除当月已生成的数据
        this.tpmDistributionCustomerMonthSaleEntityRepository.deleteAutoCreateData(yearMonth);

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parse(yearMonth + "-01", DateUtil.DEFAULT_YEAR_MONTH_DAY));
        calendar.add(Calendar.MONTH, -1);
        String lastYearMonth = DateUtil.getDateStrByFormat(calendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH);

        int total = 0;
        int current = 1;
        while (current < 1000) {
            Page page = new Page<>(current, 2000);
            log.info("分销客户月度销售表-根据上月待匹配数据自动生成数据 页码[{}] 数量[{}]", page.getCurrent(), page.getSize());
            current++;
            List<TpmDistributionCustomerMonthSaleEntity> autoCreateData = this.tpmDistributionCustomerMonthSaleEntityRepository.findAutoCreateData(lastYearMonth, page);
            log.info("分销客户月度销售表-根据上月待匹配数据自动生成数据 页码[{}] 结果[{}]", page.getCurrent(), autoCreateData.size());
            if (CollectionUtils.isEmpty(autoCreateData)) {
                break;
            }
            total += autoCreateData.size();
            for (TpmDistributionCustomerMonthSaleEntity entity : autoCreateData) {
                entity.setSupplyPrice(BigDecimal.ZERO);
                entity.setMonthSaleQuantity(0);
                entity.setMonthSaleAmount(BigDecimal.ZERO);
                entity.setTotalSaleQuantity(0);
                entity.setTotalSaleAmount(BigDecimal.ZERO);
                entity.setBoundGiftSaleQuantity(0);
                entity.setBoundGiftSaleAmount(BigDecimal.ZERO);
                entity.setBasicSaleQuantity(0);
                entity.setBasicSaleAmount(BigDecimal.ZERO);
                entity.setNumEnable(0);
                entity.setRidSaleQuantity(BigDecimal.ZERO);
                entity.setRidSaleAmount(BigDecimal.ZERO);
                entity.setManualAuditSaleQuantity(BigDecimal.ZERO);
                entity.setManualAuditSaleAmount(BigDecimal.ZERO);

                entity.setDistributorAnnualAmount(BigDecimal.ZERO);
                entity.setDistributorAnnualQuantity(BigDecimal.ZERO);
                entity.setLastMonthNoMatchingQuantity(BigDecimal.ZERO);
                entity.setLastMonthSaleCombinationQuantity(BigDecimal.ZERO);
                entity.setThisMonthSaleCombinationQuantity(BigDecimal.ZERO);
                entity.setLastMonthBaseSaleQuantity(BigDecimal.ZERO);
                entity.setAutoCreate(YesOrNoEnum.YES.getCode());

                entity.setId(UuidCrmUtil.general());
                entity.setDistributionCustomerMonthSaleYearMonth(yearMonth);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            }
            this.tpmDistributionCustomerMonthSaleEntityRepository.saveBatch(autoCreateData);
        }
        return total;
    }

    private String generateCustomerCode(Ce1MnjtFullVo2 vo) {
        if (StringUtils.isNotEmpty(vo.getCustomerCode()) && StringUtils.isNotEmpty(vo.getSaleOrgCode()) && StringUtils.isNotEmpty(vo.getDistributionChannelCode()) && StringUtils.isNotEmpty(vo.getProductTeamCode())) {
            return vo.getCustomerCode() + vo.getSaleOrgCode() + vo.getDistributionChannelCode() + vo.getProductTeamCode();
        }
        return null;
    }

    private String generateSalesOrgCode(Ce1MnjtFullVo2 vo) {
        if (StringUtils.isNotEmpty(vo.getSaleOrgCode()) && StringUtils.isNotEmpty(vo.getDistributionChannelCode()) && StringUtils.isNotEmpty(vo.getProductTeamCode())) {
            return vo.getDistributionChannelCode() + vo.getProductTeamCode() + vo.getSaleOrgCode();
        }
        return null;
    }

    /**
     * 用累计销售数量除以捆赠政策系数（向下取整），得出的最小数据作为捆赠基数
     *
     * @param entry                              客户+促销政策编码一致的月销售数据
     * @param customerProductPromotionPolicyList 促销政策产品列表
     * @return int
     * @author jiangyin
     * @date 2023/1/5 14:53
     */
    private int getMinBoundGiftQuantity(Map.Entry<String, List<TpmDistributionCustomerMonthSaleDto>> entry, List<PromotionPolicyProductVO> customerProductPromotionPolicyList) {
        int minBoundGiftQuantity = 0;
        for (TpmDistributionCustomerMonthSaleDto monthSaleDto : entry.getValue()) {
            //取月度销售数据对应的促销政策
            Optional<PromotionPolicyProductVO> productPromotionPolicy = customerProductPromotionPolicyList.stream().filter(o -> o.getProductCode().equals(monthSaleDto.getProductCode())).findFirst();
            if (productPromotionPolicy.isPresent()) {
                int currentBoundGiftQuantity = monthSaleDto.getMonthSaleQuantity() / productPromotionPolicy.get().getBindingCoefficient();
                if (minBoundGiftQuantity == 0) {
                    minBoundGiftQuantity = currentBoundGiftQuantity;
                } else if (minBoundGiftQuantity > currentBoundGiftQuantity) {
                    minBoundGiftQuantity = currentBoundGiftQuantity;
                }
            }
        }
        return minBoundGiftQuantity;
    }
}
