package com.biz.crm.tpm.business.distribution.customer.month.sale.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: yaoyongming
 * @date: 2023/3/20 11:03
 */
@Slf4j
@Component
public class DistributionCustomerMonthSaleImportsProcess implements ImportProcess<TpmDistributionCustomerMonthSaleImportVo> {

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    /**
     * 单次缓存的数量
     *
     * @return
     */
    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    /**
     * 数据处理
     *
     * @param data     待处理的数据集合，k-流水号，v-excel解析后的对象
     * @param paramsVo 任务公共参数
     * @param params   导入任务自定义参数
     * @return k-对应data的k，v-对应data的k对应的v处理异常描述信息，会回写到错误文件
     */
    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmDistributionCustomerMonthSaleImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
        List<TpmDistributionCustomerMonthSaleDto> dtoList = validate(data, params);
        tpmDistributionCustomerMonthSaleService.batchUpdate(dtoList);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())){
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return null;
    }

    /**
     * 数据验证及转换
     *
     * @param data
     * @param params
     * @return
     */
    private List<TpmDistributionCustomerMonthSaleDto> validate(LinkedHashMap<Integer, TpmDistributionCustomerMonthSaleImportVo> data, Map<String, Object> params) {
        List<TpmDistributionCustomerMonthSaleImportVo> importList = new ArrayList<>(data.values());

        List<TpmDistributionCustomerMonthSaleDto> dtoList = new ArrayList<>();
        //非空校验
        for (TpmDistributionCustomerMonthSaleImportVo importVo : importList) {
            Validate.notBlank(importVo.getId(), "行id，不能为空！");
            Validate.notNull(importVo.getRidSaleQuantity(), "月度剃量数量，不能为空！");
            Validate.notNull(importVo.getRidSaleAmount(), "月度剃量金额，不能为空！");

            TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
            dto.setId(importVo.getId());
            dto.setRidSaleAmount(importVo.getRidSaleAmount());
            dto.setRidSaleQuantity(importVo.getRidSaleQuantity());
            dto.setManualAuditSaleAmount(importVo.getManualAuditSaleAmount());
            dto.setManualAuditSaleQuantity(importVo.getManualAuditSaleQuantity());
            dto.setDistributorAnnualAmount(importVo.getDistributorAnnualAmount());
            dto.setDistributorAnnualQuantity(importVo.getDistributorAnnualQuantity());

            dtoList.add(dto);
        }



        return dtoList;
    }

    /**
     * 获取数据实体
     *
     * @return
     */
    @Override
    public Class<TpmDistributionCustomerMonthSaleImportVo> findCrmExcelVoClass() {
        return TpmDistributionCustomerMonthSaleImportVo.class;
    }

    /**
     * 获取业务对应的模板编码，全局唯一
     *
     * @return
     */
    @Override
    public String getTemplateCode() {
        return "TPM_DISTRIBUTION_CUSTOMER_MONTH_SALE_IMPORT";
    }

    /**
     * 获取业务对应的模板描述
     *
     * @return
     */
    @Override
    public String getTemplateName() {
        return "TPM分销客户月度销售表导入模板";
    }
}
